/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tspr.business.domain.position.service.PositionLabelServiceHelper;
import kd.tsc.tspr.business.domain.position.service.enums.PosPortraitOperateEnum;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;

public class PosPortraitHelper {
    private static final Log logger = LogFactory.getLog(PosPortraitHelper.class);
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    public static final String CACHE_KEY_PREFIX_PORTRAIT_POS_ID = "portrait_id_";
    public static final String CACHE_KEY_PREFIX_PORTRAIT_STATUS = "portrait_status_";
    public static final Integer CODE_SAVE_PORTRAIT_FIRST = -10;
    public static final Integer CODE_HAVE_PORTRAIT = 20;
    public static final Integer CODE_NO_PORTRAIT = -20;

    public BizResult operate(Long positionId, String positionInfo, PosPortraitOperateEnum posPortraitOperateEnum) {
        JSONObject completeTag;
        logger.info("PosPortraitHelper.operate.params.positionId\uff1a{};positionInfo:{};posPortraitOperateEnum:{}", new Object[]{positionId, positionInfo, posPortraitOperateEnum.getCode()});
        if (HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.POS_PORTRAIT_BTN.getCode()) && null != (completeTag = PositionLabelServiceHelper.getInstance().getLabelByPositionInfo(positionInfo))) {
            String data = completeTag.toJSONString();
            this.cache.put(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId, (Object)data, Integer.MAX_VALUE, TimeUnit.DAYS);
            BizResult bizResult = BizResults.success();
            bizResult.setData((Object)data);
            return bizResult;
        }
        if (this.saveOperate(posPortraitOperateEnum, positionId)) {
            return BizResults.failed((int)CODE_SAVE_PORTRAIT_FIRST, (String)"please save portrait first");
        }
        if (HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.COMMIT.getCode())) {
            this.commitOperate(positionId, positionInfo, posPortraitOperateEnum);
        }
        return BizResults.success();
    }

    public BizResult operates(Map<Long, String> positionMap, PosPortraitOperateEnum posPortraitOperateEnum) {
        logger.info("PosPortraitHelper.operate.params.positionMap\uff1a{};posPortraitOperateEnum:{}", (Object)JSON.toJSONString(positionMap), (Object)posPortraitOperateEnum.getCode());
        for (Map.Entry<Long, String> entry : positionMap.entrySet()) {
            Long positionId = entry.getKey();
            String positionInfo = entry.getValue();
            if (HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.POS_PORTRAIT_BTN.getCode())) {
                this.updatePorCache(positionId, positionInfo);
            }
            if (this.saveOperate(posPortraitOperateEnum, positionId)) {
                return BizResults.failed((int)CODE_SAVE_PORTRAIT_FIRST, (String)"please save portrait first");
            }
            if (!HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.COMMIT.getCode())) continue;
            this.commitOperate(positionId, positionInfo, posPortraitOperateEnum);
        }
        return BizResults.success();
    }

    private void updatePorCache(Long positionId, String positionInfo) {
        JSONObject completeTag = PositionLabelServiceHelper.getInstance().getLabelByPositionInfo(positionInfo);
        if (null != completeTag) {
            String data = completeTag.toJSONString();
            this.cache.put(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId, (Object)data, Integer.MAX_VALUE, TimeUnit.DAYS);
        }
    }

    private void commitOperate(Long positionId, String positionInfo, PosPortraitOperateEnum posPortraitOperateEnum) {
        String porInfo = (String)this.cache.get(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId);
        logger.info("PosPortraitHelper.operate.cache.code\uff1a{};porInfo:{}", (Object)posPortraitOperateEnum.getCode(), (Object)porInfo);
        if (HRStringUtils.isNotEmpty((String)porInfo)) {
            PositionLabelServiceHelper.getInstance().savePositionLabelToAi(positionId, porInfo, Boolean.FALSE);
        } else {
            PositionLabelServiceHelper.getInstance().savePositionLabelToAi(positionId, positionInfo, Boolean.TRUE);
            this.updatePorCache(positionId, positionInfo);
        }
    }

    private boolean saveOperate(PosPortraitOperateEnum posPortraitOperateEnum, Long positionId) {
        if (HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.SAVE.getCode())) {
            String status = (String)this.cache.get(CACHE_KEY_PREFIX_PORTRAIT_STATUS + positionId);
            if (HRStringUtils.equals((String)"edit", (String)status)) {
                return true;
            }
            String porInfo = (String)this.cache.get(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId);
            logger.info("PosPortraitHelper.operate.cache.code\uff1a{};porInfo:{}", (Object)posPortraitOperateEnum.getCode(), (Object)porInfo);
            if (HRStringUtils.isNotEmpty((String)porInfo)) {
                PositionLabelServiceHelper.getInstance().savePositionLabelToAi(positionId, porInfo, Boolean.FALSE);
            }
        }
        return false;
    }
}

