/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PositionBillDataHelper {
    public static List<Object> submitBill(String billPageNumber, List<Long> positionSnapIdList, List<Long> positionIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        int tag = 0;
        Long userId = TSCRequestContext.getUserId();
        Date dataNow = new Date();
        ArrayList billDys = Lists.newArrayListWithCapacity((int)positionSnapIdList.size());
        ArrayList numberList = Lists.newArrayListWithCapacity((int)positionSnapIdList.size());
        for (Long positionSnapId : positionSnapIdList) {
            DynamicObject billDyn = serviceHelper.generateEmptyDynamicObject();
            String number = CodeRuleServiceHelper.readNumber((String)billPageNumber, (DynamicObject)billDyn, null);
            numberList.add(number);
            billDyn.set("billno", (Object)number);
            billDyn.set("billstatus", (Object)"A");
            billDyn.set("creator", (Object)userId);
            billDyn.set("createtime", (Object)dataNow);
            billDyn.set("auditstatus", (Object)"A");
            billDyn.set("isexistsworkflow", (Object)Boolean.TRUE);
            billDyn.set("positionsnap", (Object)positionSnapId);
            billDyn.set("position", (Object)positionIds.get(tag));
            billDyn.set("datastatus", (Object)"2");
            billDys.add(billDyn);
            ++tag;
        }
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult operationResult = operationService.localInvokeOperation("submit", billDys.toArray(new DynamicObject[0]), OperateOption.create());
        if (!operationResult.isSuccess()) {
            numberList.clear();
        }
        return numberList;
    }

    public static void submitBillByUpdate(String billPageNumber, List<String> billNos, Map<String, Long> snapIdMap) {
        DynamicObject[] billDys;
        for (DynamicObject billDyn : billDys = PositionBillDataHelper.getPositionBillByBillNo(billPageNumber, billNos)) {
            String billno = billDyn.getString("billno");
            billDyn.set("billstatus", (Object)"A");
            billDyn.set("isexistsworkflow", (Object)Boolean.TRUE);
            billDyn.set("positionsnap", (Object)snapIdMap.get(billno));
            billDyn.set("datastatus", (Object)"2");
        }
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult operationResult = operationService.localInvokeOperation("submit", billDys, OperateOption.create());
        if (!operationResult.isSuccess()) {
            throw new KDBizException("\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25");
        }
    }

    public static DynamicObject[] getPositionBillByBillNo(String billPageNumber, List<String> billNoList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        QFilter billNoFilter = new QFilter("billno", "in", billNoList);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{billNoFilter});
    }

    public static DynamicObject getPositionBillByBillId(String billPageNumber, Long billId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        return serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)billId));
    }

    public static void updatePositionBill(String billPageNumber, List<Long> billIdList, Map<String, List<Object>> valueMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(billIdList.toArray());
        for (Map.Entry<String, List<Object>> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            List<Object> valueList = entry.getValue();
            int index = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set(key, valueList.get(index));
                ++index;
            }
        }
        serviceHelper.save(dynamicObjects);
    }

    public static DynamicObject[] getPositionBillByPositionId(Long positionId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionbill");
        QFilter positionFilter = new QFilter("position", "=", (Object)positionId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{positionFilter});
    }

    public static DynamicObject getPositionBillByBillNo(Long positionId, String billNo) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionbill");
        QFilter positionFilter = new QFilter("position", "=", (Object)positionId);
        positionFilter.and("billno", "=", (Object)billNo);
        return serviceHelper.loadDynamicObject(new QFilter[]{positionFilter});
    }

    public static Boolean checkSubmitPerm() {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (!superUser) {
            return PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tssrm", (String)"tssrm_positionbill", (String)"804f6478000000ac");
        }
        return true;
    }
}

