/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.advertising.service.AdvertUpadteHelper;
import kd.tsc.tspr.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tspr.business.domain.position.service.PositionDataHelper;
import kd.tsc.tspr.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tspr.business.domain.position.service.PositionResumeRuleHelper;
import kd.tsc.tspr.business.domain.position.service.bo.PosResumeRuleParamBO;
import kd.tsc.tsrbs.common.enums.rsm.RsmAssignTypeEnum;

public class PositionBillService {
    private static final Log LOGGER = LogFactory.getLog(PositionBillService.class);

    private PositionBillService() {
    }

    public static PositionBillService getInstance() {
        return new PositionBillService();
    }

    public void openPositionBillPage(String billPageNumber, DynamicObject positionBillDyn, IFormView view) {
        long positionBillId = positionBillDyn.getLong("id");
        String billStatus = positionBillDyn.getString("billstatus");
        Map<String, BillOperationStatus> billStatusMap = this.getStatusMap();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)positionBillId);
        billShowParameter.setFormId(billPageNumber);
        billShowParameter.setBillStatus(billStatusMap.get(billStatus));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setPageId(this.getPageId(positionBillId));
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void openNewPositionBillPage(String billPageNumber, Map<String, Object> parms, IFormView view) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(billPageNumber);
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.getCustomParams().putAll(parms);
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void openPositionPage(String formId, String targetKey, IFormView view, BillOperationStatus billStatus, OperationStatus status, Long pkId) {
        this.openPositionPage(formId, targetKey, view, billStatus, status, pkId, null);
    }

    public void openPositionPage(String formId, String targetKey, IFormView view, BillOperationStatus billStatus, OperationStatus status, Long pkId, Map<String, Object> parms) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (billStatus != null) {
            parameter.setBillStatus(billStatus);
        }
        if (status != null) {
            parameter.setStatus(status);
        }
        if (pkId != null) {
            parameter.setPkId((Object)pkId);
        }
        if (parms != null) {
            parameter.getCustomParams().putAll(parms);
        }
        String pageId = parameter.getPageId();
        view.showForm((FormShowParameter)parameter);
        view.getPageCache().put(formId, pageId);
    }

    public void savePositionBill(DynamicObject billDyn, DynamicObject positionDyn) {
        long positionId = positionDyn.getLong("id");
        if (positionId == 0L) {
            positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"position");
        }
        long positionBillId = billDyn.getLong("id");
        List<Long> positionIdList = Collections.singletonList(positionId);
        List<Long> positionSnapIds = PositionDataHelper.syncUpdatePositionSnapshot(new DynamicObject[]{positionDyn}, positionIdList, "2");
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)16);
        valueMap.put("positionsnap", Collections.singletonList(positionSnapIds));
        PositionBillDataHelper.updatePositionBill("tssrm_positionbill", Collections.singletonList(positionBillId), valueMap);
        String billNo = billDyn.getString("billno");
        HashMap positionValueMap = Maps.newHashMapWithExpectedSize((int)16);
        positionValueMap.put("billno", Collections.singletonList(billNo));
        positionValueMap.put("status", Collections.singletonList("A"));
        PositionDataHelper.updatePositionInfo("tssrm_position_add", positionIdList, (Map<String, List<Object>>)positionValueMap);
    }

    public void submitPositionBill(DynamicObject billDyn, DynamicObject positionDyn) {
        Object positionSnap = billDyn.get("positionsnap");
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"position");
        List<Long> positionIdList = Collections.singletonList(positionId);
        if (positionSnap == null) {
            this.savePositionBill(billDyn, positionDyn);
        } else {
            PositionDataHelper.syncUpdatePositionSnapshotBySnapIds(new DynamicObject[]{positionDyn}, Collections.singletonList(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"positionsnap")));
        }
        this.setPositionStatus(positionIdList, "B");
    }

    public void updatePositionStatus(DynamicObject billDyn, DynamicObject positionDyn) {
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"position");
        List<Long> positionIdList = Collections.singletonList(positionId);
        String positionStatus = positionDyn.getString("positionstatus");
        if ("B".equals(positionStatus) || "E".equals(positionStatus)) {
            this.setPositionStatus(positionIdList, null, "B");
        }
    }

    private void setPositionStatus(List<Long> positionIdList, String status) {
        this.setPositionStatus(positionIdList, status, null);
    }

    private void setPositionStatus(List<Long> positionIdList, String status, String positionstatus) {
        HashMap positionValueMap = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)status)) {
            positionValueMap.put("status", Collections.singletonList(status));
        }
        if (HRStringUtils.isNotEmpty((String)positionstatus)) {
            positionValueMap.put("positionstatus", Collections.singletonList(positionstatus));
        }
        PositionDataHelper.updatePositionInfo("tssrm_position_add", positionIdList, (Map<String, List<Object>>)positionValueMap);
    }

    public void auditPositionBill(Long positionBillId) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tssrm_positionbill", positionBillId);
        Long postionSnapId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"positionsnap");
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        this.setBillDataStatus(positionBillDyn);
        this.resumeRuleChange(postionSnapId);
        PositionDataHelper.syncUpdatePositionFromPostionSnap(postionSnapId);
        this.setPositionStatus(Collections.singletonList(positionId), "C", "A");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tssrm_position_add");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray((Object[])new Long[]{positionId});
        List<DynamicObject> collect = Arrays.stream(dynamicObjects).filter(this::isFirstSubmit).collect(Collectors.toList());
        if (collect.size() > 0) {
            OperationServiceHelper.executeOperate((String)"saveandcommit", (String)"tssrm_position_add", (DynamicObject[])collect.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        LOGGER.info("positionId:{}", (Object)positionId);
        try {
            new AdvertUpadteHelper().updateAdvertisementByPositionId(positionId);
            LOGGER.info("positionId:{}", (Object)positionId);
        }
        catch (Exception ex) {
            LOGGER.error("\u804c\u4f4d\u5ba1\u6838\u5931\u8d25", (Throwable)ex);
        }
    }

    private Boolean isFirstSubmit(DynamicObject dynamicObject) {
        String positionStatus = dynamicObject.getString("positionstatus");
        return HRStringUtils.equals((String)positionStatus, (String)"E") || HRStringUtils.equals((String)positionStatus, (String)"B");
    }

    public void submitedPositionBill(Long positionBillId) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tssrm_positionbill", positionBillId);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        this.setPositionStatus(Collections.singletonList(positionId), "D", null);
    }

    public void unSubmitedPositionBill(Long positionBillId) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tssrm_positionbill", positionBillId);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        this.setPositionStatus(Collections.singletonList(positionId), "A", null);
    }

    public void discarPositionBill(Long positionBillId) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tssrm_positionbill", positionBillId);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        positionBillDyn.set("datastatus", (Object)"0");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tssrm_positionbill");
        serviceHelper.saveOne(positionBillDyn);
        this.setPositionStatus(Collections.singletonList(positionId), "F", null);
    }

    public void auditNotPassPositionBill(Long positionBillId) {
        DynamicObject position;
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tssrm_positionbill", positionBillId);
        positionBillDyn.set("datastatus", (Object)"0");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tssrm_positionbill");
        serviceHelper.saveOne(positionBillDyn);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        List<Long> positionIdList = Collections.singletonList(positionId);
        DynamicObject[] positions = PositionDataHelper.getPositionObjByPositionIds(positionIdList);
        String positionStatus = null;
        if (positions.length != 0 && "E".equals((position = positions[0]).getString("positionstatus"))) {
            positionStatus = "B";
        }
        this.setPositionStatus(Collections.singletonList(positionId), "E", positionStatus);
    }

    public void rejectPositionBill(Long positionBillId, String operationKey) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tssrm_positionbill", positionBillId);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        String status = HRStringUtils.equals((String)"rejecttosubmit", (String)operationKey) ? "G" : "B";
        this.setPositionStatus(Collections.singletonList(positionId), status, null);
    }

    private void setBillDataStatus(DynamicObject positionBillDyn) {
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        DynamicObject[] positionBills = PositionBillDataHelper.getPositionBillByPositionId(positionId);
        List<DynamicObject> billList = Arrays.stream(positionBills).filter(positionBill -> HRStringUtils.equals((String)positionBill.getString("datastatus"), (String)"1")).collect(Collectors.toList());
        billList.forEach(bill -> bill.set("datastatus", (Object)"0"));
        positionBillDyn.set("datastatus", (Object)"1");
        billList.add(positionBillDyn);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionbill");
        serviceHelper.save(billList.toArray(new DynamicObject[0]));
    }

    private void resumeRuleChange(Long postionSnapId) {
        DynamicObject positionSnapDyn = PositionDataHelper.getPositionSnapDynById(postionSnapId);
        Long positionId = positionSnapDyn.getLong("positionid");
        DynamicObject[] positions = PositionDataHelper.getPositionObjByPositionIds(Collections.singletonList(positionId));
        if (positions.length == 0) {
            LOGGER.error("resumeRuleChange error,positionsnapId is: {}", (Object)positionSnapDyn);
            return;
        }
        DynamicObject position = positions[0];
        Long vid = position.getLong("vid");
        if (postionSnapId.equals(vid)) {
            this.addPositionResumeRule(position);
        } else {
            this.modifyPositionResumeRule(positionId, positionSnapDyn);
        }
    }

    private void addPositionResumeRule(DynamicObject positionDyn) {
        Long positionId = positionDyn.getLong("id");
        String number = positionDyn.getString("number");
        String positionName = positionDyn.getString("name");
        DynamicObjectCollection workaddrs = positionDyn.getDynamicObjectCollection("workaddr");
        StringBuilder sb = new StringBuilder();
        for (DynamicObject workaddr : workaddrs) {
            String city = workaddr.getDynamicObject("fbasedataid").getLocaleString("city.name").getLocaleValue();
            sb.append("\u3001");
            sb.append(city);
        }
        String workCity = "";
        if (sb.length() > 1) {
            workCity = sb.substring(1);
        }
        PosResumeRuleParamBO posResumeRuleParamBO = new PosResumeRuleParamBO();
        posResumeRuleParamBO.setPositionId(positionId);
        posResumeRuleParamBO.setPositionCode(number);
        posResumeRuleParamBO.setPositionName(positionName);
        Optional<String> workCityOptional = Optional.of(workCity);
        posResumeRuleParamBO.setPositionCity(workCityOptional);
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo(positionId);
        posResumeRuleParamBO.setHasEmail(manageInfo != null);
        PositionResumeRuleHelper.addWhenPositionCreate(Collections.singletonList(posResumeRuleParamBO));
    }

    private void modifyPositionResumeRule(Long positionId, DynamicObject positionSnapDyn) {
        String positionName = positionSnapDyn.getString("name");
        DynamicObjectCollection workaddrs = positionSnapDyn.getDynamicObjectCollection("workaddr");
        for (DynamicObject workaddr : workaddrs) {
            String city = workaddr.getDynamicObject("fbasedataid").getLocaleString("city.name").getLocaleValue();
            String keyWord = positionName + "\u3001" + city;
            PositionResumeRuleHelper.addOneAfterPositionExist(positionId, RsmAssignTypeEnum.EMAIL, keyWord);
        }
    }

    public void setBillStatusLbl(IFormView view, String billStatus) {
        if (HRStringUtils.equals((String)"A", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status1"});
            view.setVisible(Boolean.FALSE, new String[]{"status2", "status3", "status4", "status5", "status6", "status7"});
        } else if (HRStringUtils.equals((String)"B", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status3"});
            view.setVisible(Boolean.FALSE, new String[]{"status2", "status1", "status4", "status5", "status6", "status7"});
        } else if (HRStringUtils.equals((String)"F", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status5"});
            view.setVisible(Boolean.FALSE, new String[]{"status2", "status1", "status4", "status3", "status6", "status7"});
        } else if (HRStringUtils.equals((String)"G", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status2"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status4", "status3", "status6", "status7"});
        } else if (HRStringUtils.equals((String)"C", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status6"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status4", "status3", "status2", "status7"});
        } else if (HRStringUtils.equals((String)"E", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status7"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status4", "status3", "status2", "status6"});
        } else if (HRStringUtils.equals((String)"D", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status4"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status7", "status3", "status2", "status6"});
        }
    }

    public void setButtonVisable(IFormView view, String billstatus, Long positionId) {
        String positionStatus;
        BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
        BillOperationStatus billStatus = billShowParameter.getBillStatus();
        OperationStatus status = billShowParameter.getStatus();
        if (HRStringUtils.equals((String)"E", (String)billstatus) || HRStringUtils.equals((String)"C", (String)billstatus) || HRStringUtils.equals((String)"F", (String)billstatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"baritemap"});
        } else if (HRStringUtils.equals((String)"G", (String)billstatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_discard"});
            if (BillOperationStatus.VIEW.equals((Object)billStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_discard"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            } else if (BillOperationStatus.EDIT.equals((Object)billStatus)) {
                view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_discard"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            }
            String positionStatus2 = this.getPositionStatus(positionId);
            if ("E".equals(positionStatus2)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            }
        } else if (HRStringUtils.equals((String)"A", (String)billstatus) && "E".equals(positionStatus = this.getPositionStatus(positionId))) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save"});
        }
    }

    private String getPositionStatus(Long positionId) {
        List<Long> positionIdList = Collections.singletonList(positionId);
        DynamicObject[] positions = PositionDataHelper.getPositionObjByPositionIds(positionIdList);
        String positionStatus = null;
        if (positions.length != 0) {
            DynamicObject position = positions[0];
            positionStatus = position.getString("positionstatus");
        }
        return positionStatus;
    }

    private Map<String, BillOperationStatus> getStatusMap() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put("A", BillOperationStatus.VIEW);
        result.put("B", BillOperationStatus.SUBMIT);
        result.put("C", BillOperationStatus.AUDIT);
        result.put("D", BillOperationStatus.AUDIT);
        result.put("E", BillOperationStatus.AUDIT);
        result.put("F", BillOperationStatus.AUDIT);
        result.put("G", BillOperationStatus.VIEW);
        return result;
    }

    private String getPageId(Long positionBillId) {
        long currUserId = RequestContext.get().getCurrUserId();
        String localSessionId = RequestContext.get().getGlobalSessionId();
        return localSessionId + positionBillId + currUserId;
    }
}

