/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.position.service.HbssJobAdapter;
import kd.tsc.tspr.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tspr.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tspr.business.domain.position.service.PositionModelAdapter;
import kd.tsc.tspr.business.domain.position.service.enums.PositionPermEnum;
import kd.tsc.tspr.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tspr.common.entity.advertising.HandlerResult;
import kd.tsc.tsrbd.business.domain.offer.service.helper.JobFamilyScmHelper;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PositionDataHelper {
    private static final Log LOGGER = LogFactory.getLog(PositionDataHelper.class);
    private static final String VALID_STATUS = "0";
    private static final String INVALID_STATUS = "1";
    private static final Long EMPTY_BASE_DATA = 0L;
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tspr_position");

    private PositionDataHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Long queryDefaultRecProcByRecType(long recTypeId, long createOrgId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        QFilter qFilter = new QFilter("group", "=", (Object)recTypeId);
        qFilter.and("enable", "=", (Object)INVALID_STATUS);
        qFilter.and("createorg", "=", (Object)createOrgId);
        qFilter.and("isdefault", "=", (Object)INVALID_STATUS);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(new QFilter[]{qFilter});
        if (dynamicObjects.length == 0) {
            return null;
        }
        return dynamicObjects[0].getLong("id");
    }

    public static boolean isProcessMatchWithCategory(DynamicObject recProcDym, long recTypeId, long createOrgId) {
        if (recProcDym == null) {
            return false;
        }
        long recProcId = recProcDym.getLong("id");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        QFilter qFilter = new QFilter("group", "=", (Object)recTypeId);
        qFilter.and("enable", "=", (Object)INVALID_STATUS);
        qFilter.and("createorg", "=", (Object)createOrgId);
        qFilter.and("id", "=", (Object)recProcId);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(new QFilter[]{qFilter});
        return dynamicObjects.length != 0;
    }

    public static boolean isResumeRuleMatchWithCategory(DynamicObject resumeRuleDym, long recTypeId, long createOrgId) {
        if (resumeRuleDym == null) {
            return false;
        }
        long resumeRuleId = resumeRuleDym.getLong("id");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgresurule");
        QFilter qFilter = new QFilter("reccategory", "=", (Object)recTypeId);
        qFilter.and("enable", "=", (Object)INVALID_STATUS);
        qFilter.and("dependorg", "=", (Object)createOrgId);
        qFilter.and("id", "=", (Object)resumeRuleId);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(new QFilter[]{qFilter});
        return dynamicObjects.length != 0;
    }

    public static boolean isHrUser(Long userId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_user");
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        qFilter.and("source", "=", (Object)"HR");
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(new QFilter[]{qFilter});
        return dynamicObjects.length != 0;
    }

    public static List<Long> getParentPosCategoryId() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_poscat");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", PositionDataHelper.getAllPosCategoryId())};
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray("id,parent", filters);
        return Stream.of(result).map(object -> object.getLong("parent")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static List<Long> getAllPosCategoryId() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        String selectProperties = "id,poscategory";
        QFilter[] filters = new QFilter[]{new QFilter("id", "is not null", null)};
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray(selectProperties, filters);
        return Stream.of(result).map(object -> object.getLong("poscategory")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static List<Long> getAllWorkCountryId(IFormView iFormView) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        String selectProperties = "id,workcountry";
        QFilter[] filters = PositionDataHelper.getUseOrgFilters(iFormView);
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray(selectProperties, filters);
        return Stream.of(result).map(object -> object.getLong("workcountry")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static QFilter[] getUseOrgFilters(IFormView iFormView) {
        String useOrgId = iFormView.getPageCache().get("useOrgIdCache");
        QFilter qFilter = !HRStringUtils.isEmpty((String)useOrgId) ? new QFilter("createorg", "=", (Object)Long.valueOf(useOrgId)) : new QFilter("id", "is not null", null);
        return new QFilter[]{qFilter};
    }

    public static List<Long> getAllWorkCityId(IFormView iFormView) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        String selectProperties = "id,name,workcity";
        QFilter[] filters = PositionDataHelper.getUseOrgFilters(iFormView);
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray(selectProperties, filters);
        List<DynamicObject> positionList = Arrays.asList(result);
        return positionList.stream().map(object -> object.getLong("workcity")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static List<Long> getAllRecProcId(Long useOrgId) {
        QFilter[] filters;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        String selectProperties = "id,manageinfo.recruproc";
        if (useOrgId == 0L) {
            filters = new QFilter[]{};
        } else {
            QFilter qFilter = new QFilter("createorg", "=", (Object)useOrgId);
            filters = new QFilter[]{qFilter};
        }
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray(selectProperties, filters);
        return Stream.of(result).map(object -> object.getLong("manageinfo.recruproc")).distinct().collect(Collectors.toList());
    }

    public static void setFilterTimeRange(QFilter qFilter, String timeRangeType, boolean isOwner) {
        LocalDate startDate;
        if (!StringUtils.isEmpty((String)timeRangeType) && (startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType))) != null) {
            qFilter.and("createtime", ">", (Object)startDate);
        }
        if (isOwner) {
            Long userId = TSCRequestContext.getUserId();
            qFilter.and(new QFilter("creator", "=", (Object)userId).or("posprin.fbasedataid", "=", (Object)userId));
        }
    }

    public static List<Long> getChildPosCategoryId(List<Long> ids) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_poscat");
        QFilter[] filters = new QFilter[]{new QFilter("parent", "in", ids)};
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray("id,name", filters);
        return Stream.of(result).map(object -> object.getLong("id")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static long getPositionUseOrgIdByPositionId(Long positionId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOriginalOne("createorg", (Object)positionId);
        return dynamicObject.getLong("createorg");
    }

    public static long getEntryJobIdByPositionId(Long positionId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOriginalOne("entryjob", (Object)positionId);
        return dynamicObject == null ? 0L : dynamicObject.getLong("entryjob");
    }

    public static long getEntryPositionIdByPositionId(Long positionId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOriginalOne("entryposition", (Object)positionId);
        return dynamicObject.getLong("entryposition");
    }

    public static DynamicObject[] getPositionObjByPositionIds(List<Long> positionIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        return hrBaseServiceHelper.loadDynamicObjectArray(positionIds.toArray());
    }

    public static DynamicObject getPositionSnapDynById(Long positionSnapId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_position_snap");
        return serviceHelper.loadSingle((Object)positionSnapId);
    }

    public static DynamicObject getPositionBill(DynamicObject position) {
        if (position == null) {
            return null;
        }
        Long positionId = (Long)position.getPkValue();
        String billNo = position.getString("billno");
        LOGGER.info("getPositionBill positionId: {}, billNo: {}", (Object)positionId, (Object)billNo);
        if (positionId == null || StringUtils.isBlank((String)billNo)) {
            return null;
        }
        return PositionBillDataHelper.getPositionBillByBillNo(positionId, billNo);
    }

    public static void commitPosition(DynamicObject[] dynamicObjects) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("positionstatus", (Object)"A");
            DynamicObject positionBill = PositionDataHelper.getPositionBill(dynamicObject);
            if (positionBill == null) {
                dynamicObject.set("status", (Object)"C");
            }
            dynamicObject.set("positionpriority", (Object)1);
            dynamicObject.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        }
        hrBaseServiceHelper.update(dynamicObjects);
    }

    public static void abandonPositionSnapshot(List<Long> positionIds) {
        DynamicObject[] dynamicObjects;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position_snap");
        QFilter filter = new QFilter("positionId", "in", positionIds);
        QFilter isAbandonFilter = new QFilter("isabandon", "=", (Object)VALID_STATUS);
        QFilter[] filters = new QFilter[]{filter, isAbandonFilter};
        for (DynamicObject dynamicObject : dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(filters)) {
            dynamicObject.set("isabandon", (Object)INVALID_STATUS);
        }
        hrBaseServiceHelper.update(dynamicObjects);
    }

    public static List<Long> syncUpdatePositionSnapshot(DynamicObject[] dynamicObjects, List<Long> positionIds) {
        return PositionDataHelper.syncUpdatePositionSnapshot(dynamicObjects, positionIds, VALID_STATUS);
    }

    public static List<Long> syncUpdatePositionSnapshot(DynamicObject[] dynamicObjects, List<Long> positionIds, String status) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position_snap");
        ArrayList<Long> positionSnapshotIds = new ArrayList<Long>(10);
        DynamicObjectCollection posSnapObjs = new DynamicObjectCollection();
        long[] posSnapPkIds = ORM.create().genLongIds("tspr_position_snap", dynamicObjects.length);
        int index = 0;
        for (DynamicObject posObj : dynamicObjects) {
            DynamicObject posSnapObj = BusinessDataServiceHelper.newDynamicObject((String)"tspr_position_snap");
            HRDynamicObjectUtils.copy((DynamicObject)posObj, (DynamicObject)posSnapObj, PositionDataHelper.getIgnoreKey());
            posSnapObj.set("id", (Object)posSnapPkIds[index]);
            posSnapObj.set("positionid", (Object)positionIds.get(index));
            posSnapObj.set("isabandon", (Object)status);
            posSnapObjs.add((Object)posSnapObj);
            positionSnapshotIds.add(posSnapPkIds[index]);
            ++index;
        }
        hrBaseServiceHelper.save(posSnapObjs);
        return positionSnapshotIds;
    }

    public static void syncUpdatePositionSnapshotBySnapIds(DynamicObject[] dynamicObjects, List<Long> positionSnapIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_position_snap");
        DynamicObject[] positionSnapDys = serviceHelper.loadDynamicObjectArray(positionSnapIds.toArray());
        int index = 0;
        for (DynamicObject posObj : dynamicObjects) {
            DynamicObject positionSnapDyn = positionSnapDys[index];
            long positionSnapId = positionSnapDyn.getLong("id");
            HRDynamicObjectUtils.copy((DynamicObject)posObj, (DynamicObject)positionSnapDyn, PositionDataHelper.getIgnoreKey());
            positionSnapDyn.set("id", (Object)positionSnapId);
            ++index;
        }
        serviceHelper.save(positionSnapDys);
    }

    public static void syncUpdatePositionFromPostionSnap(Long positionSnapId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_position_snap");
        QFilter idFilter = new QFilter("id", "=", (Object)positionSnapId);
        DynamicObject posSnapDyn = serviceHelper.loadDynamicObject(idFilter);
        if (posSnapDyn == null) {
            LOGGER.error("positionSnapId is: {}", (Object)positionSnapId);
            return;
        }
        HRBaseServiceHelper positionServerHelper = new HRBaseServiceHelper("tssrm_position_add");
        Long positionId = posSnapDyn.getLong("positionid");
        QFilter positionIdFilter = new QFilter("id", "=", (Object)positionId);
        DynamicObject positionDyn = positionServerHelper.loadDynamicObject(positionIdFilter);
        if (positionDyn == null) {
            LOGGER.error("positionSnapId is: {}", (Object)positionSnapId);
            LOGGER.error("positionId is: {}", (Object)positionId);
            return;
        }
        HRDynamicObjectUtils.copy((DynamicObject)posSnapDyn, (DynamicObject)positionDyn, PositionDataHelper.getIgnoreKey());
        positionDyn.set("id", (Object)positionId);
        positionServerHelper.saveOne(positionDyn);
        posSnapDyn.set("isabandon", (Object)VALID_STATUS);
        PositionDataHelper.abandonPositionSnapshot(Collections.singletonList(positionId));
        serviceHelper.saveOne(posSnapDyn);
    }

    private static Set<String> getIgnoreKey() {
        HashSet keyList = Sets.newHashSetWithExpectedSize((int)16);
        keyList.add("creator");
        keyList.add("createtime");
        keyList.add("modifier");
        keyList.add("modifytime");
        return keyList;
    }

    public static void updatePositionVId(DynamicObject[] dynamicObjects, List<Long> positionSnapIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("vid", (Object)positionSnapIds.get(index));
            ++index;
        }
        hrBaseServiceHelper.update(dynamicObjects);
    }

    public static void updatePositionInfo(String positionPageNumber, List<Long> positionIds, Map<String, List<Object>> valueMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(positionPageNumber);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(positionIds.toArray());
        PositionDataHelper.updatePositionInfo(positionPageNumber, dynamicObjects, valueMap);
    }

    public static void updatePositionInfo(String positionPageNumber, DynamicObject[] dynamicObjects, Map<String, List<Object>> valueMap) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(positionPageNumber);
        for (Map.Entry<String, List<Object>> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            List<Object> valueList = entry.getValue();
            int index = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set(key, valueList.get(index));
                ++index;
            }
        }
        hrBaseServiceHelper.update(dynamicObjects);
    }

    public static DynamicObject queryOneByPositionId(Long positionId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        return hrBaseServiceHelper.queryOne((Object)positionId);
    }

    public static DynamicObject loadOneByPositionId(Long positionId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        return hrBaseServiceHelper.loadSingle((Object)positionId);
    }

    public static void updatePositionStatusByPositionId(Long positionId, String positionStatus) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)positionId);
        dynamicObject.set("positionstatus", (Object)positionStatus);
        dynamicObject.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        if ("D".equals(positionStatus)) {
            dynamicObject.set("positionpriority", (Object)0);
        }
        hrBaseServiceHelper.updateOne(dynamicObject);
    }

    public static DynamicObject[] findPositions(List<Long> ids, String prop) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return HELPER.query(prop, qFilter.toArray());
    }

    public static DynamicObject findPostionByName(String positionName, String prop) {
        QFilter qFilter = new QFilter("name", "=", (Object)positionName);
        DynamicObject[] positions = HELPER.query(prop, qFilter.toArray());
        if (positions != null && positions.length > 0) {
            return positions[0];
        }
        return null;
    }

    public static void updateCandidateNumByPositionId(Long positionId, Long candidateNum) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        QFilter filter = new QFilter("id", "=", (Object)positionId);
        DynamicObject dynamicObject = hrBaseServiceHelper.loadDynamicObject(new QFilter[]{filter});
        dynamicObject.set("candidatornum", (Object)candidateNum);
        hrBaseServiceHelper.updateOne(dynamicObject);
    }

    public static boolean hasPositionPerm(Long positionId) {
        List<Long> hashPermPositionIds = PositionDataHelper.getHashPermPositionIds();
        return hashPermPositionIds.contains(positionId);
    }

    public static List<Long> getHashPermPositionIds() {
        List<QFilter> positionPermFilter = PositionDataHelper.getPositionPermFilter();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_position");
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id", positionPermFilter.toArray(new QFilter[0]));
        return Arrays.stream(dys).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }

    private static List<QFilter> getPositionPermFilter() {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)16);
        ImmutableList positionPermEnums = ImmutableList.of((Object)((Object)PositionPermEnum.ADMIN_ORG), (Object)((Object)PositionPermEnum.ORG), (Object)((Object)PositionPermEnum.SEV_LEVEL));
        filters.add(PositionPermService.getInstance((List<PositionPermEnum>)positionPermEnums).getHavePermPositionQFilter());
        return filters;
    }

    public static List<Long> getEnableBosOrgStructure() {
        HRBaseServiceHelper bosOrgStructureHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter viewFilter = new QFilter("view.id", "=", (Object)24L);
        QFilter enableFilter = new QFilter("enable", "=", (Object)INVALID_STATUS);
        DynamicObject[] orgStructs = bosOrgStructureHelper.query("id,org.id", new QFilter[]{viewFilter.and(enableFilter)}, "level asc");
        ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)orgStructs.length);
        for (DynamicObject orgStruct : orgStructs) {
            Long orgId = orgStruct.getLong("org.id");
            orgIdList.add(orgId);
        }
        return orgIdList;
    }

    public static DynamicObject[] getWorkAddrByIds(List<Long> addrIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_workaddr");
        QFilter idFilter = new QFilter("id", "in", addrIds);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    private static void putWorkCityFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        QFilter qFilter = new QFilter("level", "=", (Object)2);
        qFilter.and("country", "=", (Object)1000001);
        QFilter qOutSideChinaFileter = new QFilter("level", "=", (Object)1);
        qOutSideChinaFileter.and("country", "!=", (Object)1000001);
        qFilter.or(qOutSideChinaFileter);
        DynamicObject dynamicObject = dataEntity.getDynamicObject("workcountry");
        if (dynamicObject != null) {
            qFilter.and("country", "=", (Object)dynamicObject.getLong("id"));
        }
        QFILTER_PROPERTYMAP.put("workcity", qFilter);
    }

    private static void putRecProcFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        DynamicObject createOrg;
        DynamicObject recruitCategory = dataEntity.getDynamicObject("reccategory");
        QFilter qFilter = new QFilter("enable", "=", (Object)INVALID_STATUS);
        if (recruitCategory != null) {
            qFilter.and("group", "=", (Object)recruitCategory.getLong("id"));
        }
        if ((createOrg = dataEntity.getDynamicObject("createorg")) != null) {
            qFilter.and("createorg", "=", (Object)createOrg.getLong("id"));
        }
        QFILTER_PROPERTYMAP.put("recruproc", qFilter);
    }

    private static void putResumeRuleFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        DynamicObject createOrg;
        DynamicObject recruitCategory = dataEntity.getDynamicObject("reccategory");
        QFilter qFilter = new QFilter("enable", "=", (Object)INVALID_STATUS);
        if (recruitCategory != null) {
            qFilter.and("reccategory", "=", (Object)recruitCategory.getLong("id"));
        }
        if ((createOrg = dataEntity.getDynamicObject("createorg")) != null) {
            qFilter.and("dependorg", "=", (Object)createOrg.getLong("id"));
        }
        QFILTER_PROPERTYMAP.put("cfgresurule", qFilter);
    }

    private static void putJobFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        DynamicObject jobScm = dataEntity.getDynamicObject("jobscm");
        QFilter jobScmFilter = JobFamilyScmHelper.getJobScmFilter((DynamicObject)jobScm);
        QFILTER_PROPERTYMAP.put("jobscm", jobScmFilter);
        Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
            Long jobScmId = jobScm.getLong("id");
            QFilter jobFilter = new QFilter("jobscm", "=", (Object)jobScmId);
            QFILTER_PROPERTYMAP.put("entryjob", jobFilter);
        });
        DynamicObject jobDynamicObject = dataEntity.getDynamicObject("entryjob");
        if (jobDynamicObject != null) {
            long jobId = jobDynamicObject.getLong("id");
            DynamicObject jobDym = HbssJobAdapter.queryJobDymById(jobId);
            PositionDataHelper.putJobLevelFilter(dataEntity, QFILTER_PROPERTYMAP, jobDym);
            PositionDataHelper.putJobGradeFilter(dataEntity, QFILTER_PROPERTYMAP, jobDym);
        }
    }

    public static void putJobLevelFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP, DynamicObject jobDym) {
        long lowJobLevel = jobDym.getLong("lowjoblevel");
        long highJobLevel = jobDym.getLong("highjoblevel");
        if (lowJobLevel != 0L && highJobLevel != 0L) {
            long highJobLevelChoose = highJobLevel;
            DynamicObject HighJobLevelDynamicObject = dataEntity.getDynamicObject("highjoblevel");
            if (HighJobLevelDynamicObject != null) {
                highJobLevelChoose = HighJobLevelDynamicObject.getLong("id");
            }
            QFILTER_PROPERTYMAP.put("lowjoblevel", new QFilter("id", "in", HbssJobAdapter.getJobLevelRangeByLevelId(jobDym.getLong("id"))));
            long lowJobLevelChoose = lowJobLevel;
            DynamicObject lowJobLevelDynamicObject = dataEntity.getDynamicObject("lowjoblevel");
            if (lowJobLevelDynamicObject != null) {
                lowJobLevelChoose = lowJobLevelDynamicObject.getLong("id");
            }
            QFILTER_PROPERTYMAP.put("highjoblevel", new QFilter("id", "in", HbssJobAdapter.getJobLevelRangeByLevelId(jobDym.getLong("id"))));
        }
    }

    public static void putJobGradeFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP, DynamicObject jobDym) {
        long lowJobGrade = jobDym.getLong("lowjobgrade");
        long highJobGrade = jobDym.getLong("highjobgrade");
        if (lowJobGrade != 0L && highJobGrade != 0L) {
            long highJobGradeChoose = highJobGrade;
            DynamicObject HighJobGradeDynamicObject = dataEntity.getDynamicObject("highjobgrade");
            if (HighJobGradeDynamicObject != null) {
                highJobGradeChoose = HighJobGradeDynamicObject.getLong("id");
            }
            QFILTER_PROPERTYMAP.put("lowjobgrade", new QFilter("id", "in", HbssJobAdapter.getJobGradeRangeByGradeId(jobDym.getLong("id"))));
            long lowJobGradeChoose = lowJobGrade;
            DynamicObject lowJobGradeDynamicObject = dataEntity.getDynamicObject("lowjobgrade");
            if (lowJobGradeDynamicObject != null) {
                lowJobGradeChoose = lowJobGradeDynamicObject.getLong("id");
            }
            QFILTER_PROPERTYMAP.put("highjobgrade", new QFilter("id", "in", HbssJobAdapter.getJobGradeRangeByGradeId(jobDym.getLong("id"))));
        }
    }

    public static Map<Long, String> generatePositionInfosJsonString(List<Long> positionIds) {
        DynamicObject[] positionObjs = PositionDataHelper.getPositionObjByPositionIds(positionIds);
        return Arrays.stream(positionObjs).collect(Collectors.toMap(position -> position.getLong("id"), PositionDataHelper::generatePositionJsonString));
    }

    public static String generatePositionJsonString(DynamicObject position) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("title", (Object)position.getString("name"));
        DynamicObject posCategory = position.getDynamicObject("poscategory");
        HashMap categoryMap = Maps.newHashMapWithExpectedSize((int)16);
        if (posCategory == null) {
            categoryMap.put("first_class", "");
            categoryMap.put("second_class", "");
            categoryMap.put("third_class", "");
        } else {
            String posCategoryName = posCategory.getString("name");
            String parentName = posCategory.getString("parent.name");
            Long parentId = posCategory.getLong("parent.id");
            String firstName = PositionDataHelper.getPoscatParentName(parentId);
            categoryMap.put("first_class", firstName);
            categoryMap.put("second_class", parentName);
            categoryMap.put("third_class", posCategoryName);
        }
        jsonObject.put("job_category", (Object)categoryMap);
        jsonObject.put("job_level", (Object)"");
        jsonObject.put("job_similar", Collections.emptyList());
        DynamicObjectCollection workaddrs = position.getDynamicObjectCollection("workaddr");
        ArrayList workAddrList = Lists.newArrayListWithCapacity((int)workaddrs.size());
        HashSet citySet = Sets.newHashSetWithExpectedSize((int)workaddrs.size());
        for (DynamicObject workaddr : workaddrs) {
            HashMap workAddrMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject workAddr = workaddr.getDynamicObject("fbasedataid");
            String city = workAddr.getLocaleString("city.name").getLocaleValue();
            if (citySet.contains(city)) continue;
            String country = workAddr.getLocaleString("country.name").getLocaleValue();
            workAddrMap.put("country", country);
            workAddrMap.put("city", city);
            workAddrList.add(workAddrMap);
            citySet.add(city);
        }
        jsonObject.put("work_address", (Object)workAddrList);
        String holdfftyp = position.getString("holdofftyp.name");
        if (null != holdfftyp) {
            holdfftyp = holdfftyp.replace("\u4efb\u804c", "");
        }
        jsonObject.put("position_type", (Object)holdfftyp);
        jsonObject.put("school_title", Collections.emptyList());
        jsonObject.put("school_type", Collections.emptyList());
        jsonObject.put("is_oversea_education", (Object)"");
        jsonObject.put("benchmark_school", Collections.emptyList());
        String mineducation = position.getString("education.name");
        jsonObject.put("minimum_education", (Object)mineducation);
        jsonObject.put("first_education", (Object)"");
        jsonObject.put("major", Collections.emptyList());
        Long holdfftypeId = position.getLong("holdofftyp.id");
        if (holdfftypeId.equals(1010L)) {
            jsonObject.put("is_full_time", (Object)"Y");
        } else {
            jsonObject.put("is_full_time", (Object)"N");
        }
        HashMap salaryMap = Maps.newHashMapWithExpectedSize((int)16);
        salaryMap.put("down", String.valueOf(position.get("salarydown")));
        salaryMap.put("up", String.valueOf(position.get("salaryup")));
        salaryMap.put("is_unlimited", String.valueOf(position.getBoolean("issalarynego")));
        jsonObject.put("salary", (Object)salaryMap);
        jsonObject.put("benchmark_company", Collections.emptyList());
        HashMap workDurationMap = Maps.newHashMapWithExpectedSize((int)16);
        workDurationMap.put("down", String.valueOf(position.get("workexpdown")));
        workDurationMap.put("up", String.valueOf(position.get("workexpup")));
        workDurationMap.put("is_unlimited", String.valueOf(position.getBoolean("isworkexplimit")));
        jsonObject.put("work_duration", (Object)workDurationMap);
        jsonObject.put("industry", Collections.emptyList());
        jsonObject.put("is_management", (Object)"");
        jsonObject.put("is_oversea_employment", (Object)"");
        jsonObject.put("project", Collections.emptyList());
        jsonObject.put("project_count", (Object)"");
        jsonObject.put("job_skill", Collections.emptyList());
        jsonObject.put("language_skill", Collections.emptyList());
        jsonObject.put("ability", Collections.emptyList());
        jsonObject.put("quality", Collections.emptyList());
        jsonObject.put("certificate", (Object)"");
        jsonObject.put("domain", (Object)"");
        jsonObject.put("duty_time", (Object)"");
        HashMap ageMap = Maps.newHashMapWithExpectedSize((int)16);
        ageMap.put("down", String.valueOf(position.get("agedown")));
        ageMap.put("up", String.valueOf(position.get("ageup")));
        ageMap.put("is_unlimited", String.valueOf(position.getBoolean("isagelimit")));
        jsonObject.put("age", (Object)ageMap);
        jsonObject.put("bonus", Collections.emptyList());
        jsonObject.put("is_avoid_relatives", (Object)"");
        jsonObject.put("avoid_company", Collections.emptyList());
        jsonObject.put("raw_text", (Object)position.getString("anoposrequirement"));
        String posInfo = jsonObject.toJSONString();
        return posInfo;
    }

    private static String removeRepeatCitys(String positionInfo) {
        JSONArray cityArray = new JSONArray();
        HashSet citySet = Sets.newHashSetWithExpectedSize((int)5);
        JSONObject posInfo = JSON.parseObject((String)positionInfo);
        JSONArray citys = posInfo.getJSONArray("work_address");
        if (null != citys && citys.size() > 0) {
            String city = citys.getString(0);
            cityArray.add((Object)city);
            citySet.add(city);
            for (int i = 1; i < citys.size(); ++i) {
                if (citySet.contains(citys.getString(i))) continue;
                cityArray.add((Object)citys.getString(i));
                citySet.add(citys.getString(i));
            }
        }
        posInfo.put("work_address", (Object)cityArray);
        positionInfo = posInfo.toJSONString();
        return positionInfo;
    }

    private static String getPoscatParentName(Long poscatId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_poscat");
        DynamicObject poscat = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)poscatId));
        return poscat.getString("parent.name");
    }

    public static String getPageId(String positionId) {
        return PositionDataHelper.getPageId(positionId, "tssrm");
    }

    public static String getPageId(String positionId, String appid) {
        long currUserId = RequestContext.get().getCurrUserId();
        String globalSessionId = RequestContext.get().getGlobalSessionId();
        StringBuilder pageId = new StringBuilder(String.valueOf(currUserId));
        pageId.append(positionId);
        pageId.append(globalSessionId);
        pageId.append(appid);
        return pageId.toString();
    }

    public static void updatePubCountByPositionId(Map<Long, HandlerResult> positionAdvCounts, List<Long> positionIds) {
        DynamicObject[] positions;
        String props = "id,erradvcount,succadvcount,stopadvcount,modifytime";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tssrm_position_view");
        for (DynamicObject position : positions = serviceHelper.query(props, new QFilter("id", "in", positionIds).toArray())) {
            long positionId = position.getLong("id");
            HandlerResult handlerResult = positionAdvCounts.get(positionId);
            position.set("erradvcount", (Object)handlerResult.getErrorCount());
            position.set("succadvcount", (Object)handlerResult.getSuccessCount());
            position.set("stopadvcount", (Object)handlerResult.getStopCount());
            position.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        }
        HELPER.save(positions);
    }

    public static DynamicObject[] getPositionDts(List<Map<String, Object>> searchFieldsList) {
        List<Long> positionIds = PositionDataHelper.getHashPermPositionIds();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_position");
        QFilter qFilter = new QFilter("id", "in", positionIds);
        if (searchFieldsList != null) {
            for (Map<String, Object> searchFieldsMap : searchFieldsList) {
                String value = ((ArrayList)searchFieldsMap.get("value")).get(0).toString();
                ArrayList fieldNameList = (ArrayList)searchFieldsMap.get("fieldName");
                if (fieldNameList.contains("creatorname")) {
                    qFilter.and(new QFilter("number", "like", (Object)("%" + value + "%")).or(new QFilter("name", "like", (Object)("%" + value + "%"))).or(new QFilter("creator", "in", PositionDataHelper.getUserIds(value))));
                    continue;
                }
                qFilter.and(new QFilter("number", "like", (Object)("%" + value + "%")).or(new QFilter("name", "like", (Object)("%" + value + "%"))));
            }
        }
        return hrBaseServiceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static List<Map<String, Object>> getRecruprocData(Long positionId) {
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo(Long.valueOf(positionId.toString()));
        if (manageInfo == null) {
            return null;
        }
        DynamicObject dynamicObject = manageInfo.getDynamicObject("recruproc");
        if (dynamicObject == null) {
            return null;
        }
        Long recruprocId = dynamicObject.getLong("id");
        HRBaseServiceHelper dbServiceRqmtproc = new HRBaseServiceHelper("tsrbd_rqmtproc");
        DynamicObject recruitmentProcessDyn = dbServiceRqmtproc.queryOne((Object)recruprocId);
        DynamicObjectCollection recruitmentStageDyns = recruitmentProcessDyn.getDynamicObjectCollection("entryentity");
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(10);
        Map<Long, Integer> stageCountMap = PositionModelAdapter.getRecruitmentStageCountByPositionId(Long.valueOf(positionId.toString()));
        for (DynamicObject recruitment : recruitmentStageDyns) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("nodename", recruitment.getDynamicObject("rqmtstg").getString("name"));
            Long recruitStageId = recruitment.getDynamicObject("rqmtstg").getLong("id");
            map.put("id", recruitStageId.toString());
            map.put("isHasColor", Boolean.TRUE);
            Integer count = stageCountMap.get(recruitStageId);
            map.put("number", count != null ? count.toString() : " 0");
            data.add(map);
        }
        return data;
    }

    public static List<Long> getPositionIdsByPosprin(Long posprinId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_position");
        QFilter qFilter = new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)posprinId);
        DynamicObject[] dynamicObjects = serviceHelper.query("id", new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getUserIds(String name) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_user");
        QFilter qFilter = new QFilter("name", "like", (Object)("%" + name + "%"));
        DynamicObject[] userDts = serviceHelper.query("id", qFilter.toArray());
        ArrayList<Long> userIds = new ArrayList<Long>(userDts.length);
        for (DynamicObject userDt : userDts) {
            userIds.add(userDt.getLong("id"));
        }
        return userIds;
    }

    public static DynamicObject[] queryPositionByQFilter(QFilter[] qFilters) {
        return HELPER.query(qFilters);
    }

    public static void updateAdminOrgByPositionId(Long positionId, List<Long> adminOrgList) {
        DynamicObject positionDy = HELPER.loadSingle((Object)positionId);
        MulBasedataDynamicObjectCollection oldAdminOrgs = (MulBasedataDynamicObjectCollection)positionDy.get("adminorgs");
        List oldAdminOrgIdList = oldAdminOrgs.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        for (Long adminOrgId : adminOrgList) {
            if (oldAdminOrgIdList.contains(adminOrgId)) continue;
            DynamicObject newAdminOrg = oldAdminOrgs.addNew();
            newAdminOrg.set("fbasedataid", (Object)adminOrgId);
        }
        HELPER.updateOne(positionDy);
    }

    public static void updateAllAdminOrgByPositionId(Long positionId, List<Long> adminOrgList) {
        DynamicObject positionDy = HELPER.loadSingle((Object)positionId);
        MulBasedataDynamicObjectCollection oldAdminOrgs = (MulBasedataDynamicObjectCollection)positionDy.get("adminorgs");
        oldAdminOrgs.clear();
        for (Long adminOrgId : adminOrgList) {
            DynamicObject newAdminOrg = oldAdminOrgs.addNew();
            newAdminOrg.set("fbasedataid", (Object)adminOrgId);
        }
        HELPER.updateOne(positionDy);
    }
}

