/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.ObjectUtils;

public class PositionHelper {
    private static final String[] SPECHAR = new String[]{"+", "/", "?", "%", "#", "&", "="};
    private static final String[] SPESYMBOL = new String[]{"%", "=", "+"};
    private static final Log logger = LogFactory.getLog(PositionHelper.class);

    private PositionHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void setAttachment(Long copyPkId, Long pkId) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String formId = "tspr_position";
        List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)copyPkId, (String)"attachmentpanelap");
        if (attachments.size() != 0) {
            int attachSize = attachments.size();
            FileItem[] fileItems = new FileItem[attachSize];
            DynamicObject[] attachObjects = new DynamicObject[attachSize];
            HRBaseServiceHelper attachServiceHelper = new HRBaseServiceHelper("bos_attachment");
            try {
                for (int i = 0; i < attachSize; ++i) {
                    Map attach = (Map)attachments.get(i);
                    String attachmentName = (String)attach.get("name");
                    String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)"tsrbs", (String)formId, (Object)PositionHelper.replaceSpeChar(String.valueOf(pkId)), (String)PositionHelper.replaceSpeSymbol(attachmentName));
                    URL url = new URL((String)attach.get("url"));
                    fileItems[i] = new FileItem(attachmentName, path, url.openStream());
                    attachObjects[i] = PositionHelper.newAttachObject(attachServiceHelper, attach, formId, path, pkId);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    service.upload(fileItems);
                    attachServiceHelper.save(attachObjects);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private static String replaceSpeChar(String str) {
        for (int i = 0; i < SPECHAR.length; ++i) {
            if (!str.contains(SPECHAR[i])) continue;
            str = str.replace(SPECHAR[i], "");
        }
        return str;
    }

    private static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPESYMBOL.length; ++i) {
            if (!str.contains(SPESYMBOL[i])) continue;
            str = str.replace(SPESYMBOL[i], "_");
        }
        return str;
    }

    private static DynamicObject newAttachObject(HRBaseServiceHelper attachServiceHelper, Map<String, Object> attach, String formId, String path, Object pkId) {
        DynamicObject attachObject = attachServiceHelper.generateEmptyDynamicObject();
        String attacmentName = (String)attach.get("name");
        Long id = ORM.create().genLongId("bos_attachment");
        attachObject.set("id", (Object)id);
        attachObject.set("FNUMBER", attach.get("uid"));
        attachObject.set("FBillType", (Object)formId);
        attachObject.set("FInterID", pkId);
        Date today = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        attachObject.set("FModifyTime", (Object)today);
        attachObject.set("fcreatetime", (Object)today);
        attachObject.set("FaliasFileName", (Object)attacmentName);
        attachObject.set("FAttachmentName", (Object)attacmentName);
        attachObject.set("FExtName", (Object)attacmentName.substring(attacmentName.lastIndexOf(46) + 1));
        attachObject.set("FATTACHMENTSIZE", attach.get("size"));
        attachObject.set("FFileId", (Object)path);
        attachObject.set("FCREATEMEN", (Object)TSCRequestContext.getUserId());
        attachObject.set("fattachmentpanel", (Object)"attachmentpanelap");
        attachObject.set("fbillstatus", (Object)"1");
        return attachObject;
    }

    public static boolean isPositionSimpleView(IFormView view) {
        String formId = view.getFormShowParameter().getFormId();
        Boolean isSimpleView = null;
        if (formId.equals("tssrm_position_view")) {
            isSimpleView = (Boolean)view.getFormShowParameter().getCustomParam("isSimpleView");
        } else {
            IFormView parentView = view.getParentView();
            if (ObjectUtils.isNotEmpty((Object)parentView)) {
                isSimpleView = (Boolean)parentView.getFormShowParameter().getCustomParam("isSimpleView");
            }
        }
        return null == isSimpleView ? false : isSimpleView;
    }
}

