/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.constant.Constable;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbd.business.domain.common.service.TscDispatchServiceHelper;

public class PositionLabelServiceHelper {
    private static PositionLabelServiceHelper positionRuleServiceHelper = new PositionLabelServiceHelper();
    private static final Log logger = LogFactory.getLog(PositionLabelServiceHelper.class);

    private PositionLabelServiceHelper() {
    }

    public static PositionLabelServiceHelper getInstance() {
        return positionRuleServiceHelper;
    }

    public JSONObject getLabelByPositionInfo(String inputParam) {
        logger.info("PositionLabelAPI getJDTag request param : {}", (Object)inputParam);
        HashMap<String, JSONObject> body = new HashMap<String, JSONObject>(1);
        body.put("data", JSONObject.parseObject((String)inputParam));
        JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap((String)"getJDTag", body);
        logger.info("PositionLabelAPI getJDTag result param : {}", (Object)resultJson);
        if (null == resultJson) {
            return null;
        }
        JSONObject json = resultJson.getJSONObject("result");
        if (json == null || json.isEmpty() || json.get((Object)"complete_tag") == null) {
            return null;
        }
        JSONObject tag = resultJson.getJSONObject("result").getJSONObject("complete_tag");
        return tag;
    }

    public JSONObject getLabelByPositionId(Long positionId) {
        HashMap<String, Long> body = new HashMap<String, Long>(1);
        body.put("portrait_id", positionId);
        logger.info("PositionLabelAPI queryJDPortrait request param : {}", (Object)positionId);
        JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap((String)"queryJDPortrait", body);
        logger.info("PositionLabelAPI queryJDPortrait result param : {}", (Object)resultJson);
        if (resultJson != null && "1000".equals(resultJson.getString("statusCode"))) {
            resultJson.getJSONObject("data");
        }
        return new JSONObject();
    }

    public String savePositionLabelToAi(Long positionId, String inputParam, Boolean isGetTag) {
        String statusCode;
        logger.info("PositionLabelAPI.savePositionLabelToAi.params.positionId\uff1a{};inputParam\uff1a{};isGetTag\uff1a{};", new Object[]{positionId, inputParam, isGetTag});
        HashMap<String, Constable> body = new HashMap<String, Constable>(3);
        body.put("portrait_id", positionId);
        body.put("is_get_tag", isGetTag);
        body.put("data", (Constable)JSONObject.parseObject((String)inputParam));
        try {
            JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap((String)"saveJDPortrait", body);
            statusCode = resultJson.get((Object)"statusCode").toString();
            if ("1000".equals(statusCode)) {
                logger.info("PositionLabelAPI savePositionLabel success param : {}", (Object)positionId);
            } else {
                logger.info("PositionLabelAPI savePositionLabel fail param : {}", (Object)positionId);
            }
        }
        catch (Exception ex) {
            logger.info("PositionLabelAPI.savePositionLabelToAi exception");
            return "-10000";
        }
        return statusCode;
    }

    public JSONArray getLabelByPCode(String typeCode, String keyWord, String queryField, String title, Integer count, String jobThirdClass) {
        HashMap<String, Object> body = new HashMap<String, Object>(3);
        body.put("tag_type", typeCode);
        body.put("key_word", keyWord);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("query_field", queryField);
        params.put("title", title);
        params.put("count", count);
        params.put("job_third_class", jobThirdClass);
        body.put("params", params);
        String inputParam = JSON.toJSONString(body);
        logger.info("PositionLabelAPI queryTag request param : {}", (Object)inputParam);
        JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap((String)"queryTag", body);
        logger.info("PositionLabelAPI queryTag result param : {}", (Object)resultJson);
        JSONArray data_tag = resultJson.getJSONArray("data");
        return data_tag;
    }
}

