/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.position.service.entity.PositionLockInfo;

public class PositionLockService {
    private static final Log logger = LogFactory.getLog(PositionLockService.class);
    private static final DistributeSessionlessCache FLOWLOCK_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("tsc_region");
    private static final String CACHE_KEY_FIX = "[tscposition11]";
    private static int OUT_SECONDS = 600;
    private static int OUT_TRY_LOCK = 5000;

    public static PositionLockService getInstance() {
        return new PositionLockService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPositionLock(Long positionId, String pageId) {
        String key = this.genCacheKey(positionId);
        DLock lock = DLock.create((String)key);
        if (lock.tryLock((long)OUT_TRY_LOCK)) {
            try {
                PositionLockInfo positionLockInfo = this.getLockVal(positionId);
                if (positionLockInfo == null) {
                    FLOWLOCK_CACHE.put(key, (Object)this.genCacheVal(pageId), OUT_SECONDS);
                    logger.info("PositionLockService.getAddAuthLock lock success,positionId:{}", (Object)positionId);
                    boolean bl = true;
                    return bl;
                }
                Date invalidTime = positionLockInfo.getInvalidTime();
                Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                if (now.after(invalidTime)) {
                    FLOWLOCK_CACHE.remove(this.genCacheKey(positionId));
                    FLOWLOCK_CACHE.put(this.genCacheKey(positionId), (Object)this.genCacheVal(pageId), OUT_SECONDS);
                    logger.info("PositionLockService.getAddAuthLock lock success,positionId:{}", (Object)positionId);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                logger.error("PositionLockService.getAddAuthLock lock fail,positionId:{}", (Object)positionId, (Object)e);
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    public boolean positionTokenIsExist(Long positionId) {
        PositionLockInfo positionLockInfo = this.getLockVal(positionId);
        if (positionLockInfo == null) {
            return false;
        }
        Date invalidTime = positionLockInfo.getInvalidTime();
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (now.after(invalidTime)) {
            FLOWLOCK_CACHE.remove(this.genCacheKey(positionId));
            return false;
        }
        return true;
    }

    public boolean checkAuth(Long positionId, String pageId) {
        if (!this.positionTokenIsExist(positionId)) {
            return false;
        }
        try {
            PositionLockInfo existVal = this.getLockVal(positionId);
            if (existVal != null) {
                String cacheGlobalSessionId = existVal.getGlobalSessionId();
                String cachePageId = existVal.getPageId();
                String globalSessionId = RequestContext.get().getGlobalSessionId();
                return cacheGlobalSessionId.equals(globalSessionId) && pageId.equals(cachePageId);
            }
            return false;
        }
        catch (NullPointerException e) {
            logger.error("PositionLockService.checkAuth", (Throwable)e);
            return false;
        }
    }

    public void releaseLock(Long positionId) {
        FLOWLOCK_CACHE.remove(this.genCacheKey(positionId));
    }

    private PositionLockInfo getLockVal(Long positionId) {
        String key = this.genCacheKey(positionId);
        String val = (String)FLOWLOCK_CACHE.get(key);
        if (HRStringUtils.isEmpty((String)val)) {
            return null;
        }
        return (PositionLockInfo)JSON.parseObject((String)val, PositionLockInfo.class);
    }

    private String genCacheKey(Long positionId) {
        return CACHE_KEY_FIX + positionId;
    }

    private String genCacheVal(String pageId) {
        PositionLockInfo positionLockInfo = new PositionLockInfo();
        positionLockInfo.setGlobalSessionId(RequestContext.get().getGlobalSessionId());
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date invalidTime = HRDateTimeUtils.addSecond((Date)now, (long)OUT_SECONDS);
        positionLockInfo.setInvalidTime(invalidTime);
        positionLockInfo.setPageId(pageId);
        return JSON.toJSONString((Object)positionLockInfo);
    }

    private String serializableVal(PositionLockInfo positionLockInfo) {
        if (positionLockInfo == null) {
            return null;
        }
        return JSON.toJSONString((Object)positionLockInfo);
    }
}

