/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.position.service.PositionDataHelper;
import kd.tsc.tspr.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tspr.business.domain.position.service.PositionResumeRuleHelper;
import kd.tsc.tspr.common.constants.position.PositionManageConstants;
import kd.tsc.tsrbd.business.domain.config.service.BizConfigParamHelper;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbd.common.enums.SecConfPageEnum;
import kd.tsc.tsrbd.common.utils.TSCQFilterUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PositionManageService {
    private static final Log logger = LogFactory.getLog(PositionManageService.class);
    private static final BizConfigParamHelper BIZ_CONFIG = new BizConfigParamHelper();

    private PositionManageService() {
    }

    public static PositionManageService getInstance() {
        return new PositionManageService();
    }

    public void openPositionManagePage(String formId, String targetKey, IFormView view, Map<String, Object> customParams) {
        this.openPositionManagePage(formId, targetKey, view, null, null, null, customParams);
    }

    public void openPositionManagePage(String formId, String targetKey, IFormView view, BillOperationStatus billStatus, OperationStatus status, Long pkId, Map<String, Object> customParams) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (billStatus != null) {
            parameter.setBillStatus(billStatus);
        }
        if (status != null) {
            parameter.setStatus(status);
        }
        if (pkId != null) {
            parameter.setPkId((Object)pkId);
        }
        if (customParams != null) {
            customParams.forEach((key, val) -> parameter.setCustomParam(key, val));
        }
        String pageId = parameter.getPageId();
        view.showForm((FormShowParameter)parameter);
        view.getPageCache().put(formId, pageId);
    }

    public void savePositionManage(DynamicObject[] dys) {
        Arrays.stream(dys).forEach(dynamicObject -> {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dynamicObject, (String)"position");
            if (entryentity.size() == 0) {
                PositionResumeRuleHelper.statusChange(positionId, "A", false);
            } else {
                PositionResumeRuleHelper.statusChange(positionId, "A", true);
            }
        });
    }

    public void setPositionManageToPosition(Long positionId) {
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo(positionId);
        if (manageInfo == null) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("manageinfo", Collections.singletonList(manageInfo.getLong("id")));
        PositionDataHelper.updatePositionInfo("tspr_position", Collections.singletonList(positionId), (Map<String, List<Object>>)map);
    }

    public void setAuthorizer(IFormView view) {
        IDataModel model = view.getModel();
        Long secLevel = this.getModelSecLevel(model);
        FieldEdit control = (FieldEdit)view.getControl("authorizer");
        if (control == null) {
            return;
        }
        if (secLevel != null && secLevel.equals(PositionManageConstants.SECLEVEL_PRIVATE)) {
            view.setVisible(Boolean.TRUE, new String[]{"authorizer"});
            DynamicObjectCollection posprin = (DynamicObjectCollection)model.getValue("posprin");
            List idList = posprin.stream().map(dyn -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"fbasedataid")).collect(Collectors.toList());
            DynamicObject creator = (DynamicObject)model.getValue("creator");
            String source = creator.getString("source");
            if (HRStringUtils.equals((String)source, (String)"HR")) {
                idList.add(creator.getLong("id"));
            }
            control.setMustInput(true);
            model.setValue("authorizer", (Object)idList.toArray());
        } else {
            control.setMustInput(false);
            view.setVisible(Boolean.FALSE, new String[]{"authorizer"});
            model.setValue("authorizer", null);
        }
    }

    public void setPosPrin(IFormView view) {
        IDataModel model = view.getModel();
        FieldEdit control = (FieldEdit)view.getControl("posprin");
        if (control == null) {
            return;
        }
        DynamicObjectCollection posPrinColl = (DynamicObjectCollection)model.getValue("posprin");
        Long secLevel = this.getModelSecLevel(model);
        if (secLevel.equals(PositionManageConstants.SECLEVEL_PRIVATE) || secLevel.equals(PositionManageConstants.SECLEVEL_LN) || secLevel.equals(0L)) {
            return;
        }
        List<Long> userIdList = this.getHasSecLevelUserLevel(secLevel);
        ArrayList newIdList = Lists.newArrayListWithExpectedSize((int)userIdList.size());
        for (DynamicObject posPrin : posPrinColl) {
            Long posPrinId = posPrin.getLong("fbasedataid.id");
            if (!userIdList.contains(posPrinId)) continue;
            newIdList.add(posPrinId);
        }
        model.setValue("posprin", (Object)newIdList.toArray());
    }

    private Long getModelSecLevel(IDataModel model) {
        Object value = model.getValue("seclevel");
        Long secLevel = value instanceof DynamicObject ? Long.valueOf(((DynamicObject)value).getLong("id")) : (Long)value;
        return secLevel;
    }

    public void setAuthorizerVisable(IFormView view) {
        IDataModel model = view.getModel();
        Object value = model.getValue("seclevel");
        Long secLevel = value instanceof DynamicObject ? Long.valueOf(((DynamicObject)value).getLong("id")) : (Long)value;
        FieldEdit control = (FieldEdit)view.getControl("authorizer");
        if (control == null) {
            return;
        }
        if (secLevel != null && secLevel.equals(PositionManageConstants.SECLEVEL_PRIVATE)) {
            view.setVisible(Boolean.TRUE, new String[]{"authorizer"});
            control.setMustInput(true);
        } else {
            control.setMustInput(false);
            view.setVisible(Boolean.FALSE, new String[]{"authorizer"});
        }
    }

    public QFilter getSceSuerQfilter(IFormView view) {
        IDataModel model = view.getModel();
        Long secLevel = this.getModelSecLevel(model);
        if (secLevel == null || secLevel.equals(PositionManageConstants.SECLEVEL_PRIVATE) || secLevel.equals(PositionManageConstants.SECLEVEL_LN) || secLevel.equals(0L)) {
            return null;
        }
        List<Long> userIdList = this.getHasSecLevelUserLevel(secLevel);
        return new QFilter("id", "in", userIdList);
    }

    public QFilter getIntvevlqunrQfilter(IDataModel model) {
        Object org = model.getValue("createorg");
        Object category = model.getValue("reccategory");
        Object scene = model.getValue("recruscene");
        logger.info("appendIntvevlqunrQfilters org: {}, category: {}, scene: {}", new Object[]{org, category, scene});
        if (org == null || category == null || scene == null) {
            return TSCQFilterUtils.cFalse();
        }
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_intvevlqunr", (Long)((Long)((DynamicObject)org).getPkValue()));
        if (filter == null) {
            return TSCQFilterUtils.cFalse();
        }
        filter.and(new QFilter("evltype", "=", (Object)"2"));
        filter.and(new QFilter("group", "=", ((DynamicObject)category).getPkValue()));
        QFilter sceneFilter = new QFilter("recruscene.fbasedataid", "is null", null).or(new QFilter("recruscene.fbasedataid", "=", ((DynamicObject)scene).getPkValue()));
        filter.and(sceneFilter);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return filter;
    }

    public List<Long> getHasSecLevelUserLevel(Long secLevel) {
        DynamicObject[] users = SecuserHelper.querySecUserInfoList();
        ArrayList userIdList = Lists.newArrayListWithExpectedSize((int)users.length);
        for (DynamicObject user : users) {
            String status = user.getString("status");
            if (!HRStringUtils.equals((String)status, (String)"1")) continue;
            DynamicObjectCollection levelentry = user.getDynamicObjectCollection("tsrbd_levelentry");
            List dynList = levelentry.stream().filter(level -> PositionManageConstants.SECLEVEL_NUMBER.longValue() == level.getLong("functionlevel.id")).collect(Collectors.toList());
            for (DynamicObject dyn : dynList) {
                Long secLevelId = dyn.getLong("userlevel.id");
                if (secLevel < secLevelId || secLevelId.equals(0L)) continue;
                Long userId = user.getLong("userid.id");
                userIdList.add(userId);
            }
        }
        return userIdList;
    }

    public void setSceLevel(IDataModel model) {
        String seclevel;
        boolean flag = SecConfHelper.querySecurityConf((Long)SecConfPageEnum.getPkIdByName((String)"tssrm_positionmanage"));
        if (flag && HRStringUtils.isEmpty((String)(seclevel = (String)model.getValue("secselect")))) {
            model.setValue("secselect", (Object)"1070_S");
        }
    }

    public void setDefPosPrin(IDataModel model) {
        Object value = model.getValue("posprin");
        if (!HRObjectUtils.isEmpty((Object)value) && ((DynamicObjectCollection)value).size() != 0) {
            return;
        }
        DynamicObject creator = (DynamicObject)model.getValue("creator");
        String source = creator.getString("source");
        if (HRStringUtils.equals((String)source, (String)"HR")) {
            long creatorId = creator.getLong("id");
            model.setValue("posprin", (Object)new Object[]{creatorId});
        }
    }

    public void setEntryCellColor(IDataModel dataModel, IFormView view) {
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
        ArrayList mailStatusError = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
        ArrayList statusError = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
        int index = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            String mailStatus = dynamicObject.getString("mailinfo.mailstatus");
            String enable = dynamicObject.getString("mailinfo.enable");
            if (HRStringUtils.equals((String)mailStatus, (String)"0")) {
                mailStatusError.add(index);
            }
            if (HRStringUtils.equals((String)enable, (String)"0")) {
                statusError.add(index);
            }
            ++index;
        }
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        if (entryGrid == null) {
            return;
        }
        this.setCellStyle(entryGrid, "basedatapropfield", mailStatusError);
        this.setCellStyle(entryGrid, "basedatapropfield1", statusError);
    }

    private void setCellStyle(EntryGrid entryGrid, String fieldKey, List<Integer> indexList) {
        ArrayList cellStyleList = Lists.newArrayListWithExpectedSize((int)indexList.size());
        for (Integer rowIndex : indexList) {
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey(fieldKey);
            cellStyle.setRow(rowIndex.intValue());
            cellStyle.setForeColor("#fb2323");
            cellStyleList.add(cellStyle);
        }
        entryGrid.setCellStyle((List)cellStyleList);
    }

    public void recCategoryChanged(Long recCategoryId, IFormView childView, IDataModel model) {
        if (childView == null || recCategoryId.equals(0L)) {
            return;
        }
        IDataModel childModel = childView.getModel();
        this.recPorcChange(recCategoryId, childModel, model);
        this.ruleChange(recCategoryId, childModel, model);
    }

    private void recPorcChange(Long recCategoryId, IDataModel model, IDataModel parentModel) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        QFilter groupFilter = new QFilter("group", "=", (Object)recCategoryId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        HashMap<String, QFilter> qFilterMap = PositionManageServiceHelper.generateQFilterMap(parentModel);
        DynamicObject[] recPorcs = serviceHelper.query("id, isdefault", new QFilter[]{groupFilter, enableFilter, qFilterMap.get("recruproc")});
        Long recProcId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)model.getDataEntity(), (String)"recruproc");
        Long defaultId = 0L;
        for (DynamicObject recPorc : recPorcs) {
            Long id = recPorc.getLong("id");
            if (recProcId.equals(id)) {
                return;
            }
            boolean isdefault = recPorc.getBoolean("isdefault");
            if (!isdefault) continue;
            defaultId = id;
        }
        if (defaultId.equals(0L)) {
            model.setValue("recruproc", null);
        } else {
            model.setValue("recruproc", (Object)defaultId);
        }
    }

    private void ruleChange(Long recCategoryId, IDataModel model, IDataModel parentModel) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgresurule");
        QFilter categoryFilter = new QFilter("reccategory", "=", (Object)recCategoryId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        HashMap<String, QFilter> qFilterMap = PositionManageServiceHelper.generateQFilterMap(parentModel);
        DynamicObject[] rules = serviceHelper.query("id", new QFilter[]{categoryFilter, enableFilter, qFilterMap.get("cfgresurule")});
        Long ruleId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)model.getDataEntity(), (String)"cfgresurule");
        List collect = Arrays.stream(rules).filter(rule -> ruleId.equals(rule.getLong("id"))).collect(Collectors.toList());
        if (collect.size() == 0) {
            model.setValue("cfgresurule", null);
        }
    }

    public void setDefaultRecCategory(IFormView view) {
        String pageIdCache = view.getPageCache().get("tssrm_positionmanage");
        IFormView childView = view.getView(pageIdCache);
        Long recCatrgory = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)view.getModel().getDataEntity(), (String)"reccategory");
        this.recCategoryChanged(recCatrgory, childView, view.getModel());
        view.sendFormAction(childView);
    }

    private Pair<Boolean, Boolean> getRewardRuleConf() {
        Boolean defaultSelect = Boolean.parseBoolean((String)BIZ_CONFIG.get("tsrbd_rewardruleconf", "posdefaultselect"));
        Boolean allowUpdate = Boolean.parseBoolean((String)BIZ_CONFIG.get("tsrbd_rewardruleconf", "allowupdateconf"));
        return Pair.of((Object)defaultSelect, (Object)allowUpdate);
    }

    public void showPosRewardRuleField(IFormView formView, String positionStatus) {
        long posManageId = (Long)formView.getModel().getValue("id");
        if (posManageId == 0L) {
            Pair<Boolean, Boolean> rewardRuleConf = this.getRewardRuleConf();
            Boolean defaultSelect = (Boolean)rewardRuleConf.getLeft();
            Boolean allowUpdate = (Boolean)rewardRuleConf.getRight();
            this.setPosRuleField(formView, defaultSelect, allowUpdate, true);
            formView.getModel().setValue("rewarddefaultconf", (Object)defaultSelect);
            formView.getModel().setValue("allowupdateconf", (Object)allowUpdate);
        } else if (HRStringUtils.equals((String)positionStatus, (String)"B") || HRStringUtils.equals((String)positionStatus, (String)"E")) {
            DynamicObject manageInfo = formView.getModel().getDataEntity();
            Boolean defaultSelect = manageInfo.getBoolean("rewarddefaultconf");
            Boolean allowUpdate = manageInfo.getBoolean("allowupdateconf");
            this.setPosRuleField(formView, defaultSelect, allowUpdate, false);
            boolean useRewardRule = (Boolean)formView.getModel().getValue("userewardrule");
            formView.setVisible(Boolean.valueOf(useRewardRule), new String[]{"rewardrule"});
        } else {
            DynamicObject manageInfo = formView.getModel().getDataEntity();
            Boolean defaultSelect = manageInfo.getBoolean("rewarddefaultconf");
            Boolean allowUpdate = manageInfo.getBoolean("allowupdateconf");
            if (!defaultSelect.booleanValue() && !allowUpdate.booleanValue()) {
                formView.setVisible(Boolean.FALSE, new String[]{"userewardrule", "rewardrule"});
            } else {
                formView.setEnable(Boolean.FALSE, new String[]{"rewardrule", "userewardrule"});
            }
        }
    }

    private void setPosRuleField(IFormView formView, Boolean defaultSelect, Boolean allowUpdate, boolean isAdd) {
        DynamicObject recProc;
        if (!defaultSelect.booleanValue() && allowUpdate.booleanValue()) {
            if (isAdd) {
                formView.setVisible(Boolean.FALSE, new String[]{"rewardrule"});
            }
        } else if (defaultSelect.booleanValue() && !allowUpdate.booleanValue()) {
            if (isAdd) {
                formView.getModel().setValue("userewardrule", (Object)true);
            }
            formView.setEnable(Boolean.FALSE, new String[]{"userewardrule"});
        } else if (defaultSelect.booleanValue() && allowUpdate.booleanValue()) {
            if (isAdd) {
                formView.getModel().setValue("userewardrule", (Object)true);
            }
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"userewardrule", "rewardrule"});
        }
        if (HRObjectUtils.isEmpty((Object)(recProc = (DynamicObject)formView.getModel().getValue("recruproc")))) {
            formView.setEnable(Boolean.FALSE, new String[]{"rewardrule"});
        }
    }

    public Long getPositionId(IFormView formView) {
        Object position = formView.getModel().getValue("position");
        Long positionId = position instanceof DynamicObject ? Long.valueOf(((DynamicObject)position).getLong("id")) : (Long)position;
        return positionId;
    }
}

