/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class PositionManageServiceHelper {
    private static final Long RECRUTYP_NOR = 1020L;
    private static final Long RECRUTYP_HIG = 1030L;

    public static Map<Long, List<Long>> getMailInfoIdByPositionBo(List<Long> positionBoList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionmailrelation");
        QFilter qFilter = new QFilter("position", "in", positionBoList);
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)positionBoList.size());
        Arrays.stream(dys).forEach(dyn -> {
            Long positionBo = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"position");
            Long mailInfoID = dyn.getLong("mailinfo.id");
            List list = (List)result.get(positionBo);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)dys.length);
            }
            list.add(mailInfoID);
            result.put(positionBo, list);
        });
        return result;
    }

    public static Map<Long, List<Long>> getPositionBoByMailInfoId(List<Long> mailInfoIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionmailrelation");
        QFilter qFilter = new QFilter("mailinfo", "in", mailInfoIdList);
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)mailInfoIdList.size());
        Arrays.stream(dys).forEach(dyn -> {
            Long mailInfoID = dyn.getLong("mailinfo.id");
            Long positionBo = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"position");
            List list = (List)result.get(mailInfoID);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)dys.length);
            }
            list.add(positionBo);
            result.put(mailInfoID, list);
        });
        return result;
    }

    public static List<Long> getPositionBoByMailId(List<Long> mailInfoIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionmailrelation");
        QFilter qFilter = new QFilter("mailinfo", "in", mailInfoIdList);
        QFilter qFilter1 = new QFilter("position.positionstatus", "in", (Object)new String[]{"A", "C"});
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1});
        ArrayList<Long> list = new ArrayList<Long>();
        Arrays.stream(dys).forEach(dyn -> {
            Long positionBo = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"position");
            list.add(positionBo);
        });
        return list;
    }

    public static DynamicObject getManageInfoByPositionBo(Long position) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionmanage");
        QFilter boFilter = new QFilter("position", "=", (Object)position);
        DynamicObject manageInfo = serviceHelper.loadDynamicObject(new QFilter[]{boFilter});
        return manageInfo;
    }

    public static DynamicObject[] getManageInfoByPositionIds(List<Long> position) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionmanage");
        QFilter boFilter = new QFilter("position", "in", position);
        DynamicObject[] manageInfos = serviceHelper.loadDynamicObjectArray(new QFilter[]{boFilter});
        return manageInfos;
    }

    public static HashMap<String, QFilter> generateQFilterMap(IDataModel dataModel) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        HashMap<String, QFilter> QFILTER_PROPERTYMAP = new HashMap<String, QFilter>(16);
        PositionManageServiceHelper.putRecProcFilter(dataEntity, QFILTER_PROPERTYMAP);
        PositionManageServiceHelper.putResumeRuleFilter(dataEntity, QFILTER_PROPERTYMAP);
        return QFILTER_PROPERTYMAP;
    }

    private static void putRecProcFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        DynamicObject recruitCategory = dataEntity.getDynamicObject("reccategory");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("applicableapp", "=", (Object)1010L);
        if (recruitCategory != null) {
            qFilter.and("group", "=", (Object)recruitCategory.getLong("id"));
        } else {
            qFilter.and("group", "in", (Object)new Long[]{RECRUTYP_HIG, RECRUTYP_NOR});
        }
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        if (createOrg != null) {
            qFilter.and("createorg", "=", (Object)createOrg.getLong("id"));
        }
        QFILTER_PROPERTYMAP.put("recruproc", qFilter);
    }

    private static void putResumeRuleFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        DynamicObject recruitCategory = dataEntity.getDynamicObject("reccategory");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (recruitCategory != null) {
            qFilter.and("reccategory", "=", (Object)recruitCategory.getLong("id"));
        } else {
            qFilter.and("reccategory", "in", (Object)new Long[]{RECRUTYP_HIG, RECRUTYP_NOR});
        }
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        if (createOrg != null) {
            qFilter.and("dependorg", "=", (Object)createOrg.getLong("id"));
        }
        QFILTER_PROPERTYMAP.put("cfgresurule", qFilter);
    }
}

