/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class PositionModelAdapter {
    private PositionModelAdapter() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<Long, Integer> getRecruitmentStageCountByPositionId(Long positionId) {
        if (positionId == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tspr_appfile");
        try (DataSet dataSet = dbServiceAppFile.queryDataSet("getRecruitmentStageCountByPositionId_0", "recrustg.id", new QFilter("position.id", "=", (Object)positionId).toArray());
             DataSet groupSet = dataSet.groupBy(new String[]{"recrustg.id"}).count().finish();){
            for (Row row : groupSet) {
                row.getLong("count");
                result.put(row.getLong("recrustg.id"), row.getInteger("count"));
            }
        }
        return result;
    }

    public static Map<Long, Integer> getCountByPositionId(List<Long> positionIds) {
        if (positionIds == null || positionIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        positionIds.forEach(positionId -> result.put(positionId, 0));
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tspr_appfile");
        try (DataSet dataSet = dbServiceAppFile.queryDataSet("getCountByPositionId_0", "position.id", new QFilter("position.id", "in", positionIds).toArray());
             DataSet groupSet = dataSet.groupBy(new String[]{"position.id"}).count().finish();){
            for (Row row : groupSet) {
                result.put(row.getLong("position.id"), row.getInteger("count"));
            }
        }
        return result;
    }

    public static Long getCountBySinglePositionId(Long positionId) {
        if (positionId == null) {
            return 0L;
        }
        Long result = 0L;
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tspr_appfile");
        try (DataSet dataSet = dbServiceAppFile.queryDataSet("getCountBySinglePositionId_0", "position.id", new QFilter("position.id", "=", (Object)positionId).toArray());
             DataSet groupSet = dataSet.groupBy(new String[]{"position.id"}).count().finish();){
            for (Row row : groupSet) {
                result = row.getLong("count");
            }
        }
        return result;
    }
}

