/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PositionPermHelper {
    public static final Map<String, String> POSITION_PERM_MAP = new HashMap<String, String>(16);
    public static final String POSITION_START = "1AQKC2+XFW35";
    public static final String POSITION_CLOSE = "1AQKE6T3RFRF";
    public static final String POSITION_STOP = "1AQKD3=G8Y8C";
    public static final String POSITION_SAVE = "0A3CBG6XWQC5";
    public static final String POSITION_NEW = "47156aff000000ac";
    public static final String POSITION_EDIT = "0AQ3YJ2LET+U";
    public static final String POSITION_QUERY = "47150e89000000ac";
    public static final String POSITION_ADD_CANDIDATE = "1EJX2FH+7MLV";

    private PositionPermHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean verifyPositionPerm(String operateCode) {
        long userId = TSCRequestContext.getUserId();
        HasPermOrgResult orgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"tsrbs", (String)"tssrm_position_add", (String)POSITION_PERM_MAP.get(operateCode));
        return AppFileDataHelper.verifyPermOrgResult(orgResult);
    }

    public static boolean verifyPositionPerm(String operateCode, String entityNum) {
        long userId = TSCRequestContext.getUserId();
        if (HRStringUtils.isEmpty((String)entityNum)) {
            return false;
        }
        HasPermOrgResult orgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"tsrbs", (String)entityNum, (String)POSITION_PERM_MAP.get(operateCode));
        return AppFileDataHelper.verifyPermOrgResult(orgResult);
    }

    static {
        POSITION_PERM_MAP.put("stop_donothing", POSITION_STOP);
        POSITION_PERM_MAP.put("posstart_donothing", POSITION_START);
        POSITION_PERM_MAP.put("posclose_donothing", POSITION_CLOSE);
        POSITION_PERM_MAP.put("saveandcommit", POSITION_SAVE);
        POSITION_PERM_MAP.put("copy_donothing", POSITION_NEW);
        POSITION_PERM_MAP.put("edit_donothing", POSITION_EDIT);
        POSITION_PERM_MAP.put("query_donothing", POSITION_QUERY);
        POSITION_PERM_MAP.put("add_candidate", POSITION_ADD_CANDIDATE);
        POSITION_PERM_MAP.put("analysisresadd", POSITION_ADD_CANDIDATE);
        POSITION_PERM_MAP.put("openfillresadd", POSITION_ADD_CANDIDATE);
    }
}

