/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tspr.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;

public class PositionRuleServiceHelper {
    private static PositionRuleServiceHelper positionRuleServiceHelper = new PositionRuleServiceHelper();
    private static HRBaseServiceHelper ruleServiceHelper = new HRBaseServiceHelper("tspr_positionrule");
    private static HRBaseServiceHelper rsmServiceHelper = new HRBaseServiceHelper("tstpm_srrsm");
    private static HRBaseServiceHelper positionServiceHelper = new HRBaseServiceHelper("tspr_position");
    private static final Log logger = LogFactory.getLog(PositionRuleServiceHelper.class);

    private PositionRuleServiceHelper() {
    }

    public static PositionRuleServiceHelper getInstance() {
        return positionRuleServiceHelper;
    }

    public void deleteById(Long positionRuleId) {
        if (Objects.isNull(positionRuleId)) {
            return;
        }
        ruleServiceHelper.deleteOne((Object)positionRuleId);
    }

    public List<DynamicObject> selectPositionRuleByPositionId(Long positionId) {
        QFilter qFilter = new QFilter("positionid", "=", (Object)positionId);
        return TsrbsHelper.selectByFilter(qFilter.toArray(), "tspr_positionrule");
    }

    public List<Long> rsmAssignPositionAuto(AppResumeBo bo) {
        ArrayList<Long> emailIds = new ArrayList<Long>(1);
        Long emailSource = bo.getDelivery().getLong("emailsource");
        emailIds.add(emailSource);
        List<Long> positionIds = PositionManageServiceHelper.getPositionBoByMailId(emailIds);
        logger.info("rsmAssignPositionAuto:emailid-{},positionid-{}", emailIds, positionIds);
        DynamicObject[] rulePresetObjs = this.getRuleObjs(positionIds, "1");
        DynamicObject[] ruleUnPresetObjs = this.getRuleObjs(positionIds, "0");
        DynamicObject delivery = bo.getDelivery();
        List<Long> ids = this.rsmAssignRule(delivery, rulePresetObjs);
        if (!ids.isEmpty()) {
            return ids;
        }
        ids = this.rsmAssignRule(delivery, ruleUnPresetObjs);
        return ids;
    }

    public void rsmAssignPositionByRule(DynamicObject[] rsms) {
        HashSet<Long> emailSet = new HashSet<Long>(rsms.length);
        for (DynamicObject rsmObj : rsms) {
            Long emailSource = rsmObj.getLong("delivery.emailsource.id");
            emailSet.add(emailSource);
        }
        ArrayList<Long> emailIds = new ArrayList<Long>(emailSet);
        List<Long> positionIds = PositionManageServiceHelper.getPositionBoByMailId(emailIds);
        logger.info("rsmAssignPositionByRule:emailid-{},positionid-{}", emailIds, positionIds);
        DynamicObject[] rulePresetObjs = this.getRuleObjs(positionIds, "1");
        DynamicObject[] ruleUnPresetObjs = this.getRuleObjs(positionIds, "0");
        int successCount = 0;
        int allCount = rsms.length;
        for (DynamicObject rsmObj : rsms) {
            DynamicObject deliveryObj = rsmObj.getDynamicObject("delivery");
            List<Long> ids = this.rsmAssignRule(deliveryObj, rulePresetObjs);
            if (ids.isEmpty()) {
                ids = this.rsmAssignRule(deliveryObj, ruleUnPresetObjs);
            }
            if (ids.isEmpty()) continue;
            Long rsmId = rsmObj.getLong("id");
            this.invokeRpcHandleUnAllocatedRsm(rsmId, ids);
            ++successCount;
        }
        String content = successCount > 0 ? ResManager.loadKDString((String)"\u7b80\u5386\u5206\u914d\u89c4\u5219\u5df2\u6267\u884c\u7ed3\u675f\uff0c\u5171\u6267\u884c\u5f85\u5206\u914d\u7b80\u5386%s\u4efd,\u6210\u529f\u5206\u914d%s\u4efd\u7b80\u5386\u3002", (String)"PositionRuleList_8", (String)"tsc-tspr-business", (Object[])new Object[]{allCount, successCount}) : ResManager.loadKDString((String)"\u7b80\u5386\u5206\u914d\u89c4\u5219\u5df2\u6267\u884c\u7ed3\u675f\uff0c\u7cfb\u7edf\u5185\u6682\u65e0\u5f85\u5206\u914d\u7b80\u5386\u7b26\u5408\u5df2\u6709\u804c\u4f4d\u7684\u7b80\u5386\u5206\u914d\u89c4\u5219\uff0c\u8bf7\u7b49\u5f85\u65b0\u7b80\u5386\u5165\u5e93\u6216\u4fee\u6539/\u65b0\u5efa\u5206\u914d\u6761\u4ef6\u540e\u518d\u6b21\u6267\u884c\u3002", (String)"PositionRuleList_9", (String)"tsc-tspr-business", (Object[])new Object[0]);
        this.sendMessage(content);
        logger.info("\u7b80\u5386\u5206\u914d\u89c4\u5219\u6267\u884c\u7ed3\u675f\uff0c\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01");
    }

    public void positionAssignRsmByRule(DynamicObject[] ruleObjs) {
        if (null == ruleObjs || ruleObjs.length <= 0) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5206\u914d\u89c4\u5219\uff0c\u6267\u884c\u5931\u8d25\uff01");
            return;
        }
        Long positionId = ruleObjs[0].getLong("positionid");
        QFilter qFilter = new QFilter("id", "=", (Object)positionId);
        DynamicObject positionObj = positionServiceHelper.loadDynamicObject(new QFilter[]{qFilter});
        String positionName = positionObj.getString("name");
        DynamicObject[] rsmObjs = this.getRsmObjsByPositionId(positionId);
        logger.info("\u6839\u636e\u804c\u4f4d\u67e5\u8be2\u5bf9\u5e94\u90ae\u7bb1\u6293\u53d6\u7684\u5f85\u5206\u914d\u7b80\u5386,positionId:{},rsmObjs:{}", (Object)positionId, (Object)rsmObjs);
        int successCount = 0;
        int allCount = rsmObjs.length;
        for (DynamicObject rsmObj : rsmObjs) {
            DynamicObject deliveryObj = rsmObj.getDynamicObject("delivery");
            List<Long> ids = this.rsmAssignRule(deliveryObj, ruleObjs);
            if (ids.isEmpty()) continue;
            Long rsmId = rsmObj.getLong("id");
            this.invokeRpcHandleUnAllocatedRsm(rsmId, ids);
            ++successCount;
        }
        String content = successCount > 0 ? ResManager.loadKDString((String)"%s\u7684\u7b80\u5386\u5206\u914d\u89c4\u5219\u5df2\u6267\u884c\u7ed3\u675f\uff0c\u5171\u6267\u884c\u5f85\u5206\u914d\u7b80\u5386%s\u4efd,\u6210\u529f\u5206\u914d%s\u4efd\u7b80\u5386\u3002", (String)"PositionRuleList_10", (String)"tsc-tspr-business", (Object[])new Object[]{positionName, allCount, successCount}) : ResManager.loadKDString((String)"%s\u7684\u7b80\u5386\u5206\u914d\u89c4\u5219\u5df2\u6267\u884c\u7ed3\u675f\uff0c\u7cfb\u7edf\u5185\u6682\u65e0\u7b26\u5408\u8be5\u804c\u4f4d\u7b80\u5386\u5206\u914d\u89c4\u5219\u7684\u7b80\u5386\uff0c\u8bf7\u7b49\u5f85\u65b0\u7b80\u5386\u5165\u5e93\u6216\u4fee\u6539/\u65b0\u5efa\u5206\u914d\u6761\u4ef6\u540e\u518d\u6b21\u6267\u884c\u3002", (String)"PositionRuleList_11", (String)"tsc-tspr-business", (Object[])new Object[]{positionName, allCount, successCount});
        this.sendMessage(content);
        logger.info("\u7b80\u5386\u5206\u914d\u89c4\u5219\u6267\u884c\u7ed3\u675f\uff0c\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01");
    }

    public List<Long> rsmAssignRule(DynamicObject deliveryObj, DynamicObject[] ruleObjs) {
        logger.info("ruleObjs:{}", (Object)ruleObjs.length);
        ArrayList<Long> ids = new ArrayList<Long>(ruleObjs.length);
        String emailTitle = deliveryObj.getString("emailtitle");
        String attachName = deliveryObj.getString("attachname");
        String postPosition = deliveryObj.getString("postposition");
        Long tmpId = 0L;
        for (DynamicObject ruleObj : ruleObjs) {
            String distriMode = ruleObj.getString("distrimode");
            String keywordStr = ruleObj.getString("keyword");
            Long positionId = ruleObj.getLong("positionid");
            if (tmpId.longValue() == positionId.longValue()) {
                logger.info("continue:positionId:{}", (Object)positionId);
                continue;
            }
            if ("A".equals(distriMode) && this.assignKeywords(postPosition, keywordStr).booleanValue()) {
                ids.add(positionId);
                return ids;
            }
            if ("B".equals(distriMode) && this.assignKeywords(emailTitle, keywordStr).booleanValue()) {
                tmpId = positionId;
                ids.add(positionId);
                continue;
            }
            if (!"C".equals(distriMode) || !this.assignKeywords(attachName, keywordStr).booleanValue()) continue;
            tmpId = positionId;
            ids.add(positionId);
        }
        return ids;
    }

    public DynamicObject[] getRuleObjs(List<Long> positionIds, String issyspreset) {
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter distriMode = new QFilter("issyspreset", "=", (Object)issyspreset);
        QFilter[] filters = new QFilter[]{enable, distriMode};
        return ruleServiceHelper.loadDynamicObjectArray(filters);
    }

    public DynamicObject[] getRsmObjsByPositionId(Long positionId) {
        ArrayList<Long> positionIds = new ArrayList<Long>(1);
        positionIds.add(positionId);
        Map<Long, List<Long>> emailMaps = PositionManageServiceHelper.getMailInfoIdByPositionBo(positionIds);
        if (emailMaps == null) {
            return null;
        }
        List<Long> emailIds = emailMaps.get(positionId);
        QFilter emailId = new QFilter("delivery.emailsource.id", "in", emailIds);
        QFilter assignStatus = new QFilter("delivery.assignstatus", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{emailId, assignStatus};
        return rsmServiceHelper.loadDynamicObjectArray(filters);
    }

    public Boolean assignKeywords(String str, String keywordStr) {
        if (StringUtils.isEmpty((CharSequence)keywordStr) || StringUtils.isEmpty((CharSequence)str)) {
            return Boolean.FALSE;
        }
        String[] keywords = keywordStr.split("\u3001");
        logger.info("\u90ae\u7bb1\u4e3b\u9898:{},\u5173\u952e\u8bcd:{}", (Object)str, (Object)keywords);
        for (String keyword : keywords) {
            if (!StringUtils.isNotEmpty((CharSequence)keyword) || str.contains(keyword)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void sendMessage(String contentCn) {
        MessageInfo message = new MessageInfo();
        LocaleString title = new LocaleString();
        title.setLocaleValue_en("");
        title.setLocaleValue_zh_CN("\u7b80\u5386\u5206\u914d\u89c4\u5219\u6267\u884c\u7ed3\u679c");
        title.setLocaleValue_zh_TW("");
        LocaleString content = new LocaleString();
        content.setLocaleValue_en("");
        content.setLocaleValue_zh_CN(contentCn);
        content.setLocaleValue_zh_TW("");
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(Long.parseLong(RequestContext.get().getUserId()));
        LocaleString tag = new LocaleString();
        tag.setLocaleValue("\u91cd\u8981");
        message.setMessageTitle((ILocaleString)title);
        message.setMessageContent((ILocaleString)content);
        message.setMessageTag((ILocaleString)tag);
        message.setUserIds(receivers);
        message.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        message.setSenderName("\u4eba\u624d\u4f9b\u5e94\u4e91");
        message.setType("notice");
        message.setEntityNumber("tspr_positionrule");
        message.setNotifyType("sysnotice");
        message.setToAll(false);
        HashMap param = new HashMap();
        HashMap<String, Integer> systemNotice = new HashMap<String, Integer>();
        systemNotice.put("showType", 2);
        param.put("systemNotice", systemNotice);
        message.setParams(param);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    private void invokeRpcHandleUnAllocatedRsm(Long rsmId, List<Long> positionIds) {
        DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"rsmServiceApi", (String)"handleUnAllocatedRsm", (Object[])new Object[]{rsmId, positionIds});
    }
}

