/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.MergeListColumn;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.position.service.PositionManageServiceHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class PositionWriteFileHelper {
    public static void deleteColumn(Sheet sheet, int columnToDelete) {
        for (int rId = 0; rId <= sheet.getLastRowNum(); ++rId) {
            Row row = sheet.getRow(rId);
            for (int cID = columnToDelete; cID <= row.getLastCellNum(); ++cID) {
                Cell cNext;
                Cell cOld = row.getCell(cID);
                if (cOld != null) {
                    row.removeCell(cOld);
                }
                if ((cNext = row.getCell(cID + 1)) == null) continue;
                Cell cNew = row.createCell(cID, cNext.getCellType());
                PositionWriteFileHelper.cloneCell(cNew, cNext);
                if (rId != 0) continue;
                sheet.setColumnWidth(cID, sheet.getColumnWidth(cID + 1));
            }
        }
    }

    private static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        if (CellType.BOOLEAN == cNew.getCellType()) {
            cNew.setCellValue(cOld.getBooleanCellValue());
        } else if (CellType.NUMERIC == cNew.getCellType()) {
            cNew.setCellValue(cOld.getNumericCellValue());
        } else if (CellType.STRING == cNew.getCellType()) {
            cNew.setCellValue(cOld.getStringCellValue());
        } else if (CellType.ERROR == cNew.getCellType()) {
            cNew.setCellValue((double)cOld.getErrorCellValue());
        } else if (CellType.FORMULA == cNew.getCellType()) {
            cNew.setCellValue(cOld.getCellFormula());
        }
    }

    public static void writeDataListToFile(Sheet sheet, List<IListColumn> showListColumns, DynamicObjectCollection exportDataList) {
        if (exportDataList.size() == 0) {
            return;
        }
        List<Long> positionIds = exportDataList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObject[] manageInfos = PositionManageServiceHelper.getManageInfoByPositionIds(positionIds);
        HashMap secCodeMap = Maps.newHashMapWithExpectedSize((int)manageInfos.length);
        for (DynamicObject manageInfo : manageInfos) {
            Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)manageInfo, (String)"position");
            String secCode = manageInfo.getString("seclevel.codelevel");
            if (!HRStringUtils.isNotEmpty((String)secCode)) continue;
            secCodeMap.put(positionId, secCode);
        }
        int j = showListColumns.size() - 1;
        for (int i = 0; i < j; ++i) {
            IListColumn column = showListColumns.get(i);
            if (column instanceof MergeListColumn) {
                PositionWriteFileHelper.deleteColumn(sheet, i);
                continue;
            }
            if (!(column instanceof ListColumn)) continue;
            if ("recruitnum".equals(((ListColumn)column).getFieldKey()) && column.getVisible() > 0) {
                PositionWriteFileHelper.writeSheetRecruitNumContent(exportDataList, sheet, i);
                continue;
            }
            if ("candidatornum".equals(((ListColumn)column).getFieldKey()) && column.getVisible() > 0) {
                PositionWriteFileHelper.writeSheetCandidateNumContent(exportDataList, sheet, i);
                continue;
            }
            if ("workaddr.name".equals(((ListColumn)column).getFieldKey()) && column.getVisible() > 0) {
                PositionWriteFileHelper.writeSheetWorkCityContent(exportDataList, sheet, i);
                continue;
            }
            if (HRStringUtils.equals((String)"manageinfo.seclevel.number", (String)((ListColumn)column).getFieldKey()) && column.getVisible() > 0) {
                PositionWriteFileHelper.writeSeclevelContent(exportDataList, sheet, i, secCodeMap);
                continue;
            }
            if (!"status".equals(((ListColumn)column).getFieldKey()) || column.getVisible() <= 0) continue;
            PositionWriteFileHelper.writeSheetStatusContent(exportDataList, sheet, i);
        }
    }

    private static void writeSheetRecruitNumContent(DynamicObjectCollection exportDataList, Sheet sheet, int cellIndex) {
        int j = exportDataList.size();
        for (int i = 0; i < j; ++i) {
            DynamicObject exportData = (DynamicObject)exportDataList.get(i);
            if (!exportData.getBoolean("isrecnumlimit")) continue;
            Row row = sheet.getRow(i + 1);
            Cell cell = row.getCell(cellIndex);
            cell.setCellValue(ResManager.loadKDString((String)"\u82e5\u5e72", (String)"PositionWriteFileHelper_1", (String)"tsc-tspr-business", (Object[])new Object[0]));
        }
    }

    private static void writeSheetCandidateNumContent(DynamicObjectCollection exportDataList, Sheet sheet, int cellIndex) {
        int j = exportDataList.size();
        for (int i = 0; i < j; ++i) {
            DynamicObject exportData = (DynamicObject)exportDataList.get(i);
            if (!"B".equals(exportData.getString("positionstatus"))) continue;
            Row row = sheet.getRow(i + 1);
            Cell cell = row.getCell(cellIndex);
            cell.setCellValue("");
        }
    }

    private static void writeSheetStatusContent(DynamicObjectCollection exportDataList, Sheet sheet, int cellIndex) {
        int j = exportDataList.size();
        for (int i = 0; i < j; ++i) {
            DynamicObject exportData = (DynamicObject)exportDataList.get(i);
            String billno = exportData.getString("billno");
            if (!HRStringUtils.isEmpty((String)billno)) continue;
            Row row = sheet.getRow(i + 1);
            Cell cell = row.getCell(cellIndex);
            cell.setBlank();
            cell.setCellValue("");
        }
    }

    private static void writeSheetWorkCityContent(DynamicObjectCollection exportDataList, Sheet sheet, int cellIndex) {
        int j = exportDataList.size();
        for (int i = 0; i < j; ++i) {
            DynamicObject exportData = (DynamicObject)exportDataList.get(i);
            HashSet<String> cityNameSet = new HashSet<String>(16);
            DynamicObjectCollection dynamicObjectCollection = exportData.getDynamicObjectCollection("workaddr");
            if (dynamicObjectCollection.size() <= 0) continue;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String cityName = dynamicObject.getDynamicObject("fbasedataid").getString("city.name");
                cityNameSet.add(cityName);
            }
            String joinValue = String.join((CharSequence)";", cityNameSet);
            Row row = sheet.getRow(i + 1);
            Cell cell = row.getCell(cellIndex - 1);
            if (cell == null) continue;
            cell.setCellValue(joinValue);
        }
    }

    private static void writeSeclevelContent(DynamicObjectCollection exportDataList, Sheet sheet, int cellIndex, Map<Long, String> secCodeMap) {
        int j = exportDataList.size();
        for (int i = 0; i < j; ++i) {
            Row row;
            Cell cell;
            DynamicObject exportData = (DynamicObject)exportDataList.get(i);
            long positionId = exportData.getLong("id");
            String secLevel = secCodeMap.get(positionId);
            if (!HRStringUtils.isNotEmpty((String)secLevel) || (cell = (row = sheet.getRow(i + 1)).getCell(cellIndex)) == null) continue;
            cell.setBlank();
            cell.setCellValue(secLevel);
        }
    }
}

