/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service.permission;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tsc.tspr.business.domain.position.service.PositionDataHelper;
import kd.tsc.tspr.business.domain.position.service.enums.PositionPermEnum;
import kd.tsc.tspr.common.constants.position.PositionManageConstants;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.ObjectUtils;

public class PositionPermService {
    public List<PositionPermEnum> positionPermEnums;
    public QFilter qFilter;
    private static final String CLOUDID = "hrmp";
    private static final String HRCS = "hrcs";
    private static final String SERVICENAME = "IHRCSStrategyService";
    private static final String HRBU = "hrbu";
    private static final Long ORGNUMBER = 1280L;
    private static final HashMap<String, Consumer<Map<String, Object>>> PERMISSION_MAP = new HashMap(8);

    public QFilter getHavePermPositionQFilter() {
        long currUserId;
        boolean superUser;
        boolean isOnlyContainsDelivery;
        boolean bl = isOnlyContainsDelivery = this.positionPermEnums.contains((Object)PositionPermEnum.DELIVERY) && this.positionPermEnums.size() == 1;
        if (!isOnlyContainsDelivery && (superUser = PermissionServiceHelper.isSuperUser((long)(currUserId = RequestContext.get().getCurrUserId())))) {
            return null;
        }
        for (PositionPermEnum permEnum : this.positionPermEnums) {
            String permItem = permEnum.getPermItem();
            Optional.ofNullable(PERMISSION_MAP.get(permItem)).ifPresent(con -> con.accept(new HashMap(0)));
        }
        return this.qFilter;
    }

    public List<Long> listHavePermPosition() {
        QFilter qFilter = this.getHavePermPositionQFilter();
        DynamicObject[] dynamicObjects = PositionDataHelper.queryPositionByQFilter(new QFilter[]{qFilter});
        List<Long> positionIdList = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return positionIdList;
    }

    public List<Long> getPositionHasPermOrgs() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)false);
        return userHasPermOrgs.getHasPermOrgs();
    }

    public Map<Long, Long> getOrgByAdminOrg(List<Long> adminOrgIdList) {
        if (ObjectUtils.isEmpty(adminOrgIdList)) {
            return null;
        }
        HashMap<Long, Long> relationMap = new HashMap<Long, Long>(adminOrgIdList.size());
        for (Long adminOrgId : adminOrgIdList) {
            Map<String, Object> result = this.getHRBUFromManageOrgStrategy(adminOrgId);
            DynamicObject orgDy = (DynamicObject)result.get(HRBU);
            Long orgId = 0L;
            if (ObjectUtils.isNotEmpty((Object)orgDy)) {
                orgId = orgDy.getLong("id");
            }
            relationMap.put(adminOrgId, orgId);
        }
        return relationMap;
    }

    private Map<String, Object> getHRBUFromManageOrgStrategy(Long adminOrgId) {
        return (Map)DispatchServiceHelper.invokeBizService((String)CLOUDID, (String)HRCS, (String)SERVICENAME, (String)"getHRBUFromManageOrgStrategy", (Object[])new Object[]{adminOrgId, ORGNUMBER});
    }

    private void setAdminOrgFilter() {
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tssrm", (String)"tssrm_position_add", (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)"adminorgs.fbasedataid");
        if (userAdminOrgFilter == null) {
            return;
        }
        if (this.qFilter == null) {
            this.qFilter = userAdminOrgFilter;
        } else {
            this.qFilter.and(userAdminOrgFilter);
        }
    }

    private void setOrgFilter() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)false);
        QFilter qFilter = new QFilter("createorg", "in", (Object)userHasPermOrgs.getHasPermOrgs());
        if (this.qFilter == null) {
            this.qFilter = qFilter;
        } else {
            this.qFilter.and(qFilter);
        }
    }

    private void setSevLevelQFilter() {
        boolean flag = SecConfHelper.querySecurityConf((Long)PositionManageConstants.SECLEVEL_NUMBER);
        if (flag) {
            Long accountId = RequestContext.get().getCurrUserId();
            DynamicObject securityLevel = SecuserHelper.queryUserSecurityLevel((Long)accountId, (Long)PositionManageConstants.SECLEVEL_NUMBER);
            long secLevelId = securityLevel.getLong("id");
            QFilter qFilter = new QFilter("manageinfo.seclevel", ">=", (Object)secLevelId);
            QFilter creator = new QFilter("creator", "=", (Object)accountId);
            qFilter.or(creator);
            if (this.qFilter == null) {
                this.qFilter = qFilter;
            } else {
                this.qFilter.and(qFilter);
            }
        }
    }

    private void setDeliveryQFilter() {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)currUserId);
        if (this.qFilter == null) {
            this.qFilter = qFilter;
        } else {
            this.qFilter.or(qFilter);
        }
    }

    private PositionPermService(List<PositionPermEnum> positionPermEnums) {
        PERMISSION_MAP.put(PositionPermEnum.ADMIN_ORG.getPermItem(), map -> this.setAdminOrgFilter());
        PERMISSION_MAP.put(PositionPermEnum.ORG.getPermItem(), map -> this.setOrgFilter());
        PERMISSION_MAP.put(PositionPermEnum.SEV_LEVEL.getPermItem(), map -> this.setSevLevelQFilter());
        PERMISSION_MAP.put(PositionPermEnum.DELIVERY.getPermItem(), map -> this.setDeliveryQFilter());
        this.positionPermEnums = positionPermEnums;
    }

    private PositionPermService() {
        PERMISSION_MAP.put(PositionPermEnum.ADMIN_ORG.getPermItem(), map -> this.setAdminOrgFilter());
        PERMISSION_MAP.put(PositionPermEnum.ORG.getPermItem(), map -> this.setOrgFilter());
        PERMISSION_MAP.put(PositionPermEnum.SEV_LEVEL.getPermItem(), map -> this.setSevLevelQFilter());
        PERMISSION_MAP.put(PositionPermEnum.DELIVERY.getPermItem(), map -> this.setDeliveryQFilter());
        this.positionPermEnums = ImmutableList.of((Object)((Object)PositionPermEnum.ADMIN_ORG), (Object)((Object)PositionPermEnum.ORG), (Object)((Object)PositionPermEnum.SEV_LEVEL), (Object)((Object)PositionPermEnum.DELIVERY));
    }

    public static PositionPermService getInstance(List<PositionPermEnum> positionPermEnums) {
        if (ObjectUtils.isEmpty(positionPermEnums)) {
            return new PositionPermService();
        }
        return new PositionPermService(positionPermEnums);
    }
}

