/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.recycleresume.service.recyle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.recycleresume.service.recyle.ChannelWhiteListService;
import kd.tsc.tspr.business.domain.recycleresume.service.recyle.RecycleResumeThread;
import kd.tsc.tspr.business.domain.recycleresume.service.recyle.handler.RecycleResumeHandler;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.EmailInfoServiceHelper;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.MailInfoService;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.UniversalMail;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.RecycleTaskServiceHelper;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleResumeRecord;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleTaskInfo;

public class RecycleResumeComponent {
    private static final Log logger = LogFactory.getLog(RecycleResumeComponent.class);
    private static final Integer MAX_WAIT_TIME = 12000;
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"recycleResumeThreadPools");
    private List<RecycleResumeHandler> handlerList = ChannelWhiteListService.getInstance().getHandlerList();

    private RecycleResumeComponent() {
    }

    public static RecycleResumeComponent getInstance() {
        return new RecycleResumeComponent();
    }

    public void recycleResume() {
        DynamicObject[] mailInfos = EmailInfoServiceHelper.getEmailInfo();
        logger.info("mailInfo dys sizs is: {}", (Object)mailInfos.length);
        ArrayList taskInfoList = Lists.newArrayListWithExpectedSize((int)mailInfos.length);
        ArrayList allRecordList = Lists.newArrayListWithExpectedSize((int)mailInfos.length);
        Arrays.stream(mailInfos).filter(mailInfo -> mailInfo.getLong("id") == mailInfo.getLong("masterid")).forEach(mailInfo -> {
            try {
                RecycleTaskInfo taskInfo = this.genTaskInfo((DynamicObject)mailInfo);
                List<UniversalMail> recycleMailList = this.getRecycleUniversalMail((DynamicObject)mailInfo, taskInfo);
                if (recycleMailList.size() == 0) {
                    taskInfoList.add(taskInfo);
                    return;
                }
                CountDownLatch latch = new CountDownLatch(recycleMailList.size());
                List<RecycleResumeRecord> recordList = this.executeRecycle(recycleMailList, taskInfo, latch);
                taskInfoList.add(taskInfo);
                allRecordList.addAll(recordList);
                logger.info("RecycleResumeComponent.recycleResume taskInfoList size is {}", (Object)taskInfoList.size());
                logger.info("RecycleResumeComponent.recycleResume allRecordList size is {}", (Object)allRecordList.size());
            }
            catch (Exception exception) {
                logger.error("mail info execute recycle error!");
                logger.error((Throwable)exception);
            }
        });
        try {
            logger.info("RecycleResumeComponent.recycleResume taskInfoList size is {}", (Object)taskInfoList.size());
            logger.info("RecycleResumeComponent.recycleResume allRecordList size is {}", (Object)allRecordList.size());
            EmailInfoServiceHelper.resolveErrorMailInfo((List)taskInfoList);
            RecycleTaskServiceHelper.saveTask((List)taskInfoList, (List)allRecordList);
        }
        catch (Exception exception) {
            logger.error("save record error!");
            logger.error((Throwable)exception);
        }
    }

    private void recycleResumeCount() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recyclerecord");
        QFilter rsmFilter = new QFilter("rsmid", "!=", (Object)0L);
        QFilter statusFilter = new QFilter("recyclestatus", "=", (Object)"1");
        try (DataSet dataSet = serviceHelper.queryDataSet("tsrbd_recyclerecord", "rsmid, mailinfo, recyclestatus, id", new QFilter[]{rsmFilter, statusFilter});
             DataSet count = dataSet.groupBy(new String[]{"mailinfo"}).count("rsmcount").finish();){
            DynamicObject[] dys;
            ArrayList mailInfoList = Lists.newArrayListWithExpectedSize((int)16);
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Row row : count) {
                Long mailInfoId = row.getLong("mailinfo.id");
                Integer rsmcount = row.getInteger("rsmcount");
                mailInfoList.add(mailInfoId);
                resultMap.put(mailInfoId, rsmcount);
            }
            count.close();
            HRBaseServiceHelper mailServerHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
            QFilter idFiter = new QFilter("id", "in", (Object)mailInfoList);
            for (DynamicObject dyn : dys = mailServerHelper.query("id, rsmcount", new QFilter[]{idFiter})) {
                long id = dyn.getLong("id");
                Integer rsmCount = (Integer)resultMap.get(id);
                dyn.set("rsmcount", (Object)rsmCount);
            }
            mailServerHelper.save(dys);
        }
    }

    private List<UniversalMail> getRecycleUniversalMail(DynamicObject mailInfo, RecycleTaskInfo taskInfo) {
        List recyleEmail = null;
        try {
            recyleEmail = MailInfoService.getInstance().getRecyleEmail(mailInfo, taskInfo);
        }
        catch (Exception e) {
            logger.error("get Mail Message error!");
            logger.error((Throwable)e);
            taskInfo.setTaskStatus("-3");
        }
        return recyleEmail == null ? new ArrayList() : recyleEmail;
    }

    private List<RecycleResumeRecord> executeRecycle(List<UniversalMail> recyleEmail, RecycleTaskInfo taskInfo, CountDownLatch latch) {
        ArrayList futureList = Lists.newArrayListWithExpectedSize((int)recyleEmail.size());
        for (UniversalMail universalMail : recyleEmail) {
            RecycleResumeThread thread = new RecycleResumeThread(universalMail, taskInfo, latch, this.handlerList);
            Future future = THREAD_POOL.submit((Callable)thread);
            futureList.add(future);
        }
        ArrayList recordList = Lists.newArrayListWithExpectedSize((int)recyleEmail.size());
        for (Future future : futureList) {
            try {
                RecycleResumeRecord recycleResumeRecord = (RecycleResumeRecord)future.get(MAX_WAIT_TIME.intValue(), TimeUnit.MILLISECONDS);
                logger.info("future get value is : {}", (Object)recycleResumeRecord);
                recordList.add(recycleResumeRecord);
                if (HRStringUtils.equals((String)recycleResumeRecord.getRecycleStatus(), (String)"1")) {
                    taskInfo.getSuccessCunt().incrementAndGet();
                    taskInfo.getSumCunt().incrementAndGet();
                    continue;
                }
                if (!HRStringUtils.equals((String)recycleResumeRecord.getRecycleStatus(), (String)"0")) continue;
                taskInfo.getFaildCunt().incrementAndGet();
                taskInfo.getSumCunt().incrementAndGet();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error("RecycleResumeComponent.executeRecycle has something wrong!");
                logger.error((Throwable)e);
            }
        }
        logger.info("recordList size is {}", (Object)recordList.size());
        return recordList;
    }

    private RecycleTaskInfo genTaskInfo(DynamicObject mailInfo) {
        RecycleTaskInfo taskInfo = new RecycleTaskInfo();
        taskInfo.setTaskId(this.genTaskId());
        taskInfo.setMainInfoId(Long.valueOf(mailInfo.getLong("id")));
        taskInfo.setStartDate(new Date());
        taskInfo.setMailInfo(mailInfo);
        return taskInfo;
    }

    private Long genTaskId() {
        return ORM.create().genLongId("tsrbd_recycletask");
    }
}

