/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.recycleresume.service.recyle;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.recycleresume.service.recyle.handler.RecycleResumeHandler;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.UniversalMail;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleResumeRecord;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleTaskInfo;

public class RecycleResumeThread
implements Callable<RecycleResumeRecord> {
    private static final Log logger = LogFactory.getLog(RecycleResumeThread.class);
    private UniversalMail universalMail;
    private RecycleTaskInfo taskInfo;
    private CountDownLatch latch;
    private List<RecycleResumeHandler> handlerList;

    public RecycleResumeThread(UniversalMail universalMail, RecycleTaskInfo taskInfo, CountDownLatch latch, List<RecycleResumeHandler> handlerList) {
        this.universalMail = universalMail;
        this.taskInfo = taskInfo;
        this.latch = latch;
        this.handlerList = handlerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecycleResumeRecord call() throws Exception {
        RecycleResumeRecord recycleResumeRecord = new RecycleResumeRecord();
        recycleResumeRecord.setTaskInfoId(this.taskInfo.getTaskId());
        recycleResumeRecord.setUid(this.universalMail.getUid());
        recycleResumeRecord.setRecycleStatus("-1");
        recycleResumeRecord.setMailInfo(this.taskInfo.getMainInfoId());
        logger.info("RecycleResumeThread.call:universal mail is {}", (Object)this.universalMail.getTitle());
        try {
            for (RecycleResumeHandler recycleResumeHandler : this.handlerList) {
                if (!recycleResumeHandler.support(this.universalMail.getTitle())) continue;
                recycleResumeHandler.handle(this.universalMail, recycleResumeRecord);
            }
        }
        catch (Exception e) {
            logger.error("{} parse error!", (Object)this.universalMail.getUid(), (Object)e);
            recycleResumeRecord.setRecycleStatus("0");
        }
        finally {
            logger.info("{} latch countDown", (Object)this.universalMail.getTitle());
            this.latch.countDown();
        }
        return recycleResumeRecord;
    }
}

