/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.recycleresume.service.recyle.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.UniversalMail;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleResumeRecord;
import kd.tsc.tsrbs.business.domain.rsm.entity.MailRsmAnalysis;

public abstract class RecycleResumeHandler {
    private static final Log logger = LogFactory.getLog(RecycleResumeHandler.class);
    protected DynamicObject channelWhiteInfo;
    protected String position = "";
    protected String titleCity = "";
    protected String attachPosition = "";
    protected String attachCity = "";
    protected String attachName = "";
    private static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+", "&"};

    public RecycleResumeHandler(DynamicObject channelWhiteInfo) {
        this.channelWhiteInfo = channelWhiteInfo;
    }

    public RecycleResumeHandler() {
    }

    public void setChannelWhiteInfo(DynamicObject channelWhiteInfo) {
        this.channelWhiteInfo = channelWhiteInfo;
    }

    public boolean support(String subject) {
        String regex = this.channelWhiteInfo.getString("regex");
        boolean regexResult = true;
        if (!HRStringUtils.isEmpty((String)regex)) {
            String[] splits;
            for (String split : splits = regex.split(",")) {
                if (subject == null || subject.matches(split)) continue;
                regexResult = false;
                break;
            }
        }
        String indexOf = this.channelWhiteInfo.getString("indexof");
        boolean indexOfResult = true;
        if (!HRStringUtils.isEmpty((String)indexOf)) {
            String[] splits;
            for (String split : splits = indexOf.split(",")) {
                if (subject == null || subject.toLowerCase().indexOf(split) > 0) continue;
                indexOfResult = false;
                break;
            }
        }
        return subject != null && regexResult && indexOfResult;
    }

    protected abstract String universalMailHandler(UniversalMail var1) throws MessagingException, IOException;

    public Long handle(UniversalMail universalMail, RecycleResumeRecord record) throws IOException, MessagingException {
        record.setChannelId(Long.valueOf(this.channelWhiteInfo.getLong("recruchnlnm.id")));
        record.setTitle(universalMail.getTitle());
        String url = this.universalMailHandler(universalMail);
        record.setUrl(url);
        Long rsmId = this.resolveResume(url, universalMail.getUid(), record);
        record.setRsmId(rsmId);
        return rsmId;
    }

    public String writeToFile(String fileName, String content, UniversalMail universalMail) {
        logger.info("filename is : {}", (Object)fileName);
        String fileNameDoc = fileName + ".doc";
        String fileNameTxt = fileName + ".txt";
        String head = this.getHead();
        FileService service = FileServiceFactory.getAttachmentFileService();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder contentSB = stringBuilder.append(head).append(content).append("</html>");
        String pathUrl = this.getPathUrl(universalMail, fileNameDoc);
        FileItem fileItemdoc = new FileItem(fileNameDoc, pathUrl, (InputStream)new ByteArrayInputStream(contentSB.toString().getBytes()));
        FileItem fileItemdocTxt = new FileItem(fileNameDoc, this.getPathUrl(universalMail, fileNameTxt), (InputStream)new ByteArrayInputStream(contentSB.toString().getBytes(StandardCharsets.UTF_8)));
        fileItemdoc.setCreateNewFileWhenExists(true);
        fileItemdocTxt.setCreateNewFileWhenExists(true);
        String result = service.upload(fileItemdoc);
        service.upload(fileItemdocTxt);
        logger.info("url is : {}", (Object)result);
        logger.info("pathUrl is : {}", (Object)pathUrl);
        return result;
    }

    private String getHead() {
        return "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></meta><meta content=\"telephone=no\" name=\"format-detection\"></meta></head>";
    }

    protected String replaceSpeSymbol(String str) {
        for (String specialSymbol : SPECIAL_SYMBOLS) {
            if (!str.contains(specialSymbol)) continue;
            str = str.replace(specialSymbol, "_");
        }
        return str;
    }

    protected String getPathUrl(UniversalMail universalMail, String fileName) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)universalMail.getUid(), (String)this.replaceSpeSymbol(fileName));
    }

    protected Long resolveResume(String url, String universalMailId, RecycleResumeRecord record) {
        logger.info("sync rsm url is : {}", (Object)url);
        MailRsmAnalysis mailRsmAnalysis = new MailRsmAnalysis();
        mailRsmAnalysis.setUrl(url);
        mailRsmAnalysis.setId(universalMailId);
        mailRsmAnalysis.setEmailId(record.getMailInfo());
        mailRsmAnalysis.setEmailTitle(record.getTitle());
        mailRsmAnalysis.setTitleCity(this.titleCity);
        mailRsmAnalysis.setTitlePosition(this.position);
        mailRsmAnalysis.setAttachCity(this.attachCity);
        mailRsmAnalysis.setAttachName(this.attachName);
        mailRsmAnalysis.setAttachPosition(this.attachPosition);
        mailRsmAnalysis.setRecruchnlnmId(record.getChannelId());
        List results = (List)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"rsmServiceApi", (String)"mailAddRsm", (Object[])new Object[]{Collections.singletonList(mailRsmAnalysis)});
        MailRsmAnalysis rsmAnalysis = (MailRsmAnalysis)results.get(0);
        logger.info("rsmServiceApi.mailAddRsm result is: {}", (Object)rsmAnalysis);
        logger.info("mailRsmAnalysis error code is : {}", (Object)rsmAnalysis.getErrorCode());
        if (HRStringUtils.equals((String)mailRsmAnalysis.getErrorCode(), (String)"100")) {
            record.setRecycleStatus("1");
        } else {
            record.setRecycleStatus("0");
        }
        logger.info("mailRsmAnalysis value is + {}", (Object)mailRsmAnalysis);
        List rmsIdList = mailRsmAnalysis.getRmsIdList();
        if (rmsIdList != null && rmsIdList.size() > 0) {
            return (Long)rmsIdList.get(0);
        }
        return 0L;
    }

    protected String getDateString(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }
}

