/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.recycleresume.service.recyle.handler;

import java.io.IOException;
import java.util.Date;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.recycleresume.service.recyle.handler.RecycleResumeHandler;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.UniversalMail;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ZhiLianRecyleResumeHandler
extends RecycleResumeHandler {
    private static final Log logger = LogFactory.getLog(ZhiLianRecyleResumeHandler.class);

    @Override
    protected String universalMailHandler(UniversalMail universalMail) throws MessagingException, IOException {
        String url = "";
        Object content = universalMail.getContent();
        Date sendDate = universalMail.getSendDate();
        String subject = universalMail.getTitle();
        String mailRange = this.channelWhiteInfo.getString("indexof");
        if (subject != null && mailRange != null) {
            String prePosition = subject.substring(subject.indexOf(mailRange) + mailRange.length(), subject.lastIndexOf("-")).trim();
            String[] split = prePosition.split("-");
            int length = split.length;
            if (length == 2) {
                this.position = split[0];
                this.titleCity = split[1];
            } else if (length == 3) {
                this.position = split[1];
                this.titleCity = split[2];
            } else {
                logger.error("prePostion is : {}", (Object)prePosition);
                this.position = prePosition;
            }
            String name = subject.substring(subject.lastIndexOf("-") + 1).trim();
            String fileName = name + "-" + this.position + "-zhilian-" + this.getDateString(sendDate, "yyyyMMdd");
            url = this.resolveZhiLianContent(content, fileName, universalMail);
        }
        return url;
    }

    private String resolveZhiLianContent(Object content, String fileName, UniversalMail universalMail) throws MessagingException, IOException {
        String url = "";
        if (content instanceof String) {
            logger.info("this part is not html,this content is: {}", content);
        } else if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            BodyPart part = multipart.getBodyPart(0);
            String type = part.getContentType().split(";")[0];
            if ((type = type.toLowerCase()).matches(".*plain*.")) {
                part = multipart.getBodyPart(1);
                type = part.getContentType().split(";")[0];
                type = type.toLowerCase();
            }
            if (type.matches(".*html*.") || type.matches(".*plain*.")) {
                String htmlContent = part.getContent().toString();
                Document parse = Jsoup.parse((String)htmlContent);
                Elements tables = parse.getElementsByTag("table");
                Element element = (Element)tables.get(2);
                String text = element.text();
                logger.info("Jsoup parse emement : {}", (Object)text);
                url = this.writeToFile(fileName, htmlContent, universalMail);
            }
            logger.info("Multipart Type is: {}", (Object)type);
        }
        return url;
    }
}

