/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.resumefilter.service;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ResumeFilterHelper {
    private static final Log logger = LogFactory.getLog(ResumeFilterHelper.class);
    public static final HRBaseServiceHelper RESUME_FILTER_TASK_HELPER = new HRBaseServiceHelper("tspr_resumefilter");
    public static final HRBaseServiceHelper TSTPM_RSM_HELPER = new HRBaseServiceHelper("tstpm_rsm");

    private ResumeFilterHelper() {
    }

    public static ResumeFilterHelper getInstance() {
        return Instance.instance;
    }

    public static DynamicObject queryOneResumeFilterTaskByPk(Object resumeFilterTasksPk) {
        String selectProperties = "id,appfile,recruitmentposition,candidate";
        QFilter qFilter = new QFilter("id", "=", resumeFilterTasksPk);
        return RESUME_FILTER_TASK_HELPER.queryOne(selectProperties, qFilter.toArray());
    }

    public static DynamicObject[] queryResumeFilterTasks(List<Long> resscrTaskIds, String ... selectProperties) {
        QFilter filter = new QFilter("id", "in", resscrTaskIds);
        ArrayList<String> selectPropertyList = new ArrayList<String>(10);
        if (selectProperties == null || selectProperties.length == 0) {
            selectPropertyList.add("id");
        }
        if (null != selectProperties && selectProperties.length > 0) {
            for (String selectProperty : selectProperties) {
                selectPropertyList.add(selectProperty);
            }
        }
        String selectProperty = Joiner.on((char)',').skipNulls().join(selectPropertyList);
        return RESUME_FILTER_TASK_HELPER.query(selectProperty, filter.toArray());
    }

    public DynamicObject[] getRsmByIds(List<Long> rsmIdList) {
        QFilter qFilter = new QFilter("id", "in", rsmIdList);
        String selectProps = "id,fullname,gender,gender,highesteducation,highesteduschool,highestspecialty,workingyears,highestspecialty,highestspecialty,highestspecialty";
        return TSTPM_RSM_HELPER.query(selectProps, qFilter.toArray());
    }

    public Map<Long, DynamicObject> getCandidateMap(DynamicObject[] taskList) {
        List<Long> candidateIds = Arrays.stream(taskList).map(task -> task.getLong("candidate")).collect(Collectors.toList());
        candidateIds = candidateIds.stream().distinct().collect(Collectors.toList());
        DynamicObject[] candidates = this.getRsmByIds(candidateIds);
        HashMap candidateMap = Arrays.stream(candidates).collect(HashMap::new, (map, candidate) -> map.put(candidate.getLong("id"), candidate), HashMap::putAll);
        return candidateMap;
    }

    private static class Instance {
        private static ResumeFilterHelper instance = new ResumeFilterHelper();

        private Instance() {
        }
    }
}

