/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.rpc.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tsc.tspr.business.domain.rpc.IHsbsRpcService;
import kd.tsc.tspr.business.domain.util.SalaryPermissionUtils;
import kd.tsc.tspr.common.constants.rpc.HsbsConstants;
import kd.tsc.tspr.common.dto.request.hsbs.CandidateSalaryReqDTO;
import kd.tsc.tspr.common.dto.request.hsbs.QuerySalaryAmountReqDTO;
import kd.tsc.tspr.common.dto.request.hsbs.QuerySalaryInfoReqDTO;
import kd.tsc.tspr.common.dto.response.CommonRespDTO;
import kd.tsc.tspr.common.dto.response.hsbs.QuerySalaryAmountRespVal;
import kd.tsc.tspr.common.dto.response.hsbs.QuerySalaryInfoRespVal;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsbsRpcServiceImpl
implements IHsbsRpcService {
    private static final Logger log = LoggerFactory.getLogger(HsbsRpcServiceImpl.class);
    private static final String TSO_SOMK_OFFERBASE = "tso_somk_offerbase";

    @Override
    public CommonRespDTO<Integer> querySalaryCount() {
        QFilter qFilter = this.getSalaryStdItemFilter();
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)"hsbs", (String)"IHSBSCandidateSalaryService", (String)"querySalaryItemsAmountsByOffer", (Object[])new Object[]{qFilter});
        log.info("HsbsRpcServiceImpl.querySalaryCount.response -> {}", resultMap.get("success"));
        CommonRespDTO respDto = new CommonRespDTO();
        Boolean isSuccess = (Boolean)resultMap.get("success");
        if (isSuccess.booleanValue()) {
            respDto.setSuccess(Boolean.TRUE);
            respDto.setResult((Object)((Integer)resultMap.get("data")));
            return respDto;
        }
        return respDto.returnFail(String.valueOf(resultMap.get("message")));
    }

    @Override
    public CommonRespDTO<List<QuerySalaryInfoRespVal>> querySalaryInfo(QuerySalaryInfoReqDTO dto) {
        QFilter qFilter = this.getSalaryStdItemFilter();
        log.info("HsbsRpcServiceImpl.querySalaryInfo.request -> {}", (Object)JSONObject.toJSONString((Object)dto));
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)"hsbs", (String)"IHSBSCandidateSalaryService", (String)"querySalaryItemsByOffer", (Object[])new Object[]{qFilter, dto.getPageStart(), dto.getPageLenth()});
        log.info("HsbsRpcServiceImpl.querySalaryInfo.response");
        CommonRespDTO respDto = new CommonRespDTO();
        Boolean isSuccess = (Boolean)resultMap.get("success");
        if (isSuccess.booleanValue()) {
            return respDto.returnSuccess(this.valHandle(resultMap));
        }
        return respDto.returnFail(String.valueOf(resultMap.get("message")));
    }

    @Override
    public CommonRespDTO<List<QuerySalaryAmountRespVal>> querySalaryAmount(QuerySalaryAmountReqDTO dto) {
        CommonRespDTO respDto = new CommonRespDTO();
        log.info("HsbsRpcServiceImpl.querySalaryAmount.request -> {}", (Object)JSONObject.toJSONString((Object)dto));
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)"hcdm", (String)"ICandidateSalaryService", (String)"queryCandidateSalaryByOfferId", (Object[])new Object[]{dto.getOfferId(), dto.getSalaryIdList()});
        if (MapUtils.isEmpty((Map)resultMap)) {
            return respDto.returnFail("");
        }
        log.info("HsbsRpcServiceImpl.querySalaryAmount.isSuccess -> {}", resultMap.get("success"));
        Boolean isSuccess = (Boolean)resultMap.get("success");
        if (!isSuccess.booleanValue()) {
            return respDto.returnFail(String.valueOf(resultMap.get("message")));
        }
        List resultList = (List)resultMap.get("data");
        Pair<Boolean, String> pair = SalaryPermissionUtils.isHasPermission(TSO_SOMK_OFFERBASE);
        ArrayList valList = new ArrayList(10);
        resultList.forEach(result -> {
            QuerySalaryAmountRespVal val = this.valHandle((Map<String, Object>)result, pair);
            valList.add(val);
        });
        return respDto.returnSuccess(valList);
    }

    @Override
    public CommonRespDTO<List<QuerySalaryAmountRespVal>> querySalaryAmountByNoCheckPermission(QuerySalaryAmountReqDTO dto) {
        CommonRespDTO respDto = new CommonRespDTO();
        log.info("HsbsRpcServiceImpl.querySalaryAmount.request -> {}", (Object)JSONObject.toJSONString((Object)dto));
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)"hcdm", (String)"ICandidateSalaryService", (String)"queryCandidateSalaryByOfferId", (Object[])new Object[]{dto.getOfferId(), dto.getSalaryIdList()});
        if (MapUtils.isEmpty((Map)resultMap)) {
            return respDto.returnFail("");
        }
        log.info("HsbsRpcServiceImpl.querySalaryAmount.isSuccess -> {}", resultMap.get("success"));
        Boolean isSuccess = (Boolean)resultMap.get("success");
        if (!isSuccess.booleanValue()) {
            return respDto.returnFail(String.valueOf(resultMap.get("message")));
        }
        List resultList = (List)resultMap.get("data");
        ArrayList valList = new ArrayList(10);
        resultList.forEach(result -> {
            QuerySalaryAmountRespVal val = this.valHandleWithoutPermission((Map<String, Object>)result);
            valList.add(val);
        });
        return respDto.returnSuccess(valList);
    }

    @Override
    public CommonRespDTO<Object> candidateSalary(List<CandidateSalaryReqDTO> dtoList) {
        CommonRespDTO respDto = new CommonRespDTO();
        List<Map<String, Object>> paramList = this.paramHandle(dtoList);
        log.info("HsbsRpcServiceImpl.candidateSalary.request");
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)"hsbs", (String)"ICandidateSalaryService", (String)"addCandidateSalary", (Object[])new Object[]{paramList});
        log.info("HsbsRpcServiceImpl.candidateSalary.response");
        Boolean isSuccess = (Boolean)resultMap.get("success");
        if (isSuccess.booleanValue()) {
            return respDto.returnSuccess(null);
        }
        return respDto.returnFail(String.valueOf(resultMap.get("message")));
    }

    @Override
    public Map<String, Object> saveCandidateSalary(Map<String, Object> data) {
        log.info("HsbsRpcServiceImpl.saveCandidateSalary.request\uff1a{}", data);
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)"hcdm", (String)"ICandidateSalaryService", (String)"saveCandidateSalary", (Object[])new Object[]{data});
        log.info("HsbsRpcServiceImpl.saveCandidateSalary.response\uff1a{}", (Object)resultMap);
        if (resultMap.containsKey("operation_result")) {
            HashMap<String, Object> billNoMap = new HashMap<String, Object>(1);
            billNoMap.put("number", null);
            OperationResult opResult = (OperationResult)resultMap.get("operation_result");
            opResult.setBillNos(billNoMap);
        }
        return resultMap;
    }

    @Override
    public CommonRespDTO<Object> checkPermissionOfCandidateSalaryByOfferId(Long offerId) {
        log.info("HsbsRpcServiceImpl.checkPermissionOfCandidateSalaryByOfferId.request\uff1a{}", (Object)offerId);
        CommonRespDTO respDto = new CommonRespDTO();
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)"hcdm", (String)"ICandidateSalaryService", (String)"checkPermissionOfCandidateSalaryByOfferId", (Object[])new Object[]{offerId});
        log.info("HsbsRpcServiceImpl.checkPermissionOfCandidateSalaryByOfferId.response\uff1a{}", (Object)resultMap);
        Boolean isSuccess = (Boolean)resultMap.get("success");
        if (isSuccess.booleanValue()) {
            return respDto.returnSuccess(null);
        }
        return respDto.returnFail(String.valueOf(resultMap.get("message")));
    }

    private QFilter getSalaryStdItemFilter() {
        return new QFilter("bizType", "like", (Object)"%3%").and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
    }

    private List<Map<String, Object>> paramHandle(List<CandidateSalaryReqDTO> dtoList) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        dtoList.forEach(dto -> {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("recruitmentType", dto.getRecruitmentType());
            paramMap.put("offerCode", dto.getOfferNumber());
            paramMap.put("recruitId", dto.getAppFileId());
            paramMap.put("entryEntity", HsbsRpcServiceImpl.salaryMapListHandle(dto));
            paramMap.put("entryEntityOffer", HsbsRpcServiceImpl.offerMapListHandle(dto));
            paramList.add(paramMap);
        });
        return paramList;
    }

    private static List<Map<String, Object>> offerMapListHandle(CandidateSalaryReqDTO dto) {
        ArrayList<Map<String, Object>> offerMapList = new ArrayList<Map<String, Object>>();
        dto.getOfferValList().forEach(offerVal -> {
            HashMap<String, Number> entryOfferMap = new HashMap<String, Number>();
            entryOfferMap.put("salaryStdItemOfferId", offerVal.getSalaryStdItemOfferId());
            entryOfferMap.put("confirmedAmountOffer", offerVal.getConfirmedAmountOffer());
            offerMapList.add(entryOfferMap);
        });
        return offerMapList;
    }

    private static List<Map<String, Object>> salaryMapListHandle(CandidateSalaryReqDTO dto) {
        ArrayList<Map<String, Object>> salaryMapList = new ArrayList<Map<String, Object>>();
        dto.getSalaryValList().forEach(salaryVal -> {
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            entryMap.put("salarystditemId", salaryVal.getSalaryStdItemId());
            entryMap.put("currencyentId", salaryVal.getCurrencyentId());
            entryMap.put("frequencyId", salaryVal.getFrequencyId());
            entryMap.put("isSend", salaryVal.getIsSend());
            entryMap.put("remark", salaryVal.getRemark());
            entryMap.put("confirmedamount", salaryVal.getAmount());
            salaryMapList.add(entryMap);
        });
        return salaryMapList;
    }

    private QuerySalaryAmountRespVal valHandle(Map<String, Object> result, Pair<Boolean, String> pair) {
        String returnAmountStr;
        QuerySalaryAmountRespVal val = new QuerySalaryAmountRespVal();
        if (((Boolean)pair.getLeft()).booleanValue()) {
            String amountStr = (String)result.get("currency");
            returnAmountStr = EncrypterFactory.getAesEncrypter().decrypt(amountStr, "@Salary&Offer123", HsbsConstants.ENCRYPT_128.intValue());
        } else {
            returnAmountStr = "***";
        }
        val.setSalaryStdItemId((Long)result.get("salarystditemoffid"));
        val.setCurrency(returnAmountStr);
        return val;
    }

    private QuerySalaryAmountRespVal valHandleWithoutPermission(Map<String, Object> result) {
        QuerySalaryAmountRespVal val = new QuerySalaryAmountRespVal();
        String amountStr = (String)result.get("currency");
        String returnAmountStr = EncrypterFactory.getAesEncrypter().decrypt(amountStr, "@Salary&Offer123", HsbsConstants.ENCRYPT_128.intValue());
        val.setSalaryStdItemId((Long)result.get("salarystditemoffid"));
        val.setCurrency(returnAmountStr);
        return val;
    }

    private List<QuerySalaryInfoRespVal> valHandle(Map<String, Object> resultMap) {
        List stdItemList = (List)resultMap.get("data");
        ArrayList<QuerySalaryInfoRespVal> valList = new ArrayList<QuerySalaryInfoRespVal>();
        stdItemList.forEach(stdItem -> {
            QuerySalaryInfoRespVal val = new QuerySalaryInfoRespVal();
            val.setSalaryStdItemId((Long)stdItem.get("id"));
            val.setSalaryStdItemNumber(String.valueOf(stdItem.get("number")));
            val.setSalaryStdItemName(String.valueOf(stdItem.get("name")));
            val.setCountry((Long)stdItem.get("country"));
            val.setDescription(String.valueOf(stdItem.get("description")));
            val.setCreateOrg((Long)stdItem.get("createorg"));
            val.setFixedItem(String.valueOf(stdItem.get("fixeditem")));
            valList.add(val);
        });
        return valList;
    }
}

