/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.tsrsc;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.tsc.tspr.appfile.IAppfileDynamicExtService;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;

public class AppFileAndCandidateHelper {
    private static final Log log = LogFactory.getLog(AppFileAndCandidateHelper.class);

    public static void appFileHandle(Map<String, Object> map, Boolean isHomFlag) {
        log.info("AppFileAndCandidateHelper.updateAppFile.start.map");
        Long appFileId = AppFileAndCandidateHelper.selectAppFileIdByCandidateId((Long)map.get("candidateId"));
        DynamicObject appFile = BaseHelper.selectById((Long)appFileId, (String)"tspr_appfile");
        appFile.set("laborreltime", map.get("laborreltime"));
        appFile.set("laborrelstatus", map.get("laborrelstatus"));
        if (isHomFlag.booleanValue()) {
            appFile.set("filestatus", (Object)AppFileStatusEnum.EMPED.getValue());
            appFile.set("emptime", map.get("laborreltime"));
        }
        BaseHelper.update((DynamicObject)appFile, (String)"tspr_appfile");
        map.put("application", appFile.getLong("id"));
        map.put("stdrsm", appFile.getLong("stdrsm.id"));
        log.info("AppFileAndCandidateHelper.updateAppFile.end.map");
    }

    public static void extAppFileHandle(Map<String, Object> updateMap, Map<String, Object> htmQuitBillMap) {
        log.info("AppFileAndCandidateHelper.extAppFileHandle.start.map");
        Long appFileId = AppFileAndCandidateHelper.selectAppFileIdByCandidateId((Long)updateMap.get("candidateId"));
        DynamicObject appFile = BaseHelper.selectById((Long)appFileId, (String)"tspr_appfile");
        if (appFile == null) {
            log.info("AppFileAndCandidateHelper.extAppFileHandle appFile is null");
            return;
        }
        appFile.set("laborreltime", updateMap.get("laborreltime"));
        appFile.set("laborrelstatus", updateMap.get("laborrelstatus"));
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IAppfileDynamicExtService.class, (String)"kd.sdk.tsc.tspr.appfile.IAppfileDynamicExtService#depReasonExt", null);
        proxy.callReplace(service -> {
            if (service != null) {
                service.depReasonExt(appFile, htmQuitBillMap);
            }
            return appFile;
        });
        log.info("AppFileAndCandidateHelper.extAppFileHandle properties -> {}", (Object)appFile.getDataEntityType().getProperties());
        BaseHelper.update((DynamicObject)appFile, (String)"tspr_appfile");
        updateMap.put("application", appFile.getLong("id"));
        updateMap.put("stdrsm", appFile.getLong("stdrsm.id"));
        log.info("AppFileAndCandidateHelper.extAppFileHandle.end.map");
    }

    private static Long selectAppFileIdByCandidateId(Long candidateId) {
        DynamicObject candidate = BaseHelper.selectById((Long)candidateId, (String)"hcf_candidate");
        return candidate.getLong("appfileid");
    }
}

