/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.tsrsc.impl;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tspr.business.domain.mq.producer.ProducerExecution;
import kd.tsc.tspr.business.domain.tsrsc.AppFileAndCandidateHelper;
import kd.tsc.tspr.business.domain.tsrsc.IBizHandleService;
import kd.tsc.tspr.common.dto.response.OnbrdRespVal;
import kd.tsc.tspr.common.dto.response.ResponseDTO;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HdmHandleServiceImpl
implements IBizHandleService {
    @Override
    public void handle(DynamicObject dynamicObject) {
        Long recordId = this.getRecordIdHandle(dynamicObject);
        log.info("HdmHandleServiceImpl.handle.recordId -> {}", (Object)recordId);
        Pair employeePair = hrService.getEmployeePair(recordId);
        if (Objects.isNull(employeePair)) {
            return;
        }
        log.info("HdmHandleServiceImpl.handle.employeePair billId -> {}, employeeId -> {}", employeePair.getLeft(), employeePair.getRight());
        Map employeeMap = hrmpService.getEmployeeMap((Long)employeePair.getRight());
        if (MapUtils.isEmpty((Map)employeeMap)) {
            return;
        }
        log.info("HdmHandleServiceImpl.handle.candidateId -> {}, laborRelStatusId -> {}", employeeMap.get("candidate_id"), employeeMap.get("laborrelstatus_id"));
        Map trialMap = hrmpService.getTrialMap((Long)employeePair.getRight());
        if (MapUtils.isEmpty((Map)trialMap) || !"1040".equals(trialMap.get("regstatus"))) {
            return;
        }
        log.info("HdmHandleServiceImpl.handle.regStatus -> {}", trialMap.get("regstatus"));
        Map<String, Object> map = this.employeeMapHandle(employeeMap);
        this.hdmMapHandle(trialMap, map);
        AppFileAndCandidateHelper.appFileHandle(map, Boolean.FALSE);
        this.tscMqHandle(map);
    }

    private void tscMqHandle(Map<String, Object> map) {
        log.info("HdmHandleServiceImpl.tscMqHandle.map");
        ResponseDTO dto = new ResponseDTO();
        OnbrdRespVal val = new OnbrdRespVal();
        val.setAppFileId((Long)map.get("application"));
        val.setEnrollDate((Date)map.get("laborreltime"));
        dto.setOnboardType("D");
        dto.setResult((Object)val);
        dto.setSuccess(Boolean.TRUE);
        ProducerExecution.handleExecution("offer", dto);
        ProducerExecution.handleExecution("tstpm", map);
    }

    private void hdmMapHandle(Map<String, Object> trialMap, Map<String, Object> map) {
        map.put("laborreltime", trialMap.get("realregulardate"));
    }
}

