/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.tsrsc.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.tsc.tspr.business.domain.mq.producer.ProducerExecution;
import kd.tsc.tspr.business.domain.tsrsc.AppFileAndCandidateHelper;
import kd.tsc.tspr.business.domain.tsrsc.IBizHandleService;
import kd.tsc.tspr.common.constants.rpc.HrmpConstants;
import kd.tsc.tspr.common.dto.response.OnbrdRespVal;
import kd.tsc.tspr.common.dto.response.ResponseDTO;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HomHandleServiceImpl
implements IBizHandleService {
    private static final Map<String, Pair<String, String>> probationUnitMap = new HashMap<String, Pair<String, String>>();
    private static final Set<Long> labRelStatusClsIdList = new HashSet<Long>();

    public HomHandleServiceImpl() {
        labRelStatusClsIdList.add(HrmpConstants.IN_TRIAL_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.FORMAL_NUMBER);
    }

    @Override
    public void handle(DynamicObject dynamicObject) {
        Long recordId = this.getRecordIdHandle(dynamicObject);
        log.info("HomHandleServiceImpl.handle.recordId -> {}", (Object)recordId);
        Pair employeePair = hrService.getEmployeePair(recordId);
        if (Objects.isNull(employeePair)) {
            return;
        }
        log.info("HomHandleServiceImpl.handle.employeePair billId -> {}, employeeId -> {}", employeePair.getLeft(), employeePair.getRight());
        Map employeeMap = hrmpService.getEmployeeMap((Long)employeePair.getRight());
        if (MapUtils.isEmpty((Map)employeeMap)) {
            return;
        }
        log.info("HomHandleServiceImpl.handle.candidateId -> {}, laborRelStatusId -> {}, startDate -> {}", new Object[]{employeeMap.get("candidate_id"), employeeMap.get("laborrelstatus_id"), employeeMap.get("startdate")});
        DynamicObject laborRelStatus = hrmpService.getEmployeeLaborRelStatus((Long)employeePair.getRight());
        if (Objects.isNull(laborRelStatus)) {
            return;
        }
        Long labRelStatusClsId = laborRelStatus.getLong("labrelstatuscls.id");
        log.info("HomHandleServiceImpl.handle.labRelStatusClsId -> {}", (Object)labRelStatusClsId);
        if (!labRelStatusClsIdList.contains(labRelStatusClsId)) {
            return;
        }
        Map<String, Object> map = this.employeeMapHandle(employeeMap);
        Map trialMap = hrmpService.getTrialMap((Long)employeePair.getRight());
        if (MapUtils.isNotEmpty((Map)trialMap)) {
            log.info("HomHandleServiceImpl.handle.probation -> {} probationUnit -> {},", trialMap.get("probation"), trialMap.get("probationunit"));
            this.homMapHandle(trialMap, map);
        }
        AppFileAndCandidateHelper.appFileHandle(map, Boolean.TRUE);
        this.tscMqHandle(map, labRelStatusClsId);
    }

    private void tscMqHandle(Map<String, Object> map, Long labRelStatusClsId) {
        log.info("HomHandleServiceImpl.tscMqHandle.map");
        ResponseDTO dto = new ResponseDTO();
        OnbrdRespVal val = new OnbrdRespVal();
        Optional.ofNullable(map.get("application")).ifPresent(application -> val.setAppFileId((Long)application));
        Optional.ofNullable(map.get("probation")).ifPresent(probation -> val.setProbationTime((Integer)probation));
        Optional.ofNullable(map.get("laborreltime")).ifPresent(entryDate -> val.setEnrollDate((Date)entryDate));
        String probationUnit = (String)map.get("probationunit");
        log.info("HomHandleServiceImpl.tscMqHandle.probationUnit -> {}", (Object)probationUnit);
        Optional.ofNullable(probationUnitMap.get(probationUnit)).ifPresent(pair -> {
            val.setProbationTimeUnit((String)pair.getLeft());
            val.setProbationTimeUnitName((String)pair.getRight());
        });
        log.info("HomHandleServiceImpl.tscMqHandle.val");
        dto.setOnboardType(HrmpConstants.IN_TRIAL_NUMBER.equals(labRelStatusClsId) ? "B" : "F");
        dto.setResult((Object)val);
        dto.setSuccess(Boolean.TRUE);
        ProducerExecution.handleExecution("offer", dto);
        ProducerExecution.handleExecution("tstpm", map);
    }

    private void homMapHandle(Map<String, Object> trialMap, Map<String, Object> map) {
        map.put("probation", trialMap.get("probation"));
        map.put("probationunit", trialMap.get("probationunit"));
    }

    static {
        probationUnitMap.put("1", (Pair<String, String>)Pair.of((Object)"M", (Object)ResManager.loadKDString((String)"\u4e2a\u6708", (String)"HOMRespBillService_0", (String)"tsc-tspr-common", (Object[])new Object[0])));
        probationUnitMap.put("2", (Pair<String, String>)Pair.of((Object)"W", (Object)ResManager.loadKDString((String)"\u5468", (String)"HOMRespBillService_1", (String)"tsc-tspr-common", (Object[])new Object[0])));
        probationUnitMap.put("3", (Pair<String, String>)Pair.of((Object)"D", (Object)ResManager.loadKDString((String)"\u5929", (String)"HOMRespBillService_2", (String)"tsc-tspr-common", (Object[])new Object[0])));
        probationUnitMap.put("4", (Pair<String, String>)Pair.of((Object)"-", (Object)"-"));
    }
}

