/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.tsrsc.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.mq.producer.ProducerExecution;
import kd.tsc.tspr.business.domain.tsrsc.AppFileAndCandidateHelper;
import kd.tsc.tspr.business.domain.tsrsc.IBizHandleService;
import kd.tsc.tspr.common.constants.rpc.HrmpConstants;
import kd.tsc.tspr.common.dto.response.OnbrdRespVal;
import kd.tsc.tspr.common.dto.response.ResponseDTO;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HtmHandleServiceImpl
implements IBizHandleService {
    private static final Log log = LogFactory.getLog(HtmHandleServiceImpl.class);
    private static final Set<Long> labRelStatusClsIdList = new HashSet<Long>();

    public HtmHandleServiceImpl() {
        labRelStatusClsIdList.add(HrmpConstants.HAVE_LEFT_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.RETIRE_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_LEFT_DIE_NUMBER);
    }

    @Override
    public void handle(DynamicObject dynamicObject) {
        Long recordId = this.getRecordIdHandle(dynamicObject);
        log.info("HtmHandleServiceImpl.handle.recordId -> {}", (Object)recordId);
        Pair employeePair = hrService.getEmployeePair(recordId);
        if (Objects.isNull(employeePair)) {
            return;
        }
        log.info("HtmHandleServiceImpl.handle.employeePair billId -> {}, employeeId -> {}", employeePair.getLeft(), employeePair.getRight());
        Map employeeMap = hrmpService.getEmployeeMap((Long)employeePair.getRight());
        if (MapUtils.isEmpty((Map)employeeMap)) {
            return;
        }
        log.info("HtmHandleServiceImpl.handle.candidateId -> {}, laborRelStatusId -> {}", employeeMap.get("candidate_id"), employeeMap.get("laborrelstatus_id"));
        DynamicObject laborRelStatus = hrmpService.getEmployeeLaborRelStatus((Long)employeePair.getRight());
        if (Objects.isNull(laborRelStatus)) {
            return;
        }
        Long labRelStatusClsId = laborRelStatus.getLong("labrelstatuscls.id");
        log.info("HtmHandleServiceImpl.handle.labRelStatusClsId -> {}", (Object)labRelStatusClsId);
        if (!labRelStatusClsIdList.contains(labRelStatusClsId)) {
            return;
        }
        Map htmQuitBillMap = hrService.getHtmQuitBill((Long)employeePair.getLeft());
        if (MapUtils.isEmpty((Map)htmQuitBillMap)) {
            return;
        }
        log.info("HtmHandleServiceImpl.handle.endDate -> {}", htmQuitBillMap.get("contractenddate"));
        Map<String, Object> map = this.employeeMapHandle(employeeMap);
        this.htmMapHandle(employeeMap, map);
        AppFileAndCandidateHelper.extAppFileHandle(map, htmQuitBillMap);
        Object depReasonId = htmQuitBillMap.get("quitreason");
        log.info("HtmHandleServiceImpl.handle depReasonId : {}", depReasonId);
        this.tscMqHandle(map, depReasonId);
    }

    private void tscMqHandle(Map<String, Object> map, Object depReasonId) {
        ResponseDTO dto = new ResponseDTO();
        OnbrdRespVal val = new OnbrdRespVal();
        val.setAppFileId((Long)map.get("application"));
        val.setEnrollDate((Date)map.get("laborreltime"));
        if (depReasonId != null) {
            val.setDepReasonId(Long.valueOf(Long.parseLong(depReasonId.toString())));
        }
        dto.setOnboardType("E");
        dto.setResult((Object)val);
        dto.setSuccess(Boolean.TRUE);
        ProducerExecution.handleExecution("offer", dto);
        ProducerExecution.handleExecution("tstpm", map);
    }

    private void htmMapHandle(Map<String, Object> employeeMap, Map<String, Object> map) {
        map.put("laborreltime", employeeMap.get("enddate"));
    }
}

