/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.rpc.impl.BosRpcServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ValidateUtils {
    private static final Log log = LogFactory.getLog(ValidateUtils.class);
    private static final String CARD_TYPE_NUMBER = "1010_S";

    public static Pair<Boolean, String> validatePhone(String phone) {
        if (HRStringUtils.isEmpty((String)phone)) {
            return null;
        }
        String validateErrorMsg = ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\u3002", (String)"ValidateUtils_0", (String)"tsc-tspr-business", (Object[])new Object[0]);
        try {
            TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)phone);
            if (telephoneParseResult == null || !telephoneParseResult.isSuccess()) {
                log.info("Fail I18nServiceHelper.parseTelephone");
                return Pair.of((Object)Boolean.FALSE, (Object)validateErrorMsg);
            }
            Map validateResult = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])telephoneParseResult.getCountryList().toArray(new String[0]));
            if (validateResult != null) {
                log.info("validateResult:" + JSONObject.toJSONString((Object)validateResult));
            }
            if (validateResult == null || !Boolean.parseBoolean(validateResult.getOrDefault("code", Boolean.TRUE.toString()))) {
                log.info("Fail I18nServiceHelper.verifyTelephoneNumberFormat");
                return Pair.of((Object)Boolean.FALSE, (Object)validateErrorMsg);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            return Pair.of((Object)Boolean.FALSE, (Object)validateErrorMsg);
        }
        if (phone.length() > 30) {
            validateErrorMsg = ResManager.loadKDString((String)"\u624b\u673a\u53f7\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e30\u3002", (String)"ValidateUtils_1", (String)"tsc-tspr-business", (Object[])new Object[0]);
            return Pair.of((Object)Boolean.FALSE, (Object)validateErrorMsg);
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public static Pair<Boolean, String> validateVerifyCert(String bizAppID, String bizObjId, Integer number) {
        Map verifyResult = HRCertCommonHelper.verifyCertCount((String)bizAppID, (String)bizObjId, (int)number);
        String verifyCertInfoType = (String)verifyResult.get("infoType");
        if (HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType)) {
            String errorMsg = ResManager.loadKDString((String)"\u8bb8\u53ef\u6570\u91cf\u5df2\u8d85\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"ValidateUtils_2", (String)"tsc-tspr-business", (Object[])new Object[0]);
            return Pair.of((Object)Boolean.FALSE, (Object)errorMsg);
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public static Boolean validateCardNo(String cardType, String cardNo) {
        if (StringUtils.isEmpty((CharSequence)cardNo)) {
            return Boolean.FALSE;
        }
        if (CARD_TYPE_NUMBER.equals(cardType)) {
            BosRpcServiceImpl bosService = new BosRpcServiceImpl();
            return bosService.validateCardNo(cardNo);
        }
        String patternStr = "[^a-zA-Z0-9]";
        if (StringUtils.isEmpty((CharSequence)cardNo) || cardNo.split(patternStr).length > 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

