/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;

public final class CommonUtils {
    private static final Log logger = LogFactory.getLog(CommonUtils.class);

    private CommonUtils() {
    }

    public static String subStrBySize(String str, int size) {
        boolean equals;
        if (HRStringUtils.isEmpty((String)str)) {
            return "";
        }
        int length = str.length();
        String ellipsis = "...";
        String substring = str.substring(0, Math.min(length, size));
        String result = length > size ? ((equals = ",".equals(String.valueOf(str.charAt(size)))) ? substring + ellipsis : str.substring(0, substring.lastIndexOf(",")) + ellipsis) : str.substring(0, length - 1);
        return result;
    }

    public static <T> List<T> copyList(List<T> srcList) {
        if (CollectionUtils.isEmpty(srcList)) {
            return Lists.newArrayListWithExpectedSize((int)1);
        }
        ArrayList copyList = Lists.newArrayListWithExpectedSize((int)srcList.size());
        CollectionUtils.addAll((Collection)copyList, (Object[])new Object[srcList.size()]);
        Collections.copy(copyList, srcList);
        return copyList;
    }

    public static Date getBeginDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static boolean equalLessDate(Date start, Date end) {
        int res = DateUtils.truncatedCompareTo((Date)start, (Date)end, (int)5);
        if (res == 0) {
            return true;
        }
        return res <= 0;
    }

    public static boolean dateAfter(Date start, Date end) {
        int res = DateUtils.truncatedCompareTo((Date)start, (Date)end, (int)5);
        return res > 0;
    }
}

