/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.common.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class IntvDateUtil {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_DATE_PATTERN_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String TIME_PATTERN_1 = "HH:mm";
    public static final Integer MAX_SECOND_OF_DAY = 86399;
    public static final Integer TIME_NUM = 60000;
    public static final String INTVDATE = "intvdate";
    public static final String INTVSTARTTIME = "intvstarttime";
    public static final String INTVENDTIME = "intvendtime";

    public static LocalDateTime getLocalDateTime(Date interviewDate, Long interviewTime) {
        LocalDate localDate = interviewDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().toLocalDate();
        if (interviewTime > (long)MAX_SECOND_OF_DAY.intValue()) {
            long num = interviewTime / (long)(MAX_SECOND_OF_DAY + 1);
            long interviewTimeWithToday = interviewTime % (long)(MAX_SECOND_OF_DAY + 1);
            LocalTime localTime = LocalTime.ofSecondOfDay(interviewTimeWithToday);
            return LocalDateTime.of(localDate.plusDays(num), localTime);
        }
        LocalTime localTime = LocalTime.ofSecondOfDay(interviewTime);
        return LocalDateTime.of(localDate, localTime);
    }

    public static long getLongFromLocalDateTime(LocalDateTime intvDateTimeStart) {
        return intvDateTimeStart.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static long getLocalDateTimeOfLong(Date interviewDate, Long interviewTime) {
        return IntvDateUtil.getLongFromLocalDateTime(IntvDateUtil.getLocalDateTime(interviewDate, interviewTime));
    }

    public static Date getIntvDateTime(Date interviewDate, Long interviewTime) {
        LocalDateTime localDateTime = IntvDateUtil.getLocalDateTime(interviewDate, interviewTime);
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Boolean intvTimeIsBeforeNow(Date interviewDate, Long interviewTime) {
        return IntvDateUtil.getLocalDateTime(interviewDate, interviewTime).isBefore(LocalDateTime.now());
    }

    public static String getIntvDate(Date interviewDate) {
        return IntvDateUtil.getIntvDate(interviewDate, DEFAULT_DATE_PATTERN);
    }

    public static String getIntvDate(Date interviewDate, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(interviewDate);
    }

    public static LocalTime parseSecondTime(Long time) {
        return LocalTime.ofSecondOfDay(time);
    }

    public static String formatTime(Long time, String pattern) {
        return IntvDateUtil.parseSecondTime(time).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static Date parseDateStr(String strDate, String pattern) {
        LocalDateTime localDateTime = LocalDateTime.parse(strDate, DateTimeFormatter.ofPattern(pattern));
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date getStartDate(Date fromDate) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(fromDate.toInstant(), ZoneId.systemDefault());
        LocalDate localDate = LocalDate.from(localDateTime);
        Instant instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static String getDate2Str(String format, Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String stampToTime(String stamp, String format) {
        String sd = "";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sd = sdf.format(new Date(Long.parseLong(stamp)));
        return sd;
    }
}

