/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.common.util;

import java.util.Map;
import kd.bos.context.RequestContext;
import org.apache.commons.collections.MapUtils;

public class IntvMailUtils {
    private IntvMailUtils() {
    }

    public static String getContextUrl() {
        String contextUrl = System.getProperty("domain.contextUrl");
        if (null == contextUrl) {
            return "email";
        }
        return contextUrl.endsWith("/") ? contextUrl.substring(0, contextUrl.length() - 1) : contextUrl;
    }

    public static String getListUrl(String formId, Map<String, String> params) {
        return IntvMailUtils.getListUrl(formId, "bos_list", params);
    }

    public static String getListUrl(String formId, String listType, Map<String, String> params) {
        StringBuilder urlParam = new StringBuilder();
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((key, val) -> urlParam.append('&').append((String)key).append('=').append((String)val));
        }
        return String.format("%s/index.html?type=list&formId=%s&billFormId=%s", IntvMailUtils.getContextUrl(), listType, formId) + urlParam;
    }

    public static String getFormDetailUrl(String formId, Map<String, String> params) {
        StringBuilder urlParam = new StringBuilder();
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((key, val) -> urlParam.append('&').append((String)key).append('=').append((String)val));
        }
        return String.format("%s/index.html?accountId=%s&formId=%s%s", IntvMailUtils.getContextUrl(), RequestContext.get().getAccountId(), formId, urlParam);
    }
}

