/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.mservice.appfile;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tspr.business.domain.appfile.ProcessInstHelper;
import kd.tsc.tspr.business.domain.appfile.form.AppFileFormHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileInvHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tspr.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileRsmHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tspr.mservice.api.appfile.AppFileServiceApi;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class AppFileServiceImpl
implements AppFileServiceApi {
    public void mergeCandidate(Long mainStdRsmId, Long subStdRsmId) {
        AppFileStdRsmHelper.mergeCandidate((Long)mainStdRsmId, (Long)subStdRsmId);
    }

    public void saveAppFile(DynamicObject appFile, DynamicObject position, AppResumeBo resumeBo) {
        AppFileRsmHelper.saveAppFileOperation((DynamicObject)appFile, (DynamicObject)position, (AppResumeBo)resumeBo);
    }

    public void updateAppFiles(List<DynamicObject> appFiles) {
        AppFileHelper.update((DynamicObject[])appFiles.toArray(new DynamicObject[appFiles.size()]));
    }

    public void filterEliminateCandidate(Long appFileId, Long rsmId, Long positionId) {
        AppFileRsmHelper.filterEliminateCandidate((Long)appFileId, (Long)rsmId, (Long)positionId);
    }

    public DynamicObject getAppFileByStdRsmIdAndPositionId(Long stdRsmId, Long positionId, Date applyTime) {
        return AppFileStdRsmHelper.getAppFileByStdRsmIdAndPositionId((Long)stdRsmId, (Long)positionId, (Date)applyTime);
    }

    public boolean hasEditRight(Long appFileId) {
        long userId = TSCRequestContext.getUserId();
        return AppFileRightHelper.hasRight((Long)appFileId, (String)"tssrm", (Long)userId, (String)"4715a0df000000ac");
    }

    public void eliminateAppFile(List<DynamicObject> appFiles, String type, Long reasonId, Map<String, String> detailedReason) {
        AppFileStatusHelper.eliminateAppFile((DynamicObject[])appFiles.toArray(new DynamicObject[appFiles.size()]), (String)type, (Long)reasonId, detailedReason);
    }

    public void addRsmUpdateOpRecord(List<Long> appFileIdList, Map<String, List<Map<String, String>>> changeListMap) {
        HashMap castMap = Maps.newHashMap(changeListMap);
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.UPDATE, appFileIdList, (Map)castMap);
    }

    public void addInviteRsmUpdateOpRecord(List<Long> appFileIdList) {
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.INTVI_UPDATE_RSM, appFileIdList, null);
    }

    public void updateStdRsmInfo(Long stdRsmId, Map<String, String> stdRsmInfoMap) {
        AppFileStdRsmHelper.updateStdRsmInfo((Long)stdRsmId, stdRsmInfoMap);
    }

    public DynamicObject[] getAppFilesByStdRsmId(Long stdRsmId) {
        return AppFileHelper.queryAppFiles((String)"id", (QFilter[])new QFilter[]{new QFilter("stdrsm", "=", (Object)stdRsmId)});
    }

    public boolean hasTobeEmployedAppFile(Long mainStdRsmId, Long subStdRsmId) {
        return AppFileHelper.hasTobeEmployedAppFile((Long)mainStdRsmId, (Long)subStdRsmId);
    }

    public void showAppFilePortraitForm(IFormView view, Long appFileId) {
        DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
        AppFileFormHelper.showAppFilePortraitForm((IFormView)view, (DynamicObject)appFile, (String)"labelshowflex", null);
    }

    public List<Map<String, Object>> getCandidateIntInfo(List<Long> candidateIdList) {
        return AppFileInvHelper.getCandidateIntInfo(candidateIdList);
    }

    public DynamicObject[] getProcessInstDysByStage(Long process, List<Long> stageIds) {
        return ProcessInstHelper.getProcessInstDysByStage((Long)process, stageIds);
    }

    public DynamicObject queryOne(Long appfileId, String properties) {
        return AppFileHelper.queryOne((long)appfileId, (String)properties);
    }

    public Map<String, Long> getAppFileByTpdataid(List<String> tpdataids) {
        return AppFileStdRsmHelper.getAppFileByTpdataid(tpdataids);
    }

    public DynamicObject[] queryAppFileByFilter(QFilter qFilter, String properties) {
        return AppFileHelper.queryAppFiles((String)properties, (QFilter[])new QFilter[]{qFilter});
    }

    public void updateRsmToCandidate(Long appfileId) {
        AppFileDataHelper.addRsmToCandidate((Long)appfileId);
    }

    public boolean queryAppfileRecrustst(Long stageId, List<Long> statIds) {
        return AppFileHelper.getAppfileOfStagAndStatIsRef((Long)stageId, statIds);
    }
}

