/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.mservice.intv.calendar;

import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tspr.business.domain.intv.service.calendar.ChannelRelationServiceHelper;
import kd.tsc.tspr.business.domain.intv.service.calendar.SetAbleInterviewTimeHelper;

public class YzjCallBackApi
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(YzjCallBackApi.class);
    public static final String METHOD_CREATE_MEETING = "3001";
    public static final String METHOD_MODIFY_MEETING = "3002";
    public static final String METHOD_DELETE_MEETING = "3003";
    public static final String METHOD_OVER_MEETING = "3006";
    public static final String METHOD_CHANNEL_MEETING = "3007";

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        try {
            if (HRObjectUtils.isEmpty(params)) {
                logger.info("Yzj->CallBack->TSCOpenApi->Param null");
                return result;
            }
            logger.info("Yzj->CallBack->TSCOpenApi->Success");
            logger.info("YZJ->CallBackApi->method:{},id:{}", params.get("method"), params.get("id"));
            String method = params.get("method").toString();
            String yzjId = params.get("id").toString();
            if (METHOD_CREATE_MEETING.equals(method)) {
                logger.info("Yzj->CallBack->TSCOpenApi->Create meeting start, meetingId: {}", (Object)yzjId);
                SetAbleInterviewTimeHelper.getInstance().queryYzjDetailAndSetCantIntv(yzjId);
                logger.info("Yzj->CallBack->TSCOpenApi->Create meeting end");
            } else if (METHOD_MODIFY_MEETING.equals(method)) {
                logger.info("Yzj->CallBack->TSCOpenApi->Modify meeting start;");
                DynamicObject historyChannel = ChannelRelationServiceHelper.queryOne((String)"id", (QFilter)new QFilter("channel", "=", (Object)yzjId));
                if (HRObjectUtils.isEmpty((Object)historyChannel)) {
                    logger.info("Yzj->CallBack->TSCOpenApi-> meeting has already exist, meetingId: {}", (Object)yzjId);
                    SetAbleInterviewTimeHelper.getInstance().deleteById(yzjId);
                    SetAbleInterviewTimeHelper.getInstance().queryYzjDetailAndSetCantIntv(yzjId);
                }
                logger.info("Yzj->CallBack->TSCOpenApi->Modify meeting end");
            } else if (METHOD_DELETE_MEETING.equals(method) || METHOD_OVER_MEETING.equals(method) || METHOD_CHANNEL_MEETING.equals(method)) {
                logger.info("Yzj->CallBack->TSCOpenApi->Delete,Over,Channel meeting start, meetingId: {}", (Object)yzjId);
                SetAbleInterviewTimeHelper.getInstance().deleteById(yzjId);
                logger.info("Yzj->CallBack->TSCOpenApi->Delete,Over,Channel meeting end");
            }
        }
        catch (Exception varError) {
            result.setMessage(varError.getMessage());
            result.setErrorCode(String.valueOf(40002));
            result.setSuccess(false);
            logger.error("YzjCallBackApi->Yzj error: {}", (Object)varError.getMessage(), (Object)varError);
        }
        return result;
    }
}

