/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.op.advert;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tspr.business.domain.advertising.service.AdvertBizService;
import kd.tsc.tspr.business.domain.advertising.service.AdvertConfigHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertDetailExDataHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertTplExCommonHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertTplExDataHelper;
import kd.tsc.tspr.common.util.CommonUtils;
import kd.tsc.tspr.opplugin.web.validator.advert.AdvertOpValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertListOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(AdvertListOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new AdvertOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        String operateKey = args.getOperationKey();
        Object[] dbDataEntities = HRStringUtils.equals((String)operateKey, (String)"startadvert") ? this.getDBDataEntitiesForEnable(dataEntities) : this.getDBDataEntities(dataEntities);
        switch (operateKey) {
            case "refreashadvert": {
                this.advertRefresh((DynamicObject[])dbDataEntities);
                break;
            }
            case "top": {
                this.advertTop((DynamicObject[])dbDataEntities, true);
                break;
            }
            case "untop": {
                this.advertTop((DynamicObject[])dbDataEntities, false);
                break;
            }
            case "urgent": {
                this.advertUrgent((DynamicObject[])dbDataEntities, true);
                break;
            }
            case "unurgent": {
                this.advertUrgent((DynamicObject[])dbDataEntities, false);
                break;
            }
            case "stopadvert": {
                this.advertEnable((DynamicObject[])dbDataEntities, false);
                break;
            }
            case "startadvert": {
                this.advertEnable((DynamicObject[])dbDataEntities, true);
                break;
            }
            case "stopadvertall": {
                this.advertDisableAll((DynamicObject[])dbDataEntities);
                break;
            }
        }
        AdvertDetailExDataHelper.getInstance().saveAdvertDetail((List)Lists.newArrayList((Object[])dbDataEntities));
    }

    private DynamicObject[] getDBDataEntitiesForEnable(DynamicObject[] dataEntities) {
        Long[] ids = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            ids[i] = dataEntities[i].getLong("id");
        }
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return AdvertDetailExDataHelper.getInstance().getAdvertListByFilter(new QFilter[]{qFilter}, null);
    }

    private void advertDisableAll(DynamicObject[] dbDataEntities) {
        Date date = new Date();
        for (DynamicObject dataEntity : dbDataEntities) {
            if (!dataEntity.getString("status").equals("S")) continue;
            dataEntity.set("status", (Object)"D");
            dataEntity.set("stoptime", (Object)date);
        }
    }

    private DynamicObject[] getDBDataEntities(DynamicObject[] dataEntities) {
        Long[] ids = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            ids[i] = dataEntities[i].getLong("id");
        }
        return AdvertDetailExDataHelper.getInstance().queryAdvertDetail(ids);
    }

    private void advertRefresh(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("refreshtime", (Object)new Date());
        }
    }

    private void advertTop(DynamicObject[] dataEntities, boolean top) {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("istop", (Object)top);
        }
    }

    private void advertUrgent(DynamicObject[] dataEntities, boolean urgent) {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("isurgent", (Object)urgent);
        }
    }

    private void advertEnable(DynamicObject[] dataEntities, boolean enable) {
        if (dataEntities == null || dataEntities.length == 0) {
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"AdvertListOp_0", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList advertBillList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        if (enable) {
            ArrayList directPubList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList waitPubList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList needApprovalList = Lists.newArrayListWithExpectedSize((int)10);
            for (DynamicObject dataEntity : dataEntities) {
                boolean isEndFuture;
                long oldAdvertId = dataEntity.getDynamicObject("channel").getLong("id");
                Boolean needAuditByChannel = AdvertConfigHelper.needAuditByChannel((Long)oldAdvertId);
                Date startDate = dataEntity.getDate("startdate");
                Date endDate = dataEntity.getDate("enddate");
                Date now = CommonUtils.getBeginDate((Date)new Date());
                boolean isFuture = null != startDate && CommonUtils.dateAfter((Date)startDate, (Date)now);
                boolean bl = isEndFuture = null != endDate && CommonUtils.dateAfter((Date)now, (Date)endDate);
                if (needAuditByChannel.booleanValue()) {
                    needApprovalList.add(dataEntity);
                } else if (isFuture || isEndFuture) {
                    waitPubList.add(dataEntity);
                } else {
                    directPubList.add(dataEntity);
                }
                AdvertTplExCommonHelper.activeOldAdvertBill((DynamicObject)dataEntity, (List)advertBillList, (Boolean)needAuditByChannel);
            }
            if (CollectionUtils.isNotEmpty((Collection)advertBillList)) {
                AdvertTplExCommonHelper.touchOffWorkFlows((List)advertBillList);
            }
            List errorInfoList = this.operationResult.getAllErrorOrValidateInfo();
            Pair result = AdvertBizService.getInstance().getPublishMsg((List)needApprovalList, (List)directPubList, (List)waitPubList, Collections.emptyList(), errorInfoList, true);
            this.operationResult.setSuccess(true);
            this.operationResult.setShowMessage(false);
            this.operationResult.setMessage(SerializationUtils.serializeToBase64((Object)result));
        } else {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("status", (Object)"D");
                dataEntity.set("stoptime", (Object)new Date());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] advertEntities = args.getDataEntities();
        DynamicObject[] dbDataEntities = this.getDBDataEntities(advertEntities);
        if ("stopadvert".equals(operationKey) || "stopadvertall".equals(operationKey) || "startadvert".equals(operationKey)) {
            AdvertTplExDataHelper.getInstance().calculatePosAdvNum(dbDataEntities);
        }
    }
}

