/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.op.appfile;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;
import kd.tsc.tspr.opplugin.web.validator.appfile.RecoverAppFileValidator;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class RecoverAppFileOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(RecoverAppFileOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("stdrsm.mid");
        evt.getFieldKeys().add("filestatus");
        evt.getFieldKeys().add("position.id");
        evt.getFieldKeys().add("eliminatetime");
        evt.getFieldKeys().add("modifytime");
        evt.getFieldKeys().add("modifier");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new RecoverAppFileValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        DynamicObject[] dataEntities;
        logger.debug("start recover appfile");
        for (DynamicObject dataEntity : dataEntities = evt.getDataEntities()) {
            dataEntity.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            dataEntity.set("eliminatetime", null);
            dataEntity.set("modifytime", (Object)new Date());
            dataEntity.set("modifier", (Object)TSCRequestContext.getUserId());
        }
        if (evt.getDataEntities().length > 0) {
            this.operationResult.setMessage(this.getRecoverSuccessMsg(evt.getDataEntities()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs evt) {
        List appFileIds = Arrays.stream(evt.getDataEntities()).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileStatusHelper.addStatusRecordByRecoverOp(appFileIds);
        AppFileFlowLockHelper.recoverAppFile((DynamicObject[])evt.getDataEntities());
    }

    private String getRecoverSuccessMsg(DynamicObject[] appFiles) {
        String name = AppFileOpHelper.getErrorMulTipHead(Arrays.asList(appFiles));
        String tpTip = ResManager.loadKDString((String)"\u6062\u590d\u539f\u72b6\u6001\u6210\u529f", (String)"RecoverAppFileOp_0", (String)"tsc-tspr-opplugin", (Object[])new Object[0]);
        return name + tpTip;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        List appFileIdList = Arrays.stream(evt.getDataEntities()).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.RECOVERY, appFileIdList, null);
    }
}

