/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.op.appfile.qacheck;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.qacheck.QACheckKDStringHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileQACheckHelper;
import kd.tsc.tspr.common.constants.appfile.qacheck.AppFileQACheckConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class QACheckSubmitOp
extends HRCoreBaseBillOp {
    private static final Log LOG = LogFactory.getLog(QACheckSubmitOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getEntityKey());
                List pkValueList = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
                LOG.info("QACheck.Submit:{}", pkValueList);
                Map<Long, DynamicObject> originDataMap = Arrays.stream(helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", pkValueList)})).collect(Collectors.toMap(dyo -> dyo.getLong("id"), dyo -> dyo));
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    DynamicObject qaCheck = originDataMap.get(dataEntity.getBillPkId());
                    if (qaCheck == null || !HRStringUtils.isNotEmpty((String)qaCheck.getString("flowtasknum")) || !AppFileQACheckConstants.AuditStatus.DESERT.getStatus().equals(qaCheck.getString("auditstatus"))) continue;
                    this.addFatalErrorMessage(dataEntity, QACheckKDStringHelper.statusDesertWarn());
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        for (DynamicObject dataEntity : args.getDataEntities()) {
            dataEntity.set("handler", (Object)TSCRequestContext.getUserId());
            dataEntity.set("handletime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] appFiles;
        ArrayList qaCheckFlowIdList = Lists.newArrayListWithCapacity((int)args.getDataEntities().length);
        HashMap appFileMap = Maps.newHashMapWithExpectedSize((int)args.getDataEntities().length);
        for (DynamicObject dataEntity : args.getDataEntities()) {
            long qaCheckId = dataEntity.getLong("id");
            if (HRStringUtils.isNotEmpty((String)dataEntity.getString("flowtasknum"))) {
                qaCheckFlowIdList.add(qaCheckId);
            }
            appFileMap.put(dataEntity.getLong("appfile.id"), dataEntity);
        }
        if (!qaCheckFlowIdList.isEmpty()) {
            AppFileQACheckHelper.completeTask((List)qaCheckFlowIdList, (String)"tspr_qacheck");
        }
        ArrayList appFileIds = Lists.newArrayList(appFileMap.keySet());
        for (DynamicObject appFile : appFiles = AppFileHelper.queryAppFiles((List)appFileIds, (String)"qacheckresult")) {
            DynamicObject qaCheck = (DynamicObject)appFileMap.get(appFile.getLong("id"));
            if (qaCheck == null) continue;
            appFile.set("qacheckresult", (Object)qaCheck.getString("result"));
        }
        AppFileHelper.update((DynamicObject[])appFiles);
    }
}

