/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.op.position;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tspr.business.domain.position.service.PositionDataHelper;
import kd.tsc.tspr.business.domain.position.service.PositionOperateService;
import kd.tsc.tspr.opplugin.web.validator.position.PositionStatusChangeValidator;

public class PositionStatusChangeOp
extends HRDataBaseOp {
    private static final Map<String, String> POSITION_OPERATION_MAP = new HashMap<String, String>(16);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("positionstatus");
        fieldKeys.add("status");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new PositionStatusChangeValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs evt) {
        DynamicObject[] dataEntities = evt.getDataEntities();
        String operationKey = evt.getOperationKey();
        if (HRStringUtils.equals((String)"posclose_donothing", (String)operationKey) || HRStringUtils.equals((String)"posclose_notips", (String)operationKey)) {
            PositionOperateService.getInstance().afterStatusPosition(dataEntities, "D");
        } else if (HRStringUtils.equals((String)"posstart_donothing", (String)operationKey)) {
            PositionOperateService.getInstance().afterStatusPosition(dataEntities, "A");
        } else {
            PositionOperateService.getInstance().afterStatusPosition(dataEntities, "C");
        }
        for (DynamicObject dataEntity : dataEntities) {
            Long positionId = dataEntity.getLong("id");
            String changeStatus = POSITION_OPERATION_MAP.get(operationKey);
            if (HRStringUtils.isEmpty((String)changeStatus)) continue;
            PositionDataHelper.updatePositionStatusByPositionId((Long)positionId, (String)changeStatus);
        }
    }

    static {
        POSITION_OPERATION_MAP.put("stop_donothing", "C");
        POSITION_OPERATION_MAP.put("posclose_notips", "D");
        POSITION_OPERATION_MAP.put("posstart_donothing", "A");
        POSITION_OPERATION_MAP.put("posclose_donothing", "D");
    }
}

