/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.validator.advert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tspr.business.domain.advertising.service.AdvertApprovalDataHelper;
import kd.tsc.tspr.common.enums.AdvertApprovalStateEnum;

public class AdvertApprovalOpValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject[] dynamicObjects = this.getDbDataEntities(dataEntities);
        Map<Long, DynamicObject> advertApprovalMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject validateDataEntity = dataEntity.getDataEntity();
            long id = validateDataEntity.getLong("id");
            DynamicObject dbObj = advertApprovalMap.get(id);
            String approvalStatus = dbObj.getString("billstatus");
            if (HRStringUtils.equals((String)"A", (String)approvalStatus)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e7f\u544a\u5ba1\u6279\u5355\u636e\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AdvertApprovalOpValidator_1", (String)"tsc-tspr-opplugin", (Object[])new Object[0]), AdvertApprovalStateEnum.getDesc((String)dbObj.getString("billstatus"))));
        }
    }

    public DynamicObject[] getDbDataEntities(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> approvalIds = new ArrayList<Long>(dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            approvalIds.add(dataEntities[i].getDataEntity().getLong("id"));
        }
        return AdvertApprovalDataHelper.getInstance().loadApprovalData(approvalIds);
    }
}

