/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.validator.advert;

import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tspr.business.domain.advertising.service.AdvertApprovalDataHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertBizService;
import kd.tsc.tspr.business.domain.advertising.service.AdvertConfigHelper;
import kd.tsc.tspr.business.domain.advertising.service.AdvertDetailExDataHelper;

public class AdvertOpValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject[] dynamicObjects = this.getDbDataEntities(dataEntities);
        Map<Long, DynamicObject> advertMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(xVal -> xVal.getLong("id"), xVal -> xVal));
        block19: for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject validateDataEntity = dataEntity.getDataEntity();
            long id = validateDataEntity.getLong("id");
            DynamicObject dbObj = advertMap.get(id);
            String advertStatus = dbObj.getString("status");
            String advertReleaseMethod = this.getAdvertPublishType(dbObj);
            boolean isTop = dbObj.getBoolean("istop");
            boolean isUrgent = dbObj.getBoolean("isurgent");
            switch (operateKey) {
                case "refreashadvert": {
                    this.refresh(dataEntity, advertReleaseMethod, advertStatus);
                    continue block19;
                }
                case "top": {
                    this.top(dataEntity, advertReleaseMethod, advertStatus, isTop);
                    continue block19;
                }
                case "untop": {
                    if (isTop) continue block19;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e7f\u544a\u672a\u7f6e\u9876\u3002", (String)"AdvertOpValidator_5", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
                    continue block19;
                }
                case "urgent": {
                    this.expedited(dataEntity, advertReleaseMethod, advertStatus, isUrgent);
                    continue block19;
                }
                case "unurgent": {
                    if (isUrgent) continue block19;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e7f\u544a\u672a\u52a0\u6025\u3002", (String)"AdvertOpValidator_9", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
                    continue block19;
                }
                case "stopadvertall": 
                case "stopadvert": {
                    this.disable(dataEntity, dbObj);
                    continue block19;
                }
                case "startadvert": {
                    this.checkCanEnable(dbObj, dataEntity);
                    continue block19;
                }
            }
        }
    }

    private void disable(ExtendedDataEntity dataEntity, DynamicObject dbObj) {
        String advertStatus = dbObj.getString("status");
        String advertReleaseMethod = this.getAdvertPublishType(dbObj);
        String approvalStatus = dbObj.getString("approvestatus");
        if (!"S".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5df2\u53d1\u5e03\u7684\u5e7f\u544a\u5141\u8bb8\u505c\u7528\u3002", (String)"AdvertOpValidator_10", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        } else if ("C".equals(advertReleaseMethod)) {
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u63d2\u4ef6\u53d1\u5e03\u5e7f\u544a\u7684\u505c\u7528\u4ec5\u505a\u5185\u90e8\u8bb0\u5f55\uff0c\u8bf7\u60a8\u524d\u5f80%s\u6e20\u9053\u624b\u52a8\u505c\u7528\u3002", (String)"AdvertOpValidator_13", (String)"tsc-tspr-opplugin", (Object[])new Object[0]), this.getAdvertChannelName(dbObj)));
        } else {
            this.checkAuditBill(dataEntity, approvalStatus, false);
        }
    }

    private void expedited(ExtendedDataEntity dataEntity, String advertReleaseMethod, String advertStatus, boolean isUrgent) {
        if ("D".equals(advertReleaseMethod)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ebf\u4e0b\u53d1\u5e03\u7684\u5e7f\u544a\u65e0\u52a0\u6025\u64cd\u4f5c\u3002", (String)"AdvertOpValidator_6", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        } else if (!"S".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5df2\u53d1\u5e03\u7684\u5e7f\u544a\u5141\u8bb8\u52a0\u6025\u3002", (String)"AdvertOpValidator_7", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        } else if (isUrgent) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u72b6\u6001\u5df2\u4e3a\u52a0\u6025\uff0c\u65e0\u9700\u518d\u6b21\u52a0\u6025\u3002", (String)"AdvertOpValidator_8", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
    }

    private void top(ExtendedDataEntity dataEntity, String advertReleaseMethod, String advertStatus, boolean isTop) {
        if ("D".equals(advertReleaseMethod)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ebf\u4e0b\u53d1\u5e03\u7684\u5e7f\u544a\u65e0\u7f6e\u9876\u64cd\u4f5c\u3002", (String)"AdvertOpValidator_2", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        } else if (!"S".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5df2\u53d1\u5e03\u7684\u5e7f\u544a\u5141\u8bb8\u7f6e\u9876\u3002", (String)"AdvertOpValidator_3", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        } else if (isTop) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u72b6\u6001\u5df2\u4e3a\u7f6e\u9876\uff0c\u65e0\u9700\u518d\u6b21\u7f6e\u9876\u3002", (String)"AdvertOpValidator_4", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
    }

    private void refresh(ExtendedDataEntity dataEntity, String advertReleaseMethod, String advertStatus) {
        if ("D".equals(advertReleaseMethod)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ebf\u4e0b\u53d1\u5e03\u7684\u5e7f\u544a\u65e0\u5237\u65b0\u64cd\u4f5c\u3002", (String)"AdvertOpValidator_0", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        } else if (!"S".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5df2\u53d1\u5e03\u7684\u5e7f\u544a\u5141\u8bb8\u5237\u65b0\u3002", (String)"AdvertOpValidator_1", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkCanEnable(DynamicObject dbObj, ExtendedDataEntity dataEntity) {
        String advertStatus = dbObj.getString("status");
        DynamicObject position = dbObj.getDynamicObject("position");
        long channelId = dbObj.getLong("channel_id");
        String posStatus = HRObjectUtils.isEmpty((Object)position) ? null : position.getString("positionstatus");
        Date endDate = dbObj.getDate("enddate");
        String checkEndDate = AdvertBizService.getInstance().checkAdvEndDate(endDate);
        if ("D".equals(posStatus)) {
            this.addErrorMessage(dataEntity, AdvertBizService.getInstance().posCloseTip());
        } else if (!"D".equals(advertStatus) && !"E".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5df2\u505c\u7528\u6216\u53d1\u5e03\u5931\u8d25\u7684\u5e7f\u544a\u5141\u8bb8\u542f\u7528\u3002", (String)"AdvertOpValidator_12", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.isNotEmpty((String)checkEndDate)) {
            this.addErrorMessage(dataEntity, checkEndDate);
        } else if (AdvertConfigHelper.needAuditByChannel((Long)channelId).booleanValue()) {
            if (!AdvertConfigHelper.isHasAdvertWorkFlow().booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279\u672a\u627e\u5230\u5bf9\u5e94\u5ba1\u6279\u6d41\uff0c\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\uff01", (String)"AdvertOpValidator_15", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
            } else {
                this.checkAuditBill(dataEntity, advertStatus, true);
            }
        }
    }

    private void checkAuditBill(ExtendedDataEntity dataEntity, String approvalStatus, boolean isEnable) {
        if (!HRStringUtils.equals((String)"Z", (String)approvalStatus)) {
            DynamicObject validateDataEntity = dataEntity.getDataEntity();
            long id = validateDataEntity.getLong("id");
            Object[] noStopAdvert = AdvertApprovalDataHelper.getInstance().getNoEndApproval(Long.valueOf(id));
            if (!HRArrayUtils.isEmpty((Object[])noStopAdvert)) {
                String tip = isEnable ? ResManager.loadKDString((String)"\u5f53\u524d\u5e7f\u544a\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u5ba1\u6279\u5355%s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u65b0\u7684\u542f\u7528\u5e7f\u544a\u7533\u8bf7\u3002", (String)"AdvertOpValidator_16", (String)"tsc-tspr-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u62db\u8058\u5e7f\u544a\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u5ba1\u6279\u5355%s\uff0c\u8bf7\u5148\u5c06\u5ba1\u6279\u5355\u64a4\u56de\u3002", (String)"AdvertOpValidator_14", (String)"tsc-tspr-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, tip, noStopAdvert[0].getString("billno")));
            }
        }
    }

    public DynamicObject[] getDbDataEntities(ExtendedDataEntity[] dataEntities) {
        Long[] ids = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            ids[i] = dataEntities[i].getDataEntity().getLong("id");
        }
        return AdvertDetailExDataHelper.getInstance().queryAdvertDetail(ids);
    }

    private String getAdvertPublishType(DynamicObject advertObj) {
        DynamicObject channel = advertObj.getDynamicObject("channel");
        String pubType = HRObjectUtils.isEmpty((Object)channel) ? null : channel.getString("advertisement");
        return pubType;
    }

    private String getAdvertChannelName(DynamicObject advertObj) {
        DynamicObject channel = advertObj.getDynamicObject("channel");
        String channelName = HRObjectUtils.isEmpty((Object)channel) ? null : channel.getString("name");
        return channelName;
    }
}

