/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.validator.appfile;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;

public class AppFileFlowLockValidator
extends HRDataBaseValidator {
    private static final Log logger = LogFactory.getLog(AppFileFlowLockValidator.class);
    private final Set<Long> lockedStdRsmIds = Sets.newHashSet();

    public void validate() {
        ArrayUtils.reverse((Object[])this.dataEntities);
        List stdRsmIdList = Arrays.stream(this.dataEntities).map(dyo -> dyo.getDataEntity().getLong("stdrsm.id")).collect(Collectors.toList());
        Map lockInfoMap = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIdList);
        logger.info("AppFileFlowLockValidator.validate.params:{},{}", stdRsmIdList, (Object)lockInfoMap);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject appFile = dataEntity.getDataEntity();
            Long stdRsmId = appFile.getLong("stdrsm.id");
            if (lockInfoMap.get(stdRsmId) == null && !this.lockedStdRsmIds.contains(stdRsmId)) continue;
            String errorTip = this.getDataEntities().length == 1 ? ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u9501\u5b9a\uff0c\u65e0\u9700\u91cd\u590d\u9501\u5b9a", (String)"AppFileFlowLockValidator_0", (String)"tsc-tspr-opplugin", (Object[])new Object[0]) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5019\u9009\u4eba%s\u5df2\u9501\u5b9a\uff0c\u65e0\u9700\u91cd\u590d\u9501\u5b9a", (String)"AppFileFlowLockValidator_1", (String)"tsc-tspr-opplugin", (Object[])new Object[0]), appFile.getString("name"));
            this.addErrorMessage(dataEntity, errorTip);
        }
    }
}

