/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.validator.appfile;

import java.util.Locale;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;

public class AppFileInProcessValidator
extends HRDataBaseValidator {
    private static final Log logger = LogFactory.getLog(AppFileInProcessValidator.class);

    public void validate() {
        ArrayUtils.reverse((Object[])this.dataEntities);
        String operationName = AppFileOpHelper.getOpName((OperateOption)this.getOption(), (AbstractValidator)this);
        String ignoreNumber = this.getOption().getVariableValue("ignorenumber", null);
        if ("true".equals(ignoreNumber)) {
            this.setAddBillNoForContent(false);
        }
        logger.debug("validate filestatus start");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject appFile = this.dataEntities.length == 1 ? AppFileHelper.queryOne((long)((Long)dataEntity.getBillPkId())) : dataEntity.getDataEntity();
            if ("changestageright".equals(this.getOperateKey()) || "changestagestatus".equals(this.getOperateKey())) {
                if (AppFileHelper.isInProcess((DynamicObject)appFile) || AppFileHelper.isInEmpStatus((DynamicObject)appFile)) continue;
                String tipFmt = AppFileResManagerHelper.getFileStatusErrorTip();
                String errorTip = String.format(tipFmt, appFile.getString("name"), AppFileHelper.getFileStatusDesc((DynamicObject)appFile), this.getOperationName());
                this.addMessage(dataEntity, "notInProcess", errorTip, ErrorLevel.Error);
                continue;
            }
            if (AppFileHelper.isInProcess((DynamicObject)appFile)) continue;
            String errorTip = String.format(Locale.ROOT, AppFileResManagerHelper.getIsInProcessOpWarn(), operationName);
            this.addMessage(dataEntity, "notInProcess", errorTip, ErrorLevel.Error);
        }
    }
}

