/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.validator.appfile;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AppFileUnFlowLockValidator
extends HRDataBaseValidator {
    private static final Log logger = LogFactory.getLog(AppFileUnFlowLockValidator.class);
    private final Set<Long> lockedStdRsmIds = Sets.newHashSet();

    public void validate() {
        ArrayUtils.reverse((Object[])this.dataEntities);
        List stdRsmIdList = Arrays.stream(this.dataEntities).map(dyo -> dyo.getDataEntity().getLong("stdrsm.id")).collect(Collectors.toList());
        Map lockInfoMap = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIdList);
        logger.info("AppFileUnFlowLockValidator.validate.params:{},{}", stdRsmIdList, (Object)lockInfoMap);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String errorTip;
            DynamicObject appFile = dataEntity.getDataEntity();
            if (this.getDataEntities().length == 1) {
                appFile = AppFileHelper.queryOne((long)((Long)dataEntity.getBillPkId()));
            }
            Long stdRsmId = appFile.getLong("stdrsm.id");
            DynamicObject lockInfo = (DynamicObject)lockInfoMap.get(stdRsmId);
            if (lockInfoMap.get(stdRsmId) == null || this.lockedStdRsmIds.contains(stdRsmId) || !AppFileHelper.isInProcessOrEmp((DynamicObject)appFile)) {
                errorTip = this.getDataEntities().length == 1 ? AppFileResManagerHelper.getUnLockOneWarn() : AppFileResManagerHelper.getUnLockWarn((String)appFile.getString("name"));
                this.addErrorMessage(dataEntity, errorTip);
                continue;
            }
            long lockerId = lockInfo.getLong("locker.id");
            if (TSCRequestContext.getUserId() != lockerId) {
                errorTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u4e0d\u662f%s\u5019\u9009\u4eba\u7684\u9501\u5b9a\u4eba\uff0c\u65e0\u6743\u9650\u89e3\u9501", (String)"AppFileUnFlowLockValidator_2", (String)"tsc-tspr-opplugin", (Object[])new Object[0]), appFile.getString("name"));
                this.addErrorMessage(dataEntity, errorTip);
                continue;
            }
            if (!AppFileHelper.isInProcess((DynamicObject)appFile)) continue;
            this.lockedStdRsmIds.add(stdRsmId);
        }
    }
}

