/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.validator.appfile;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileOfferHelper;

public class ChangeStageStatusValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(ChangeStageStatusValidator.class);
    private long stageId;

    public ChangeStageStatusValidator(long stageId) {
        this.stageId = stageId;
    }

    public void validate() {
        LOG.info("Check before transferring link status");
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        LOG.info("Judge whether the selected application files belong to the same recruitment process");
        long processId = extendedDataEntities[0].getDataEntity().getLong("recruproc.id");
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            boolean isOfferStgAndHasInfo;
            boolean isSameProc;
            DynamicObject appFileObject = extendedDataEntity.getDataEntity();
            if (extendedDataEntities.length == 1) {
                appFileObject = AppFileHelper.queryOne((long)((Long)extendedDataEntity.getBillPkId()));
            }
            boolean bl = isSameProc = processId != appFileObject.getLong("recruproc.id") && (AppFileHelper.isInProcess((DynamicObject)appFileObject) || AppFileHelper.isInEmpStatus((DynamicObject)appFileObject));
            if (isSameProc) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u76f8\u540c\u6d41\u7a0b\u4e0b\u7684\u5019\u9009\u4eba\u8fdb\u884c\u8f6c\u79fb\u73af\u8282\u72b6\u6001", (String)"ChangeStageStatusValidator_0", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
            }
            boolean bl2 = isOfferStgAndHasInfo = AppFileOfferHelper.validateInOfferStage((Long)this.stageId) && (HRStringUtils.isEmpty((String)appFileObject.getString("phone")) || HRStringUtils.isEmpty((String)appFileObject.getString("email")));
            if (!isOfferStgAndHasInfo) continue;
            String noPhoneAndEmailTipFmt = AppFileResManagerHelper.getNoPhoneAndEmailTip();
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, noPhoneAndEmailTipFmt, appFileObject.getString("name")));
        }
    }
}

