/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.validator.appfile.qacheck;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.qacheck.QACheckKDStringHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbs.common.utils.DynamicObjectUtils;

public class QACheckRightValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(QACheckRightValidator.class);

    public void validate() {
        List appFileIds = Arrays.stream(this.getDataEntities()).map(dy -> (Long)dy.getBillPkId()).collect(Collectors.toList());
        LOG.info("QACheckRightValidator.validate:{}", appFileIds);
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appFileIds, (String)"filestatus");
        Map dyMap = DynamicObjectUtils.dyoArrayToMap((DynamicObject[])appFiles, (String)"id");
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            boolean validateResult;
            DynamicObject appFile = (DynamicObject)dyMap.get(dataEntity.getBillPkId());
            String fileStatus = appFile.getString("filestatus");
            boolean bl = validateResult = !AppFileHelper.isOut((String)fileStatus) && !AppFileHelper.isInvalid((String)fileStatus) && !AppFileHelper.isEndEmployed((String)fileStatus);
            if (validateResult) continue;
            this.addErrorMessage(dataEntity, String.format(QACheckKDStringHelper.statusValidateDesc(), appFile.getString("name"), AppFileStatusEnum.getEnum((String)fileStatus).getText().loadKDString()));
        }
    }
}

