/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.opplugin.web.validator.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tspr.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tspr.common.constants.position.PositionManageConstants;

public class PositionCommitValidator
extends HRDataBaseValidator {
    private String operationValue = "false";
    private static String VALID_COMMIT_FLAG = "true";

    public PositionCommitValidator(String operationValue) {
        this.operationValue = operationValue;
    }

    public PositionCommitValidator() {
    }

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList positionIdList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        HashMap dataEntityMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long positionId = dataEntity.getDataEntity().getLong("id");
            positionIdList.add(positionId);
            dataEntityMap.put(positionId, dataEntity);
            String positionStatus = dataEntity.getDataEntity().getString("positionstatus");
            if (!"B".equals(positionStatus) && VALID_COMMIT_FLAG.equals(this.operationValue)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5fc5\u586b\u5b57\u6bb5\u5f55\u5165\u5b8c\u5584\uff0c\u4e14\u6709\u65b0\u589e\u6216\u8005\u4fee\u6539\u5b57\u6bb5\u672a\u63d0\u4ea4\u7684\uff0c\"\u8349\u7a3f\"\u3001\"\u62db\u8058\u4e2d\"\u3001\"\u5df2\u6682\u505c\"\u804c\u4f4d\uff0c\u53ef\u4ee5\u63d0\u4ea4\u5e76\u751f\u6548", (String)"PositionCommitValidator_3", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
            }
            this.salaryRangeFieldCheck(dataEntity, "salarytype", "currency", "salaryup", "salarydown", "issalarynego", "\u8bf7\u6309\u8981\u6c42\u586b\u5199\u85aa\u8d44\u8303\u56f4", "PositionCommitValidator_2");
            this.validRangeField(dataEntity, "salaryup", "salarydown", "issalarynego", "\u8bf7\u6309\u8981\u6c42\u586b\u5199\u85aa\u8d44\u8303\u56f4", "PositionCommitValidator_2");
            this.validRangeField(dataEntity, "workexpup", "workexpdown", "isworkexplimit", "\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5de5\u4f5c\u5e74\u9650\u533a\u95f4", "PositionCommitValidator_4");
            this.validRangeField(dataEntity, "ageup", "agedown", "isagelimit", "\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5e74\u9f84\u533a\u95f4", "PositionCommitValidator_5");
            this.jobRangeFieldCheck(dataEntity, "lowjoblevel", "highjoblevel", "\u8bf7\u6309\u8981\u6c42\u586b\u5199\u804c\u7ea7\u8303\u56f4", "PositionCommitValidator_10");
            this.jobRangeFieldCheck(dataEntity, "lowjobgrade", "highjobgrade", "\u8bf7\u6309\u8981\u6c42\u586b\u5199\u804c\u7b49\u8303\u56f4", "PositionCommitValidator_11");
            long recruitNum = dataEntity.getDataEntity().getLong("recruitnum");
            boolean isRecruitNumLimit = dataEntity.getDataEntity().getBoolean("isrecnumlimit");
            if (isRecruitNumLimit) continue;
            if (recruitNum <= 0L || recruitNum > 999L) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u62db\u8058\u4eba\u6570", (String)"PositionCommitValidator_6", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
            }
            this.entryCheck(dataEntity);
        }
        if (VALID_COMMIT_FLAG.equals(this.operationValue)) {
            this.manageInfoCheck(positionIdList, dataEntityMap);
        }
    }

    private void entryCheck(ExtendedDataEntity dataEntity) {
        DynamicObject dyn = dataEntity.getDataEntity();
        Long entrypositionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"entryposition");
        Long entryjobId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"entryjob");
        if (entryjobId.equals(0L) && entrypositionId.equals(0L)) {
            dataEntity.setBillNo(null);
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62df\u5165\u804c\u5c97\u4f4d\u548c\u62df\u5165\u804c\u804c\u4f4d\u81f3\u5c11\u586b\u5199\u4e00\u4e2a", (String)"PositionValidator_0", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
    }

    private void manageInfoCheck(List<Long> positionIdList, Map<Long, ExtendedDataEntity> dataEntityMap) {
        DynamicObject[] manageInfos = PositionManageServiceHelper.getManageInfoByPositionIds(positionIdList);
        Map<Long, DynamicObject> manageInfoMap = Arrays.stream(manageInfos).collect(Collectors.toMap(manageInfo -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)manageInfo, (String)"position"), manageInfo -> manageInfo));
        for (Long positionId : positionIdList) {
            Object recproc;
            DynamicObject dynamicObject = manageInfoMap.get(positionId);
            if (dynamicObject == null) {
                this.addFatalErrorMessage(dataEntityMap.get(positionId), ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u62db\u8058\u6d41\u7a0b", (String)"PositionCommitValidator_10", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
                continue;
            }
            Long sceLevel = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dynamicObject, (String)"seclevel");
            DynamicObjectCollection authorizer = dynamicObject.getDynamicObjectCollection("authorizer");
            if (sceLevel.equals(PositionManageConstants.SECLEVEL_PRIVATE) && authorizer.size() == 0) {
                this.addFatalErrorMessage(dataEntityMap.get(positionId), ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u6388\u6743\u4eba", (String)"PositionCommitValidator_10", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)(recproc = dynamicObject.get("recruproc")))) continue;
            this.addFatalErrorMessage(dataEntityMap.get(positionId), ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u62db\u8058\u6d41\u7a0b", (String)"PositionCommitValidator_10", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
    }

    private void principleCheck(ExtendedDataEntity dataEntity) {
        int sizePosOridinator;
        DynamicObjectCollection posPrinciple = dataEntity.getDataEntity().getDynamicObjectCollection("posprin");
        DynamicObjectCollection posOridinator = dataEntity.getDataEntity().getDynamicObjectCollection("posoridinator");
        int sizePosPrinciple = posPrinciple.size();
        if (sizePosPrinciple > 10) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u804c\u4f4d\u4ea4\u4ed8\u4eba\u6700\u591a\u652f\u630110\u4eba", (String)"PositionCommitValidator_8", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
        if ((sizePosOridinator = posOridinator.size()) > 10) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u804c\u4f4d\u534f\u4f5c\u4eba\u6700\u591a\u652f\u630110\u4eba", (String)"PositionCommitValidator_9", (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
        StringBuilder repeatName = new StringBuilder();
        ArrayList<Long> masteridList = new ArrayList<Long>(posPrinciple.size());
        for (DynamicObject dynamicObject : posPrinciple) {
            masteridList.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
        }
        for (DynamicObject dynamicObject : posOridinator) {
            if (!masteridList.contains(dynamicObject.getDynamicObject("fbasedataid").getLong("id"))) continue;
            repeatName.append(dynamicObject.getDynamicObject("fbasedataid").getString("name"));
            repeatName.append(',');
        }
        if (repeatName.length() > 0) {
            repeatName.deleteCharAt(repeatName.length() - 1);
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u804c\u4f4d\u8d1f\u8d23\u4eba\u4e2d\u7684(%s)\u7528\u6237\u4e0e\u804c\u4f4d\u534f\u4f5c\u4eba\u4e2d\u7684\u7528\u6237\u91cd\u590d", (String)"PositionCommitValidator_9", (String)"tsc-tspr-opplugin", (Object[])new Object[0]), repeatName));
        }
    }

    private void validRangeField(ExtendedDataEntity dataEntity, String rangeUpFields, String rangeDownFields, String limitField, String description, String resourceId) {
        long rangeUp = dataEntity.getDataEntity().getLong(rangeUpFields);
        long rangeDown = dataEntity.getDataEntity().getLong(rangeDownFields);
        boolean isRangeLimit = dataEntity.getDataEntity().getBoolean(limitField);
        if (isRangeLimit) {
            return;
        }
        if (rangeUp == 0L && rangeDown == 0L && "salaryup".equals(rangeUpFields)) {
            return;
        }
        if (this.validRangeCheck(rangeUp, rangeDown)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)description, (String)resourceId, (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
    }

    private void jobRangeFieldCheck(ExtendedDataEntity dataEntity, String rangeUpFields, String rangeDownFields, String description, String resourceId) {
        boolean rangeDownBool;
        DynamicObject rangeUp = dataEntity.getDataEntity().getDynamicObject(rangeUpFields);
        DynamicObject rangeDown = dataEntity.getDataEntity().getDynamicObject(rangeDownFields);
        boolean rangeUpBool = rangeUp != null;
        boolean bl = rangeDownBool = rangeDown != null;
        if (rangeUpBool ^ rangeDownBool) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)description, (String)resourceId, (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
    }

    private void salaryRangeFieldCheck(ExtendedDataEntity dataEntity, String salaryTypeField, String currencyField, String salaryUpField, String salaryDownField, String isSalaryLimit, String description, String resourceId) {
        boolean salaryRangeFlag;
        DynamicObject salaryType = dataEntity.getDataEntity().getDynamicObject(salaryTypeField);
        DynamicObject currency = dataEntity.getDataEntity().getDynamicObject(currencyField);
        long rangeUp = dataEntity.getDataEntity().getLong(salaryUpField);
        long rangeDown = dataEntity.getDataEntity().getLong(salaryDownField);
        boolean salaryLimit = dataEntity.getDataEntity().getBoolean(isSalaryLimit);
        boolean bl = salaryRangeFlag = rangeUp == 0L && rangeDown == 0L && !salaryLimit;
        if (salaryType != null && currency == null) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)description, (String)resourceId, (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
        if (salaryType != null && currency != null && salaryRangeFlag) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)description, (String)resourceId, (String)"tsc-tspr-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean validRangeCheck(long rangeUp, long rangeDown) {
        boolean rangeResult;
        if (rangeUp == 0L && rangeDown == 0L) {
            return true;
        }
        boolean bl = rangeResult = rangeDown >= rangeUp && rangeUp != 0L && rangeDown != 0L;
        return rangeResult || rangeDown < 0L || rangeUp < 0L;
    }
}

