/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.applyprogress;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.applyprogress.ApplyProgressService;
import org.apache.commons.lang3.ObjectUtils;

public class ApplyProgressPlugin
extends HRDynamicFormBasePlugin {
    public static String TAB_IR = "tab_ir";
    public static String TAB_SR = "tab_sr";
    public static String TAB_CR = "tab_cr";
    public static Map<String, Long> TABPAGE_RECRUTYP_MAP = new HashMap<String, Long>(3);

    public ApplyProgressPlugin() {
        TABPAGE_RECRUTYP_MAP.put(TAB_IR, 1030L);
        TABPAGE_RECRUTYP_MAP.put(TAB_SR, 1020L);
        TABPAGE_RECRUTYP_MAP.put(TAB_CR, 1010L);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.checkPermission(e);
    }

    private void checkPermission(PreOpenFormEventArgs e) {
        if (!ApplyProgressService.hasViewPermission()) {
            e.setCancelMessage("\u65e0\u201c\u5e94\u8058\u8fdb\u5c55\u914d\u7f6e\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            e.setCancel(true);
            return;
        }
        if (ApplyProgressService.hasModifyPermission()) {
            e.getFormShowParameter().setStatus(OperationStatus.EDIT);
        } else {
            e.getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject e) {
        for (Map.Entry<String, Long> entry : TABPAGE_RECRUTYP_MAP.entrySet()) {
            String tabKey = entry.getKey();
            Long recruTypId = entry.getValue();
            DynamicObject applyProgressDy = ApplyProgressService.getApplyProgressByReCruTyp((Long)recruTypId);
            if (!ObjectUtils.isNotEmpty((Object)applyProgressDy)) continue;
            this.openApplyProgressPage(tabKey, applyProgressDy.getLong("id"));
        }
    }

    private void openApplyProgressPage(String tabKey, Long applyProgressId) {
        BaseShowParameter bsp = new BaseShowParameter();
        bsp.setFormId("tsrbd_apply_progress");
        bsp.getOpenStyle().setTargetKey(tabKey);
        bsp.getOpenStyle().setShowType(ShowType.InContainer);
        bsp.setPkId((Object)applyProgressId);
        bsp.setStatus(this.getView().getFormShowParameter().getStatus());
        bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm((FormShowParameter)bsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("close".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
        }
    }
}

