/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.bizconfig;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.config.bizconfig.template.BizConfigUtils;
import kd.tsc.tsrbd.business.domain.config.service.CfgIsFirstOpenHelper;
import kd.tsc.tsrbd.business.domain.config.service.FuncIsFirstOpenHelper;

public class BizConfigPlugin
extends AbstractFormPlugin {
    private static final String INTERVIEWER_AI_MAIL = "intervieweraiemail";
    private static final String INTERVIEWER_AI_QUESTION = "intervieweraiquestion";
    private static final String INTERVIEWER_AI_RESUME = "interviewerairesume";
    private static final String POSITION_JD = "positionjd";
    private static final String AI_CONFIG_FLEX = "aiconfigflex";

    public void afterBindData(EventObject event) {
        BizConfigUtils.cacheForms((IFormView)this.getView());
    }

    public void registerListener(EventObject event) {
        this.addClickListeners(BizConfigUtils.getShowMap((IFormView)this.getView()).keySet().toArray(new String[0]));
    }

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        Long userId = UserServiceHelper.getCurrentUserId();
        boolean ifFirst = FuncIsFirstOpenHelper.queryUserIfFirstOpen((Long)userId, (String)"tsrbd_cfgisfirstlopen");
        if (ifFirst) {
            FuncIsFirstOpenHelper.addUserFirstOpen((Long)userId, (String)"tsrbd_cfgisfirstlopen");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tsrbd_guidemessage");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirm"));
            this.getView().showForm(formShowParameter);
        }
        this.getModel().setValue(INTERVIEWER_AI_MAIL, (Object)this.getIfOpen(INTERVIEWER_AI_MAIL));
        this.getModel().setValue(INTERVIEWER_AI_QUESTION, (Object)this.getIfOpen(INTERVIEWER_AI_QUESTION));
        this.getModel().setValue(INTERVIEWER_AI_RESUME, (Object)this.getIfOpen(INTERVIEWER_AI_RESUME));
        this.getModel().setValue(POSITION_JD, (Object)this.getIfOpen(POSITION_JD));
    }

    public boolean getIfOpen(String key) {
        BizConfigUtils bizConfigUtils = new BizConfigUtils();
        DynamicObject dynamicObject = bizConfigUtils.queryBusinessData(AI_CONFIG_FLEX);
        if (null == dynamicObject) {
            return false;
        }
        String dataStr = dynamicObject.getString("data");
        if (HRStringUtils.isBlank((CharSequence)dataStr)) {
            return false;
        }
        try {
            Map map = (Map)SerializationUtils.fromJsonString((String)dataStr, HashMap.class);
            return map.get(key) != null && (Boolean)map.get(key) != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("confirm") && "confirm".equals(returnData = (String)closedCallBackEvent.getReturnData())) {
            CfgIsFirstOpenHelper.showGuide((IFormView)this.getView());
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String formId = (String)BizConfigUtils.getShowMap((String)"showList", (IFormView)this.getView()).get(control.getKey());
        if (formId != null) {
            ListShowParameter params = new ListShowParameter();
            params.setBillFormId(formId);
            params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            params.setPageId(this.getView().getPageId() + formId);
            this.getView().showForm((FormShowParameter)params);
        } else {
            formId = (String)BizConfigUtils.getShowMap((String)"showForm", (IFormView)this.getView()).get(control.getKey());
            if (formId != null) {
                FormShowParameter params = new FormShowParameter();
                params.setFormId(formId);
                params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                params.setPageId(this.getView().getPageId() + formId);
                this.getView().showForm(params);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (INTERVIEWER_AI_MAIL.equals(name) || INTERVIEWER_AI_QUESTION.equals(name) || INTERVIEWER_AI_RESUME.equals(name) || POSITION_JD.equals(name)) {
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put(INTERVIEWER_AI_MAIL, this.getModel().getValue(INTERVIEWER_AI_MAIL) == null ? Boolean.valueOf(false) : this.getModel().getValue(INTERVIEWER_AI_MAIL));
            data.put(INTERVIEWER_AI_QUESTION, this.getModel().getValue(INTERVIEWER_AI_QUESTION) == null ? Boolean.valueOf(false) : this.getModel().getValue(INTERVIEWER_AI_QUESTION));
            data.put(INTERVIEWER_AI_RESUME, this.getModel().getValue(INTERVIEWER_AI_RESUME) == null ? Boolean.valueOf(false) : this.getModel().getValue(INTERVIEWER_AI_RESUME));
            data.put(POSITION_JD, this.getModel().getValue(POSITION_JD) == null ? Boolean.valueOf(false) : this.getModel().getValue(POSITION_JD));
            BizConfigUtils bizConfigUtils = new BizConfigUtils();
            bizConfigUtils.save(AI_CONFIG_FLEX, SerializationUtils.toJsonString(data));
        }
    }
}

