/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.bizconfig;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbd.business.domain.config.bizconfig.template.BizConfigKDStringHelper;
import kd.tsc.tsrbd.business.domain.config.bizconfig.template.BizConfigPermissionHelper;
import kd.tsc.tsrbd.business.domain.config.bizconfig.template.BizConfigUtils;
import org.apache.commons.lang.StringUtils;

public class BizConfigTemplatePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(BizConfigTemplatePlugin.class);
    private static final Map<String, Consumer<BizConfigTemplatePlugin>> OPERATIONS = Maps.newHashMapWithExpectedSize((int)4);
    private final BizConfigUtils bizConfigUtils = new BizConfigUtils();

    public void preOpenForm(PreOpenFormEventArgs args) {
        if (!BizConfigPermissionHelper.hasView()) {
            args.setCancel(true);
            args.setCancelMessage(BizConfigKDStringHelper.noViewPrivilege());
            return;
        }
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void beforeBindData(EventObject event) {
        this.bizConfigUtils.bindData(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String emptyFields;
        if ("save".equals(((AbstractOperate)args.getSource()).getOperateKey()) && StringUtils.isNotBlank((String)(emptyFields = BizConfigUtils.getMustInputEmptyFields((IFormView)this.getView())))) {
            this.getView().showTipNotification(emptyFields + BizConfigKDStringHelper.requiredEmpty());
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        OperationResult operationResult = evt.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            LOGGER.info("fail operationResult:{}", (Object)operationResult.toString());
            return;
        }
        Optional.ofNullable(OPERATIONS.get(evt.getOperateKey())).ifPresent(op -> op.accept(this));
    }

    private void modify() {
        if (!BizConfigPermissionHelper.hasEdit()) {
            this.getView().showErrorNotification(BizConfigKDStringHelper.noEditPrivilege());
            return;
        }
        this.getView().setStatus(OperationStatus.EDIT);
    }

    private void refresh() {
        this.bizConfigUtils.clearData(this.getView());
        this.bizConfigUtils.bindData(this.getView());
    }

    private void save() {
        if (!BizConfigPermissionHelper.hasEdit()) {
            this.getView().showErrorNotification(BizConfigKDStringHelper.noEditPrivilege());
            return;
        }
        this.bizConfigUtils.save(this.getView());
        this.cancel();
    }

    private void cancel() {
        this.getView().setStatus(OperationStatus.VIEW);
        this.refresh();
    }

    static {
        OPERATIONS.put("modify", BizConfigTemplatePlugin::modify);
        OPERATIONS.put("refresh", BizConfigTemplatePlugin::refresh);
        OPERATIONS.put("save", BizConfigTemplatePlugin::save);
        OPERATIONS.put("cancel", BizConfigTemplatePlugin::cancel);
    }
}

