/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.bizconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.config.bizconfig.template.BizConfigCache;
import kd.tsc.tsrbd.business.domain.config.bizconfig.template.BizConfigUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang.StringUtils;

public class OfferConfigPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(OfferConfigPlugin.class);
    private final BizConfigCache bizConfigCache;
    private final HRBaseServiceHelper dataHelper = new HRBaseServiceHelper("tsrbd_businessconfigdata");
    private static final Map<String, Consumer<OfferConfigPlugin>> OPERATIONS = new HashMap<String, Consumer<OfferConfigPlugin>>(8);

    public OfferConfigPlugin() {
        this.bizConfigCache = new BizConfigCache(new BizConfigUtils());
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        if (!PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)"tsrbd", (String)"tsrbd_offerconfig", (String)"47150e89000000ac")) {
            String formName = args.getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
            args.setCancel(true);
            String tipMessage = "\u65e0 \u201c{0}\u201d \u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002";
            args.setCancelMessage(ResManager.loadKDString((String)MessageFormat.format(tipMessage, formName), (String)"BizConfigTemplatePlugin_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return;
        }
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        if (!PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)"tsrbd", (String)"tsrbd_offerconfig", (String)"4715a0df000000ac")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"modify"});
        }
        this.bindData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if ("save".equals(((AbstractOperate)args.getSource()).getOperateKey())) {
            String emptyFields = this.getMustInputEmptyFields();
            if (StringUtils.isNotBlank((String)emptyFields)) {
                this.getView().showTipNotification(emptyFields + ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizConfigTemplatePlugin_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                String nonConformanceMsg = this.checkDataScope();
                if (StringUtils.isNotBlank((String)nonConformanceMsg)) {
                    this.getView().showTipNotification(nonConformanceMsg);
                    args.setCancel(true);
                }
            }
        }
    }

    private String checkDataScope() {
        Map allFields = EntityMetadataCache.getDataEntityType((String)this.getView().getFormShowParameter().getFormId()).getAllFields();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String checkValue = null;
        for (Map.Entry entry : allFields.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            Object val = property.getValue((Object)dataEntity);
            if (!(property instanceof IntegerProp) || !(val instanceof Integer)) continue;
            BigDecimal max = ((IntegerProp)property).getMax();
            BigDecimal min = ((IntegerProp)property).getMin();
            if (new BigDecimal(val.toString()).compareTo(max) <= 0 && new BigDecimal(val.toString()).compareTo(min) >= 0) continue;
            checkValue = property.getName() + " need in what range [" + min + "," + max + "]";
            break;
        }
        return checkValue;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        OperationResult operationResult = evt.getOperationResult();
        if (operationResult.isSuccess()) {
            Optional.ofNullable(OPERATIONS.get(evt.getOperateKey())).ifPresent(op -> op.accept(this));
        }
    }

    protected ObjectNode getObjectNode() {
        Map fields = EntityMetadataCache.getDataEntityType((String)this.getView().getFormShowParameter().getFormId()).getAllFields();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Map.Entry entry : fields.entrySet()) {
            String key = (String)entry.getKey();
            if ("0".equals(this.getPageCache().get(BizConfigUtils.getVisibleKey((String)key)))) continue;
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            Object val = property.getValue((Object)dataEntity);
            if (val instanceof Integer) {
                node.put(key, (Integer)val);
                continue;
            }
            if (val instanceof Long) {
                node.put(key, (Long)val);
                continue;
            }
            if (val instanceof BigDecimal) {
                node.put(key, (BigDecimal)val);
                continue;
            }
            if (val instanceof Date) {
                node.put(key, format.format(val));
                continue;
            }
            if (val instanceof DynamicObject) {
                node.put(key, (Long)((DynamicObject)val).getPkValue());
                continue;
            }
            if (val instanceof DynamicObjectCollection) {
                ArrayNode array = node.putArray(key);
                ((DynamicObjectCollection)val).forEach(dy -> array.add((Long)dy.getDynamicObject("fbasedataid").getPkValue()));
                continue;
            }
            node.put(key, String.valueOf(val));
        }
        return node;
    }

    private void modify() {
        if (!PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)"tsrbd", (String)"tsrbd_offerconfig", (String)"4715a0df000000ac")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"modify"});
            String formName = this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
            String tipMessage = "\u65e0 \u201c{0}\u201d \u7684\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002";
            this.getView().showErrorNotification(ResManager.loadKDString((String)MessageFormat.format(tipMessage, formName), (String)"BizConfigTemplatePlugin_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setStatus(OperationStatus.EDIT);
    }

    private void refresh() {
        this.bindData();
    }

    private void save() {
        try (TXHandle tx = TX.required();){
            String json = new ObjectMapper().writeValueAsString((Object)this.getObjectNode());
            if (json.length() > 5000) {
                throw new KDException(new ErrorCode("", "Data size is over the limit"), new Object[0]);
            }
            DynamicObject data = this.queryBusinessData();
            if (data == null) {
                data = this.dataHelper.generateEmptyDynamicObject();
                data.set("number", (Object)this.getView().getFormShowParameter().getFormId());
            }
            data.set("data", (Object)json);
            this.dataHelper.saveOne(data);
            this.bizConfigCache.remove(this.getView().getFormShowParameter().getFormId());
        }
        this.cancel();
    }

    private void cancel() {
        this.getView().setStatus(OperationStatus.VIEW);
        this.refresh();
    }

    private void bindData() {
        DynamicObject bizData = this.queryBusinessData();
        if (bizData == null) {
            return;
        }
        Map map = BizConfigUtils.getFormData((String)this.getView().getFormShowParameter().getFormId(), (String)bizData.getString("data"));
        map.forEach((key, value) -> this.getModel().setValue(key, map.get(key)));
    }

    private DynamicObject queryBusinessData() {
        return this.dataHelper.queryOne("data", new QFilter("number", "=", (Object)this.getView().getFormShowParameter().getFormId()));
    }

    private String getMustInputEmptyFields() {
        Map fields = EntityMetadataCache.getDataEntityType((String)this.getView().getFormShowParameter().getFormId()).getAllFields();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return fields.values().stream().filter(prop -> !"0".equals(this.getPageCache().get(BizConfigUtils.getVisibleKey((String)prop.getName()))) && BizConfigUtils.isMustInput((IDataEntityProperty)prop) && prop.isEmpty((Object)dataEntity)).map(prop -> prop.getDisplayName().getLocaleValue()).collect(Collectors.joining("\u3001"));
    }

    static {
        OPERATIONS.put("modify", OfferConfigPlugin::modify);
        OPERATIONS.put("refresh", OfferConfigPlugin::refresh);
        OPERATIONS.put("save", OfferConfigPlugin::save);
        OPERATIONS.put("cancel", OfferConfigPlugin::cancel);
    }
}

