/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.cfgmsgtemplate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.util.SecurityUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgFormService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.EmailMessageParser;
import kd.tsc.tsrbd.business.domain.config.service.BizConfigParamHelper;
import kd.tsc.tsrbd.business.domain.recruscene.service.RecruSceneService;
import kd.tsc.tsrbd.common.constants.CfgMsgTemplateConstants;
import kd.tsc.tsrbd.common.constants.MsgTplConstants;
import kd.tsc.tsrbd.common.utils.NotDataChangeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CfgMsgTemplateEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
TabSelectListener {
    private static Map<Long, String> MSG_TEMPLATE_VARIABLE_FLEX_MAP = new HashMap<Long, String>(16);
    private static Map<Long, String> MSG_TEMPLATE_FLEX_MAP = new HashMap<Long, String>(16);
    private static final String EMAIL_SMS_CHANNEL_INIT_VALUE = ",475773782250774528,475773159430184960,";
    private static final Log logger = LogFactory.getLog(CfgMsgTemplateEdit.class);

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"previewlbl", "vectorap"});
        BasedataEdit msgTemplate = (BasedataEdit)this.getControl("msgreceiver");
        msgTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recType = (BasedataEdit)this.getControl("recrutype");
        recType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recScene = (BasedataEdit)this.getControl("recruscene");
        recScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit msgPushScene = (BasedataEdit)this.getControl("msgpushscene");
        msgPushScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.updateInterviewControl();
        this.msgReceiverTypeValueInit(false);
        this.updateMessageTemplateLabel(null);
        this.updateMsgTempVariablesLabel();
        if (this.getModel().getDataEntity().getBoolean("issyspreset")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"recrutype", "recruscene", "description"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_saveandnew"});
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("msgreceiver".equals(property)) {
            DynamicObject msgPushScene = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
            if (msgPushScene != null) {
                long msgPushSceneId = msgPushScene.getLong("id");
                QFilter qFilter = new QFilter("pushmsgscene.fbasedataid", "=", (Object)msgPushSceneId);
                if (Sets.newHashSet((Object[])new String[]{"1030", "1040"}).contains(String.valueOf(msgPushSceneId))) {
                    qFilter.and("id", "!=", (Object)1050L);
                }
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        } else if ("recruscene".equals(property)) {
            QFilter qFilter;
            DynamicObject recTypeDynObj = this.getModel().getDataEntity().getDynamicObject("recrutype");
            if (recTypeDynObj != null) {
                DynamicObject[] sceneByIdDynObj = RecruSceneService.getSceneById((long)recTypeDynObj.getLong("id"));
                ArrayList<Long> ids = new ArrayList<Long>(sceneByIdDynObj.length);
                for (DynamicObject dynObj : sceneByIdDynObj) {
                    ids.add(dynObj.getLong("id"));
                }
                qFilter = new QFilter("id", "in", ids);
            } else {
                qFilter = new QFilter("1", "!=", (Object)1);
            }
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.initData();
        Long useOrgId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("useorgId"));
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String entityName = this.getModel().getDataEntity().getDataEntityType().toString();
        this.getView().setEnable(Boolean.FALSE, new String[]{"createOrg"});
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            this.getModel().setValue("createorg", (Object)useOrgId);
            long createOrgId = useOrgId;
            this.getModel().setValue("createOrg", (Object)createOrgId);
            this.getModel().setValue("ctrlstrategy", (Object)"5");
            List bctrlStragy = BaseDataServiceHelper.getBdCtrlOrgs((String)entityName);
            if (bctrlStragy != null && bctrlStragy.size() != 0) {
                long org = OrgServiceHelper.getCuByOrgId((long)createOrgId);
                if (org != 0L) {
                    this.getModel().setValue("org", (Object)org);
                }
            } else {
                this.getModel().setValue("org", (Object)createOrgId);
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        DynamicObject msgRecvTypeDyn;
        DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if (null != msgPushSceneDyn && "1080".equals(msgPushSceneDyn.getString("id")) && !HRObjectUtils.isEmpty((Object)(msgRecvTypeDyn = this.getModel().getDataEntity().getDynamicObject("msgreceiver")))) {
            this.updateTsrscMsgTempVariablesLabel(msgPushSceneDyn, msgRecvTypeDyn);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        BillShowParameter showParameter = (BillShowParameter)args.getFormShowParameter();
        if (OperationStatus.ADDNEW == showParameter.getStatus()) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6d88\u606f\u6a21\u677f", (String)"CfgMsgTemplateTreeList_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void initData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW == status) {
            MulComboEdit mulComboEditInterviewCategory = (MulComboEdit)this.getView().getControl("intvcategorylist");
            MulComboEdit mulComboEditInterviewMethod = (MulComboEdit)this.getView().getControl("intvmethodlist");
            BasedataEdit recruitType = (BasedataEdit)this.getControl("recrutype");
            recruitType.setMustInput(false);
            mulComboEditInterviewMethod.setMustInput(false);
            mulComboEditInterviewCategory.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"recrutyplist", "msgreceiver", "description", "intvcategorylist", "intvmethodlist", "sendtype"});
        }
    }

    private void initTsirmMultiCombo() {
        DynamicObject[] channelObjects = CfgMsgTemplateHelper.queryMsgChannels((List)CfgMsgFormService.getChannelListId((String)EMAIL_SMS_CHANNEL_INIT_VALUE));
        CfgMsgFormService.loadComboItemsInMultiComboEdit((IFormView)this.getView(), (DynamicObject[])channelObjects, (String)"msgchannellist");
        this.getModel().setValue("msgchannellist", (Object)EMAIL_SMS_CHANNEL_INIT_VALUE);
        if ("false".equals(this.getModel().getValue("emailtheme"))) {
            this.getModel().setValue("emailtheme", null);
        }
        DynamicObject[] interviewCategoryObjects = CfgMsgTemplateHelper.queryBaseData((String)CfgMsgTemplateConstants.INTERVIEW_CATEGORY_ENTITY);
        CfgMsgFormService.loadComboItemsInMultiComboEdit((IFormView)this.getView(), (DynamicObject[])interviewCategoryObjects, (String)"intvcategorylist");
        DynamicObject[] interviewMethodObjects = CfgMsgTemplateHelper.queryBaseData((String)CfgMsgTemplateConstants.INTERVIEW_METHOD_ENTITY);
        DynamicObject[] removeAiDynamicObjects = (DynamicObject[])Arrays.stream(interviewMethodObjects).filter(interviewCategoryObject -> interviewCategoryObject.getLong("id") != 1030L).toArray(DynamicObject[]::new);
        CfgMsgFormService.loadComboItemsInMultiComboEdit((IFormView)this.getView(), (DynamicObject[])removeAiDynamicObjects, (String)"intvmethodlist");
    }

    private void initTsrscMultiCombo() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String channelListStr = null;
        DynamicObject[] fullChannelObjects = CfgMsgTemplateHelper.queryCfgMsgChannels(null);
        boolean isCopy = this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy");
        if (OperationStatus.ADDNEW.equals((Object)status) && !isCopy) {
            DynamicObject[] dyns = fullChannelObjects;
            channelListStr = Arrays.stream(dyns).map(c -> c.getString("id")).collect(Collectors.joining(","));
            CfgMsgFormService.loadComboItemsInMultiComboEdit((IFormView)this.getView(), (DynamicObject[])dyns, (String)"msgchannellist");
        } else {
            List channelListId = CfgMsgFormService.getChannelListId((String)this.getModel().getDataEntity().getString("msgchannellist"));
            DynamicObject[] channelObjects = isCopy ? CfgMsgTemplateHelper.queryCfgMsgChannels((List)channelListId) : CfgMsgTemplateHelper.queryMsgChannels((List)channelListId);
            ArrayList<DynamicObject> channelList = new ArrayList<DynamicObject>(16);
            for (DynamicObject channelObject : channelObjects) {
                channelList.add(channelObject);
            }
            String channelStr = channelList.stream().map(c -> c.getString("id")).collect(Collectors.joining(","));
            String fullChannelListStr = Arrays.stream(fullChannelObjects).map(c -> c.getString("id")).collect(Collectors.joining(","));
            String efficacy = ResManager.loadKDString((String)"(\u5931\u6548)", (String)"CfgMsgTemplateEdit_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
            for (DynamicObject channelObject : channelList) {
                if (fullChannelListStr.contains(channelObject.getString("id"))) continue;
                channelObject.set("name", (Object)(channelObject.getString("name") + efficacy));
            }
            for (DynamicObject fullChannelObject : fullChannelObjects) {
                if (channelStr.contains(fullChannelObject.getString("id"))) continue;
                channelList.add(fullChannelObject);
            }
            DynamicObject[] dyns = channelList.toArray(new DynamicObject[0]);
            CfgMsgFormService.loadComboItemsInMultiComboEdit((IFormView)this.getView(), (DynamicObject[])dyns, (String)"msgchannellist");
            channelListStr = channelStr;
        }
        if ((!OperationStatus.ADDNEW.equals((Object)status) || this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy")) && 0 == this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size()) {
            this.convertEntry();
        }
        if (HRStringUtils.isEmpty((String)channelListStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u901a\u77e5\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5\u6d88\u606f\u6e20\u9053\u914d\u7f6e\u3002", (String)"CfgMsgTemplateEdit_6", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            return;
        }
        List ids = Arrays.stream(channelListStr.split(",")).map(Long::valueOf).collect(Collectors.toList());
        this.handleNotificationTemplate(CfgMsgTemplateHelper.queryMsgChannels(ids));
        this.getModel().beginInit();
        this.getModel().setValue("msgchannellist", (Object)channelListStr);
        this.getModel().endInit();
        this.getView().updateView("msgchannellist");
        this.updateTsrscMessageTemplateLabel();
    }

    private void convertEntry() {
        String smsTemplate = this.getModel().getDataEntity().getString("smstemplate");
        String emailRichText = this.getModel().getDataEntity().getString("emailrichtextfd_tag");
        String emailTheme = this.getModel().getDataEntity().getString("emailtheme");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("channelid", new Object[0]);
        setter.addField("category", new Object[0]);
        setter.addField("emailtitle", new Object[0]);
        setter.addField("emailtempcontext", new Object[0]);
        setter.addField("smstempcontext", new Object[0]);
        setter.addRow(new Object[]{MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY, "email", emailTheme, emailRichText, null});
        setter.addRow(new Object[]{MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY, "shortMsg", null, null, smsTemplate});
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if (msgPushSceneDyn != null && "1080".equals(msgPushSceneDyn.getString("id"))) {
            this.tsrscClick(control);
        } else {
            this.tsrimClick(control, msgPushSceneDyn);
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if (key.startsWith("label")) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            args.setControl((Control)vector);
        }
    }

    private void tsrimClick(Control control, DynamicObject msgPushSceneDyn) {
        if ("previewlbl".equals(control.getKey()) || "vectorap".equals(control.getKey())) {
            IAppCache iAppCache = AppCache.get((String)"tsc_tsrbd_msgtemplate");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("URL_REPLACE_FLAG", Boolean.FALSE);
            EmailMessageParser emailMessageParser = new EmailMessageParser();
            RichTextEditor emailRichText = (RichTextEditor)this.getView().getControl("emailrichtext");
            if (ObjectUtils.isNotEmpty((Object)emailRichText.getText()) && emailRichText.getText().length() > 100001) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90ae\u4ef6\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7100000\u4e2a\u5b57\u7b26\u3002", (String)"CfgMsgTemplateEdit_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                return;
            }
            String emailTemplate = emailRichText.getText();
            if (HRStringUtils.isBlank((CharSequence)emailTemplate)) {
                emailTemplate = this.getView().getPageCache().get(this.getView().getPageId());
            }
            customParams.put("emailtheme", this.getModel().getDataEntity().getString("emailtheme"));
            customParams.put("URL_REPLACE_FLAG", Boolean.FALSE);
            String emailContent = emailMessageParser.parseMessage(emailTemplate, customParams, null);
            iAppCache.put("emailtemplate", (Object)emailContent);
            iAppCache.put("msgchannellist", (Object)this.getModel().getDataEntity().getString("msgchannellist"));
            iAppCache.put("smstemplate", (Object)this.getModel().getDataEntity().getString("smstemplate"));
            String currentTab = ((Tab)this.getView().getControl("tabap")).getCurrentTab();
            iAppCache.put("pagenumber", (Object)currentTab);
            CfgMsgFormService.slidePreviewForm((IFormView)this.getView(), (String)CfgMsgTemplateConstants.MSG_TEMPLATE_ENTITY);
        } else if (control.getKey().startsWith("labelemail_")) {
            String[] splitString = control.getKey().split("_");
            DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryVariablesNameByField((String)splitString[1], (Long)msgPushSceneDyn.getLong("id"));
            this.setRichTextClickLabel(dynamicObjects[0].getString("name"));
        } else if (control.getKey().startsWith("labelsms_")) {
            String[] splitString = control.getKey().split("_");
            DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryVariablesNameByField((String)splitString[1], (Long)msgPushSceneDyn.getLong("id"));
            this.setMultiTextClickLabel(dynamicObjects[0].getString("name"), "smstemplate");
        }
    }

    private void tsrscClick(Control control) {
        if ("previewlbl".equals(control.getKey()) || "vectorap".equals(control.getKey())) {
            String msgChannelList = this.getModel().getDataEntity().getString("msgchannellist");
            if (HRStringUtils.isEmpty((String)msgChannelList)) {
                return;
            }
            JSONArray jsonArray = new JSONArray();
            JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
            DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgChannels((List)CfgMsgFormService.getChannelListId((String)msgChannelList));
            IAppCache iAppCache = AppCache.get((String)"tsc_tsrbd_msgtemplate");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : dynamicObjects) {
                String emailContent;
                HashMap<String, String> map = new HashMap<String, String>(3);
                IFormView tabView = this.getView().getView(pageJson.getString(dyn.getString("id")));
                if (HRStringUtils.isEmpty((String)tabView.getPageCache().get("category"))) {
                    for (DynamicObject entry : entryEntity) {
                        if (!dyn.getString("id").equals(entry.getString("channelid"))) continue;
                        if ("email".equals(dyn.getString("category"))) {
                            customParams.put("emailtheme", entry.getString("emailtitle"));
                            EmailMessageParser emailMessageParse = new EmailMessageParser();
                            emailContent = emailMessageParse.parseMessage(entry.getString("emailtempcontext"), customParams, null);
                            map.put("content", emailContent);
                        } else if ("shortMsg".equals(dyn.getString("category"))) {
                            map.put("content", entry.getString("smstempcontext"));
                        } else {
                            map.put("content", null);
                        }
                        map.put("tabName", dyn.getString("name"));
                        map.put("category", dyn.getString("category"));
                        break;
                    }
                } else {
                    if ("email".equals(dyn.getString("category"))) {
                        customParams.put("emailtheme", tabView.getModel().getDataEntity().getString("emailtheme"));
                        EmailMessageParser emailMessageParse = new EmailMessageParser();
                        RichTextEditor emailRichText = (RichTextEditor)tabView.getControl("emailrichtext");
                        String emailTemplate = emailRichText.getText();
                        emailContent = emailMessageParse.parseMessage(emailTemplate, customParams, null);
                        map.put("content", emailContent);
                        map.put("category", "email");
                    } else if ("shortMsg".equals(dyn.getString("category"))) {
                        String smsContent = String.valueOf(tabView.getModel().getValue("smstemplate"));
                        map.put("content", smsContent);
                        map.put("category", "shortMsg");
                    } else if ("mobileApp".equals(dyn.getString("category"))) {
                        map.put("category", "mobileApp");
                        map.put("content", null);
                    }
                    map.put("tabName", dyn.getString("name"));
                }
                jsonArray.add(map);
            }
            iAppCache.put("tabItems", (Object)jsonArray);
            CfgMsgFormService.slidePreviewForm((IFormView)this.getView(), (String)CfgMsgTemplateConstants.MSG_TEMPLATE_ENTITY2);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "msgpushscene": {
                this.msgSceneValueChange();
                break;
            }
            case "recrutype": {
                this.recTypeValueChange();
                break;
            }
            case "msgchannellist": {
                this.updateMessageTemplateLabel(args);
                break;
            }
        }
        if ("msgpushscene".equals(propertyName) || "msgreceiver".equals(propertyName) || "msgchannellist".equals(propertyName) || "intvmethodlist".equals(propertyName)) {
            this.msgSceneAndMsgRecvTypeValueChange();
        }
    }

    private void msgSceneValueChange() {
        DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if (null == msgPushSceneDyn) {
            this.updateInterviewControl();
            this.getModel().setValue("msgchannellist", null);
            return;
        }
        if (!"1080".equals(msgPushSceneDyn.getString("id"))) {
            this.closeTab();
        }
        this.updateInterviewControl();
        this.msgReceiverTypeValueInit(true);
        this.getModel().setValue("smstemplate", null);
        RichTextEditor emailRichText = (RichTextEditor)this.getView().getControl("emailrichtext");
        emailRichText.setText(null);
    }

    private void recTypeValueChange() {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("recrutype");
        if (dynamicObject == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"recruscene"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"recruscene"});
        }
        this.getModel().setValue("recruscene", null);
    }

    private void msgReceiverTypeValueInit(boolean flag) {
        DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if (msgPushSceneDyn == null) {
            ((MulComboEdit)this.getView().getControl("msgchannellist")).setComboItems(null);
            this.getModel().setValue("msgchannellist", null);
            return;
        }
        String msgSceneNumber = msgPushSceneDyn.getString("id");
        BasedataEdit recruitType = (BasedataEdit)this.getControl("recrutype");
        if ("1080".equals(msgSceneNumber)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap", "tabpageap1", "tabpageap2"});
            this.initTsrscMultiCombo();
        } else {
            this.closeTab();
            this.initTsirmMultiCombo();
        }
        if (Arrays.asList("1080", "1090", "1100", "1110", "1120", "1130").contains(msgSceneNumber)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap"});
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"msgchannellist"});
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus() && flag) {
            this.getModel().setValue("msgreceiver", null);
        }
        if (Objects.equals("1080", msgSceneNumber)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"recrutype"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"recruscene"});
            recruitType.setMustInput(true);
            if (flag) {
                this.getModel().setValue("recrutype", null);
            }
        } else if (Sets.newHashSet((Object[])new String[]{"1020", "1030", "1040"}).contains(msgSceneNumber)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"recrutype"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"recruscene"});
            recruitType.setMustInput(true);
            this.getModel().setValue("recrutype", (Object)1030L);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"recrutype"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"recruscene"});
            recruitType.setMustInput(false);
            this.getModel().setValue("recrutype", null);
            this.getModel().setValue("recruscene", null);
        }
    }

    private void handleNotificationTemplate(DynamicObject[] channelObjects) {
        if (HRObjectUtils.isEmpty((Object)channelObjects)) {
            return;
        }
        this.closeTab();
        this.buildChannelsTabs(channelObjects);
    }

    private void closeTab() {
        JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
        if (null != pageJson) {
            for (Map.Entry entry : pageJson.entrySet()) {
                if (null == this.getView().getView(String.valueOf(entry.getValue()))) continue;
                this.getView().getView(String.valueOf(entry.getValue())).close();
                this.getView().sendFormAction(this.getView().getView(String.valueOf(entry.getValue())));
            }
        }
        this.getView().getPageCache().remove("CHANNEL_PAGE_JSON");
    }

    private void buildChannelsTabs(DynamicObject[] channelObjects) {
        JSONObject channelPageJson = null != this.getView().getPageCache().get("CHANNEL_PAGE_JSON") ? JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON")) : new JSONObject();
        JSONObject channelNameJson = null != this.getView().getPageCache().get("CHANNEL_NAME_JSON") ? JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_NAME_JSON")) : new JSONObject();
        JSONObject channelTypeJson = null != this.getView().getPageCache().get("CHANNEL_TYPE_JSON") ? JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_TYPE_JSON")) : new JSONObject();
        DynamicObject receiverObject = this.getModel().getDataEntity(false).getDynamicObject("msgreceiver");
        Long msgReceiverType = null != receiverObject ? Long.valueOf(receiverObject.getLong("id")) : null;
        DynamicObject pushSceneObject = this.getModel().getDataEntity(false).getDynamicObject("msgpushscene");
        Long msgSceneTypeId = null != pushSceneObject ? Long.valueOf(pushSceneObject.getLong("id")) : null;
        String msgChannelList = this.getModel().getDataEntity().getString("msgchannellist");
        for (DynamicObject channelObject : channelObjects) {
            channelNameJson.put(channelObject.getString("id"), (Object)channelObject.getString("name"));
            channelTypeJson.put(channelObject.getString("id"), (Object)channelObject.getString("category"));
            if ("email".equals(channelObject.getString("category"))) {
                this.createTab("tsrbd_cfgemailtemplate", channelObject, channelPageJson, msgReceiverType, msgSceneTypeId, msgChannelList);
                continue;
            }
            this.createTab("tsrbd_cfgsmstemplate", channelObject, channelPageJson, msgReceiverType, msgSceneTypeId, msgChannelList);
        }
        this.getView().getPageCache().put("CHANNEL_NAME_JSON", channelNameJson.toString());
        this.getView().getPageCache().put("CHANNEL_TYPE_JSON", channelTypeJson.toString());
        this.getView().getPageCache().put("CHANNEL_PAGE_JSON", channelPageJson.toString());
    }

    private void createTab(String formId, DynamicObject channelObject, JSONObject pageJson, Long msgReceiverType, Long msgSceneTypeId, String msgChannelList) {
        FormShowParameter parameter = new FormShowParameter();
        String pageId = parameter.getPageId();
        pageJson.put(channelObject.getString("id"), (Object)pageId);
        parameter.setStatus(this.getModel().getDataEntity().getBoolean("issyspreset") ? OperationStatus.VIEW : OperationStatus.EDIT);
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.getOpenStyle().setTargetKey("tabap");
        String suffix = ResManager.loadKDString((String)"\u6a21\u677f\u914d\u7f6e", (String)"CfgMsgTemplateEdit_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
        parameter.setCaption(channelObject.getString("name") + suffix);
        parameter.setCustomParam("category", (Object)channelObject.getString("category"));
        parameter.setCustomParam("msgSceneType", (Object)msgSceneTypeId);
        parameter.setCustomParam("msgReceiverType", (Object)msgReceiverType);
        parameter.setCustomParam("msgchannellist", (Object)msgChannelList);
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            if (channelObject.getLong("id") != entry.getLong("channelid")) continue;
            parameter.setCustomParam("smstemplate", (Object)entry.getString("smstempcontext"));
            parameter.setCustomParam("emailrichtext", (Object)entry.getString("emailtempcontext"));
            parameter.setCustomParam("emailtheme", (Object)entry.getString("emailtitle"));
            break;
        }
        this.getView().showForm(parameter);
    }

    private void msgSceneAndMsgRecvTypeValueChange() {
        this.updateMsgTempVariablesLabel();
    }

    private void hideOrShowMsg() {
        DynamicObject receiver = this.getModel().getDataEntity().getDynamicObject("msgreceiver");
        DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if (msgPushSceneDyn == null) {
            return;
        }
        String msgSceneNumber = msgPushSceneDyn.getString("id");
        if (Sets.newHashSet((Object[])new String[]{"1020", "1030", "1040"}).contains(msgSceneNumber) && receiver != null && receiver.getLong("id") == 1040L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap1"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabpageap1"});
        }
    }

    private void updateMessageTemplateLabel(PropertyChangedArgs args) {
        DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if (msgPushSceneDyn == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap", "tabpageap", "tabpageap1", "tabpageap2", "flexpanelap2"});
            return;
        }
        String msgSceneNumber = msgPushSceneDyn.getString("id");
        if ("1080".equals(msgSceneNumber)) {
            String msgChannelList = this.getModel().getDataEntity().getString("msgchannellist");
            if (msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
                if (null != args) {
                    this.changeTsrscTab(args);
                    this.getView().getModel().setValue("msgreceiver", null);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"msgreceiver"});
                }
                this.getView().getPageCache().put("CHANNEL_PAGE_JSON", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabap", "flexpanelap2"});
                return;
            }
            if (null != args) {
                this.changeTsrscTab(args);
                this.updateTsrscMessageTemplateLabel();
                this.getView().setEnable(Boolean.TRUE, new String[]{"msgreceiver"});
            }
        } else {
            DynamicObject msgReceiver = this.getView().getModel().getDataEntity().getDynamicObject("msgreceiver");
            this.updateTsirmMsgTempVariablesLabel(msgPushSceneDyn, msgReceiver);
            this.updateTsirmMessageTemplateLabel();
            RichTextEditor emailRichText = (RichTextEditor)this.getView().getControl("emailrichtext");
            String emailRichTextString = this.getModel().getDataEntity().getString("emailrichtextfd_tag");
            emailRichText.setText(emailRichTextString);
        }
    }

    private void changeTsrscTab(PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        ArrayList newNotifications = null == changeData.getNewValue() ? new ArrayList() : Arrays.asList(String.valueOf(changeData.getNewValue()).split(","));
        ArrayList<String> oldNotifications = null == changeData.getOldValue() ? new ArrayList<String>() : Arrays.asList(String.valueOf(changeData.getOldValue()).split(","));
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (String newNotification : newNotifications) {
            if (HRStringUtils.isEmpty((String)newNotification) || oldNotifications.contains(newNotification)) continue;
            DynamicObject[] newDynamicObjects = CfgMsgTemplateHelper.queryCfgMsgChannels(Collections.singletonList(Long.valueOf(newNotification)));
            if (0 == newDynamicObjects.length) {
                this.efficacyChannel(oldNotifications, newNotification);
                return;
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            setter.addField("channelid", new Object[0]);
            setter.addField("category", new Object[0]);
            setter.addField("emailtitle", new Object[0]);
            setter.addField("emailtempcontext", new Object[0]);
            setter.addField("smstempcontext", new Object[0]);
            for (DynamicObject entry : entryEntity) {
                if (!entry.getString("category").equals(newDynamicObjects[0].getString("category"))) continue;
                setter.addRow(new Object[]{newDynamicObjects[0].getLong("id"), newDynamicObjects[0].getString("category"), "", "", ""});
                break;
            }
            model.batchCreateNewEntryRow("entryentity", setter);
            model.endInit();
            this.getView().updateView("entryentity");
            this.buildChannelsTabs(newDynamicObjects);
        }
        for (String oldNotification : oldNotifications) {
            if (newNotifications.contains(oldNotification) || HRStringUtils.isEmpty((String)oldNotification)) continue;
            JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
            if (null == this.getView().getView(pageJson.getString(oldNotification))) continue;
            this.getView().getView(pageJson.getString(oldNotification)).close();
            this.getView().sendFormAction(this.getView().getView(pageJson.getString(oldNotification)));
            pageJson.remove((Object)oldNotification);
        }
    }

    private void efficacyChannel(List<String> oldNotifications, String newNotification) {
        JSONObject nameJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_NAME_JSON"));
        this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u6e20\u9053\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9.", (String)"CfgMsgTemplateEdit_5", (String)"tsc-tsrbd-formplugin", (Object[])new Object[]{nameJson.getString(newNotification)}));
        JSONObject comboItemJson = JSONObject.parseObject((String)this.getView().getPageCache().get("comboItem"));
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        String efficacyNotification = "";
        for (Map.Entry entry : comboItemJson.entrySet()) {
            if (!((String)entry.getKey()).equals(newNotification)) {
                items.add(new ComboItem(new LocaleString(entry.getValue().toString()), (String)entry.getKey()));
                continue;
            }
            efficacyNotification = (String)entry.getKey();
        }
        if (!items.isEmpty()) {
            ((MulComboEdit)this.getControl("msgchannellist")).setComboItems(items);
        }
        this.getModel().beginInit();
        this.getModel().setValue("msgchannellist", (Object)StringUtils.join((Object[])oldNotifications.toArray(), (String)","));
        this.getModel().endInit();
        this.getView().updateView("msgchannellist");
        comboItemJson.remove((Object)efficacyNotification);
        this.getView().getPageCache().put("comboItem", comboItemJson.toString());
    }

    private void updateTsrscMessageTemplateLabel() {
        JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabap", "flexpanelap2"});
        String msgChannelList = this.getModel().getDataEntity().getString("msgchannellist");
        if (msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap", "flexpanelap2"});
            return;
        }
        String[] msgChannels = msgChannelList.split(",");
        Tab tab = (Tab)this.getControl("tabap");
        for (String msgChannel : msgChannels) {
            if (HRStringUtils.isEmpty((String)msgChannel)) continue;
            tab.activeTab(pageJson.getString(msgChannel));
            break;
        }
    }

    private void updateTsirmMessageTemplateLabel() {
        String[] msgChannels;
        int index = 0;
        String tabName = null;
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabap", "flexpanelap2"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap", "tabpageap1", "tabpageap2"});
        String msgChannelList = this.getModel().getDataEntity().getString("msgchannellist");
        if (msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap", "flexpanelap2"});
            return;
        }
        for (String msgChannel : msgChannels = msgChannelList.split(",")) {
            if (HRStringUtils.isEmpty((String)msgChannel)) continue;
            if (index == 0) {
                tabName = MSG_TEMPLATE_FLEX_MAP.get(Long.valueOf(msgChannel));
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{MSG_TEMPLATE_FLEX_MAP.get(Long.valueOf(msgChannel))});
            ++index;
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(tabName);
    }

    private void updateInterviewControl() {
        MulComboEdit mulComboEditInterviewCategory = (MulComboEdit)this.getView().getControl("intvcategorylist");
        MulComboEdit mulComboEditInterviewMethod = (MulComboEdit)this.getView().getControl("intvmethodlist");
        BasedataEdit recruitType = (BasedataEdit)this.getControl("recrutype");
        TextEdit nameTextField = (TextEdit)this.getView().getControl("name");
        DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if (msgPushSceneDyn == null) {
            recruitType.setMustInput(false);
            mulComboEditInterviewMethod.setMustInput(false);
            mulComboEditInterviewCategory.setMustInput(false);
            nameTextField.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"name", "recrutype", "recruscene", "msgreceiver", "description", "intvcategorylist", "intvmethodlist", "sendtype"});
            this.getModel().setValue("recrutype", null);
            this.getModel().setValue("recruscene", null);
            this.getModel().setValue("msgreceiver", null);
            this.getModel().setValue("description", null);
            this.getModel().setValue("intvcategorylist", null);
            this.getModel().setValue("intvmethodlist", null);
            this.getModel().setValue("name", null);
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"name", "recrutype", "recruscene", "msgreceiver", "description", "intvcategorylist", "intvmethodlist"});
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("recrutype");
        if (dynamicObject == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"recruscene"});
        }
        nameTextField.setMustInput(true);
        String msgPushSceneNumber = msgPushSceneDyn.getString("id");
        if (Sets.newHashSet((Object[])new String[]{"1020", "1030", "1040"}).contains(msgPushSceneNumber)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"intvcategorylist", "intvmethodlist"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sendtype"});
            mulComboEditInterviewCategory.setMustInput(true);
            mulComboEditInterviewMethod.setMustInput(true);
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"intvcategorylist", "intvmethodlist", "sendtype"});
        mulComboEditInterviewMethod.setMustInput(false);
        mulComboEditInterviewCategory.setMustInput(false);
        this.getModel().setValue("intvcategorylist", null);
        this.getModel().setValue("intvmethodlist", null);
        if ("1080".equals(msgPushSceneNumber)) {
            if (HRStringUtils.isEmpty((String)this.getModel().getValue("emailtheme").toString())) {
                this.getModel().setValue("emailtheme", (Object)"false");
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"sendtype"});
            String sendType = (String)this.getModel().getValue("sendtype");
            if (HRStringUtils.isEmpty((String)sendType)) {
                String offerLetterSendType = this.getOfferLetterSendType();
                this.getModel().setValue("sendtype", (Object)offerLetterSendType);
            }
        }
    }

    private String getOfferLetterSendType() {
        Object sendType = new BizConfigParamHelper().get("tsrbd_offerconfig", "sendtype");
        logger.info("sendType is {}", sendType);
        if (sendType == null) {
            return "";
        }
        return sendType.toString();
    }

    private void updateMsgTempVariablesLabel() {
        DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if (null == msgPushSceneDyn) {
            return;
        }
        DynamicObject msgRecvTypeDyn = this.getModel().getDataEntity().getDynamicObject("msgreceiver");
        if ("1080".equals(msgPushSceneDyn.getString("id"))) {
            this.updateTsrscMsgTempVariablesLabel(msgPushSceneDyn, msgRecvTypeDyn);
        } else {
            this.updateTsirmMsgTempVariablesLabel(msgPushSceneDyn, msgRecvTypeDyn);
            this.hideOrShowMsg();
        }
    }

    private void updateTsrscMsgTempVariablesLabel(DynamicObject msgPushSceneDyn, DynamicObject msgRecvTypeDyn) {
        String msgChannelListStr = this.getModel().getDataEntity().getString("msgchannellist");
        JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
        if (HRStringUtils.isEmpty((String)msgChannelListStr) || pageJson == null) {
            return;
        }
        List channelListId = CfgMsgFormService.getChannelListId((String)msgChannelListStr);
        DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgChannels((List)channelListId);
        if (msgPushSceneDyn == null || msgRecvTypeDyn == null) {
            String flexName = "";
            for (DynamicObject channel : dynamicObjects) {
                flexName = "email".equals(channel.getString("category")) ? "emailvariablesap" : "smsvariablesap";
                CfgMsgFormService.clearMsgTempVariablesLabelData((IFormView)this.getView().getView(pageJson.getString(channel.getString("id"))), (String)flexName);
                this.getView().sendFormAction(this.getView().getView(pageJson.getString(channel.getString("id"))));
            }
            return;
        }
        String currentTab = ((Tab)this.getView().getControl("tabap")).getCurrentTab();
        String currentChannelId = "";
        for (Object entry : pageJson.entrySet()) {
            if (!currentTab.equals(entry.getValue().toString())) continue;
            currentChannelId = (String)entry.getKey();
            break;
        }
        if (HRStringUtils.isEmpty((String)currentChannelId)) {
            int i = 0;
            for (Map.Entry entry : pageJson.entrySet()) {
                if (0 == i) {
                    currentChannelId = (String)entry.getKey();
                    currentTab = entry.getValue().toString();
                }
                ++i;
            }
        }
        String currentCategory = "";
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!currentChannelId.equals(dynamicObject.getString("id"))) continue;
            currentCategory = dynamicObject.getString("category");
            break;
        }
        String sendType = "1";
        if (msgRecvTypeDyn.getLong("id") == 1011L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sendtype"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"sendtype"});
            sendType = (String)this.getModel().getValue("sendtype");
        }
        CfgMsgFormService.reloadMsgTempVariablesLabelData((IFormView)this.getView().getView(currentTab), (Long)msgPushSceneDyn.getLong("id"), (Long)msgRecvTypeDyn.getLong("id"), (Long)Long.valueOf(currentChannelId), (String)currentCategory, (String)sendType);
        this.getView().sendFormAction(this.getView().getView(currentTab));
    }

    private void updateTsirmMsgTempVariablesLabel(DynamicObject msgPushSceneDyn, DynamicObject msgRecvTypeDyn) {
        String[] msgChannels;
        String msgChannelList = this.getModel().getDataEntity().getString("msgchannellist");
        if (msgPushSceneDyn == null || msgRecvTypeDyn == null || msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
            this.clearMsgTempVariablesLabelData();
            return;
        }
        for (String msgChannel : msgChannels = msgChannelList.split(",")) {
            if (HRStringUtils.isEmpty((String)msgChannel)) continue;
            CfgMsgFormService.reloadMsgTempVariablesLabelData((IFormView)this.getView(), (Long)msgPushSceneDyn.getLong("id"), (Long)msgRecvTypeDyn.getLong("id"), (Long)Long.valueOf(msgChannel), (String)"", (String)"1");
        }
    }

    private void clearMsgTempVariablesLabelData() {
        HashMap paramMap = Maps.newHashMap();
        ArrayList labelBOList = new ArrayList(10);
        paramMap.put("items", CfgMsgFormService.createLabelShowPanel(labelBOList).createControl().get("items"));
        this.getView().updateControlMetadata(MSG_TEMPLATE_VARIABLE_FLEX_MAP.get(MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY), (Map)paramMap);
        this.getView().updateControlMetadata(MSG_TEMPLATE_VARIABLE_FLEX_MAP.get(MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY), (Map)paramMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (key.equalsIgnoreCase("save")) {
            this.saveMultiBaseDataFromMultiCombo("recrutyp", "recrutyplist");
            this.saveMultiBaseDataFromMultiCombo("intvcategory", "intvcategorylist");
            this.saveMultiBaseDataFromMultiCombo("intvmethod", "intvmethodlist");
            this.saveMultiBaseDataFromMultiCombo("msgchannel", "msgchannellist");
            this.getModel().setValue("status", (Object)"C");
            DynamicObject msgPushSceneDyn = this.getModel().getDataEntity().getDynamicObject("msgpushscene");
            if ("1080".equals(msgPushSceneDyn.getString("id"))) {
                if (!this.buildTsrscEntry()) {
                    args.setCancel(true);
                    return;
                }
            } else {
                RichTextEditor emailRichText = (RichTextEditor)this.getView().getControl("emailrichtext");
                if (ObjectUtils.isNotEmpty((Object)emailRichText.getText())) {
                    this.getModel().setValue("emailrichtextfd_tag", (Object)emailRichText.getText());
                }
                this.getModel().setValue("emailtheme", (Object)SecurityUtils.htmlEncode((String)this.getModel().getValue("emailtheme").toString()));
                RichTextEditor emailRichTextEditor = (RichTextEditor)this.getView().getControl("emailrichtext");
                if (ObjectUtils.isNotEmpty((Object)emailRichTextEditor)) {
                    String emailRichTextTemplate = HRStringUtils.isBlank((CharSequence)emailRichTextEditor.getText()) ? this.getView().getPageCache().get(this.getView().getPageId()) : emailRichTextEditor.getText();
                    if (HRStringUtils.isBlank((CharSequence)emailRichTextTemplate)) {
                        return;
                    }
                    char[] emailRichTextArray = emailRichTextTemplate.toCharArray();
                    int countSign = 0;
                    for (char emailRichTextChar : emailRichTextArray) {
                        if (emailRichTextChar == '{') {
                            if (++countSign <= 1) continue;
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u5728\u53d8\u91cf\u5f53\u4e2d\u63d2\u5165\u53d8\u91cf\uff0c\u5426\u5219\u53d8\u91cf\u65e0\u6cd5\u53d6\u503c\u3002", (String)"CfgMsgTemplateEdit_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        if (emailRichTextChar != '}') continue;
                        --countSign;
                    }
                }
            }
        }
    }

    private boolean buildTsrscEntry() {
        JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
        JSONObject typeJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_TYPE_JSON"));
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("channelid", new Object[0]);
        setter.addField("category", new Object[0]);
        setter.addField("emailtitle", new Object[0]);
        setter.addField("emailtempcontext", new Object[0]);
        setter.addField("smstempcontext", new Object[0]);
        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u90ae\u4ef6\u4e3b\u9898.", (String)"CfgMsgTemplateEdit_4", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
        for (Map.Entry entry : pageJson.entrySet()) {
            IFormView tabView = this.getView().getView(entry.getValue().toString());
            if (null == tabView) continue;
            String category = tabView.getPageCache().get("category");
            Object smsTemplate = null;
            String emailTheme = null;
            String emailRichText = null;
            if (HRStringUtils.isEmpty((String)category)) {
                if (0 == entryEntity.size() && "email".equals(typeJson.getString((String)entry.getKey()))) {
                    this.getView().showTipNotification(msg);
                    return false;
                }
                for (DynamicObject dynamicObject : entryEntity) {
                    if (!((String)entry.getKey()).equals(dynamicObject.getString("channelid"))) continue;
                    category = dynamicObject.getString("category");
                    emailTheme = dynamicObject.getString("emailtitle");
                    emailRichText = dynamicObject.getString("emailtempcontext");
                    smsTemplate = dynamicObject.getString("smstempcontext");
                    break;
                }
            } else if ("email".equals(category)) {
                emailTheme = SecurityUtils.htmlEncode((String)tabView.getModel().getValue("emailtheme").toString());
                if (HRStringUtils.isEmpty((String)emailTheme)) {
                    this.getView().showTipNotification(msg);
                    return false;
                }
                emailRichText = ((RichTextEditor)tabView.getControl("emailrichtext")).getText();
            } else {
                smsTemplate = tabView.getModel().getValue("smstemplate");
            }
            setter.addRow(new Object[]{Long.valueOf((String)entry.getKey()), category, emailTheme, emailRichText, smsTemplate});
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
        return true;
    }

    private void saveMultiBaseDataFromMultiCombo(String multiBdField, String multiComboField) {
        String comboList = this.getModel().getDataEntity().getString(multiComboField);
        if (comboList == null || HRStringUtils.isEmpty((String)comboList)) {
            return;
        }
        String[] split = comboList.split(",");
        List baseDataIds = Stream.of(split).filter(txx -> !HRStringUtils.isEmpty((String)txx)).map(xx -> Long.parseLong(xx)).collect(Collectors.toList());
        this.getModel().setValue(multiBdField, (Object)baseDataIds.toArray());
    }

    private void setRichTextClickLabel(String variateName) {
        String variableValue = "{" + variateName + "}";
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("emailrichtext", "insertText", new Object[]{variableValue});
        RichTextEditor emailRichText = (RichTextEditor)this.getView().getControl("emailrichtext");
        if (HRStringUtils.isBlank((CharSequence)emailRichText.getText())) {
            variableValue = "<p>" + variableValue + "</p>";
            this.getView().getPageCache().put(this.getView().getPageId(), variableValue);
            this.getModel().setValue("emailrichtextfd_tag", (Object)variableValue);
        }
    }

    private void setMultiTextClickLabel(String variateName, String multiTextEdit) {
        String variableValue = "{" + variateName + "}";
        String value = (String)this.getModel().getValue(multiTextEdit);
        this.getModel().setValue(multiTextEdit, (Object)(value + variableValue));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        NotDataChangeUtils.setPropertyNotDataChanged((IDataModel)this.getModel(), (String[])new String[]{"sendtype"});
    }

    static {
        MSG_TEMPLATE_VARIABLE_FLEX_MAP.put(MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY, "flexpanelap131211");
        MSG_TEMPLATE_VARIABLE_FLEX_MAP.put(MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY, "flexpanelap1312111");
        MSG_TEMPLATE_FLEX_MAP.put(MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY, "tabpageap");
        MSG_TEMPLATE_FLEX_MAP.put(MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY, "tabpageap1");
    }
}

