/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.cfgmsgtemplate;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Html;
import kd.bos.form.events.CustomEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.common.constants.MsgTplConstants;
import org.apache.commons.lang3.ObjectUtils;

public class MsgTemplatePreviewEdit
extends HRDynamicFormBasePlugin {
    public static final String SLIDE_MOTION = "afterShowSlideBill";
    private static Map<Long, String> msgTempFlexMap = new HashMap<Long, String>(16);

    public void registerListener(EventObject event) {
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        IAppCache iAppCache = AppCache.get((String)"tsc_tsrbd_msgtemplate");
        Tab tab = (Tab)this.getView().getControl("tabap");
        String tabKey = (String)iAppCache.get("pagenumber", String.class);
        if (HRStringUtils.isNotEmpty((String)tabKey)) {
            tab.activeTab(tabKey);
        }
        this.updateTemplateContent();
        this.attachmentHandle(iAppCache);
        this.updateMessageTemplateLabel();
    }

    private void attachmentHandle(IAppCache iAppCache) {
        String objId = (String)iAppCache.get("offerattachobjid", String.class);
        if (HRStringUtils.isEmpty((String)objId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap"});
            return;
        }
        iAppCache.remove("offerattachobjid");
        IAppCache appCache = AppCache.get((String)"offerattach_preview");
        List data = (List)appCache.get(objId, List.class);
        if (data == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap"});
            return;
        }
        for (Map attach : data) {
            attach.remove("previewurl");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanelap"});
        AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentpanelap.bindData(data);
    }

    private String getCurrentTab() {
        String[] msgChannels;
        IAppCache iAppCache = AppCache.get((String)"tsc_tsrbd_msgtemplate");
        String msgChannelList = (String)iAppCache.get("msgchannellist", String.class);
        if (ObjectUtils.isEmpty((Object)msgChannelList)) {
            return null;
        }
        for (String msgChannel : msgChannels = msgChannelList.split(",")) {
            if (HRStringUtils.isEmpty((String)msgChannel)) continue;
            return msgTempFlexMap.get(Long.valueOf(msgChannel));
        }
        return null;
    }

    public void customEvent(CustomEventArgs args) {
        if (SLIDE_MOTION.equals(args.getKey())) {
            this.getView().invokeOperation("refresh");
            this.updateTemplateContent();
            this.updateMessageTemplateLabel();
        }
    }

    private void updateTemplateContent() {
        IAppCache iAppCache = AppCache.get((String)"tsc_tsrbd_msgtemplate");
        String sysTemplate = (String)iAppCache.get("smstemplate", String.class);
        String yzjTemplate = (String)iAppCache.get("yzjtemplate", String.class);
        String emailTemplate = (String)iAppCache.get("emailtemplate", String.class);
        if (ObjectUtils.isEmpty((Object)sysTemplate)) {
            sysTemplate = " ";
        }
        Html html = (Html)this.getView().getControl("htmlap");
        html.setConent(emailTemplate);
        if (ObjectUtils.isEmpty((Object)emailTemplate)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodataimageap", "nodatalabelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nodataimageap", "nodatalabelap"});
        }
        this.updateCustomControlContent("customcontrolap1", sysTemplate);
        this.updateCustomControlContent("customcontrolap", yzjTemplate);
    }

    private void updateCustomControlContent(String customControlName, String content) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(customControlName);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("text", content);
        customcontrol.setData(data);
    }

    private void updateMessageTemplateLabel() {
        String[] msgChannels;
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap", "tabpageap1", "tabpageap2"});
        IAppCache iAppCache = AppCache.get((String)"tsc_tsrbd_msgtemplate");
        String msgChannelList = (String)iAppCache.get("msgchannellist", String.class);
        if (msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
            return;
        }
        for (String msgChannel : msgChannels = msgChannelList.split(",")) {
            if (HRStringUtils.isEmpty((String)msgChannel)) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{msgTempFlexMap.get(Long.valueOf(msgChannel))});
        }
    }

    public void destory() {
        super.destory();
    }

    static {
        msgTempFlexMap.put(MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY, "tabpageap");
        msgTempFlexMap.put(MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY, "tabpageap1");
        msgTempFlexMap.put(MsgTplConstants.YZJ_CHANNEL_PRIMARY_KEY, "tabpageap2");
    }
}

