/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.cfgresurule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.cfgresurule.service.CfgResumeRuleHelper;

public class CfgResumeRule
extends HRDataBaseEdit {
    private static final String KEY_FILTER_GRID = "filtergridap";
    private static final String KEY_FILTER_VALUE = "filtervalue_tag";
    private static Set<String> RESUME_FIELD_KEY_LIST = Sets.newHashSetWithExpectedSize((int)10);
    public static final String BTN_CLOSE = "btnclose1";
    private ArrayList<String> fieldList = null;
    private HashMap<String, ILocaleString> fieldNameLangMap = null;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTER_GRID);
        filterGrid.setEntityNumber("tsrbd_resumelist");
        Tuple arrayListHashMapTuple = CfgResumeRuleHelper.generateFilterFieldKeys();
        this.fieldList = (ArrayList)arrayListHashMapTuple.item1;
        this.fieldNameLangMap = (HashMap)arrayListHashMapTuple.item2;
        filterGrid.setFilterFieldKeys(this.fieldList);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.VIEW == status) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave", "btncancel"});
            filterGrid.setEnabled(false);
        } else if (OperationStatus.EDIT == status) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CLOSE});
            Object pkId = this.getModel().getValue("id");
            StringBuilder sb = new StringBuilder();
            boolean result = MutexHelper.require((IFormView)this.getView(), (String)"tsrbd_cfgresurule", (Object)pkId, (String)"modify", (boolean)true, (StringBuilder)sb);
            if (!result) {
                this.getView().showConfirm(sb.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete", (IFormPlugin)this));
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave", "btncancel"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CLOSE});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.getView().setStatus(OperationStatus.VIEW);
        } else {
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            this.getModel().setValue("dependorg", (Object)RequestContext.get().getOrgId());
            this.getModel().setDataChanged(false);
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTER_GRID);
        FilterCondition filterCondition = this.loadFilter();
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList sortFilterColumns = Lists.newArrayListWithCapacity((int)this.fieldList.size());
        int size = this.fieldList.size();
        for (Map column : filterColumns) {
            String fieldName = (String)column.get("fieldName");
            ILocaleString name = this.fieldNameLangMap.get(fieldName);
            if (name == null) continue;
            column.put("fieldCaption", name.getLocaleValue());
            if (RESUME_FIELD_KEY_LIST.contains(fieldName)) {
                column.put("type", "text");
                column.put("entityId", "bos_multitext");
            }
            sortFilterColumns.add(column);
        }
        filterGrid.setFilterColumns((List)sortFilterColumns);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                this.billSavePreProcess(args);
                break;
            }
        }
    }

    private void billSavePreProcess(BeforeDoOperationEventArgs args) {
        FilterCondition filterCondition = this.getFilterCondition();
        QFilter qFilterFromFilterCondition = CfgResumeRuleHelper.getQFilterFromFilterCondition((String)"tsrbd_resumelist", (FilterCondition)filterCondition);
        if (qFilterFromFilterCondition == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u62db\u8058\u804c\u4f4d\u8981\u6c42\u3002", (String)"CfgResumeRule_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String filterValue = this.convertFilterToString(filterCondition);
        this.getModel().setValue(KEY_FILTER_VALUE, (Object)filterValue);
        this.getModel().setValue("status", (Object)"C");
    }

    private FilterCondition getFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTER_GRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private FilterCondition loadFilter() {
        String filterValue = this.getModel().getDataEntity().getString(KEY_FILTER_VALUE);
        if (HRStringUtils.isEmpty((String)filterValue)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterValue, FilterCondition.class);
        return filterCondition;
    }

    private String convertFilterToString(FilterCondition filterCondition) {
        String filterValue = null;
        if (filterCondition != null) {
            filterValue = SerializationUtils.toJsonString((Object)filterCondition);
        }
        return filterValue;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "close": {
                MutexHelper.release((IFormView)this.getView());
                break;
            }
        }
    }

    static {
        RESUME_FIELD_KEY_LIST.add("tstpm_rsmeduexp.specialtyname");
        RESUME_FIELD_KEY_LIST.add("tstpm_rsmeduexp.classrank");
        RESUME_FIELD_KEY_LIST.add("tstpm_rsminterexp.workunit");
        RESUME_FIELD_KEY_LIST.add("tstpm_rsmworkexp.positionname");
        RESUME_FIELD_KEY_LIST.add("tstpm_rsmworkexp.companyname");
    }
}

