/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.formplugin.web.channel;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.channel.service.ChannelService;
import kd.tsc.tsrbd.business.domain.channel.service.RecruchnPermHelper;
import kd.tsc.tsrbd.business.domain.channel.service.RecruchnlnmService;
import kd.tsc.tsrbd.common.utils.ChannelUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class ChannelAccountEdit
extends HRDataBaseEdit {
    public static final String KEY_SELECEY = "selecty";
    public static final String KEY_SELECEN = "selectn";
    public static final String ISPUBLIC = "ispublic";
    private boolean selectChange = true;

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        OperationStatus status = args.getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6e20\u9053\u8d26\u53f7", (String)"ChannelAccountEdit_0", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        } else {
            args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u6e20\u9053\u8d26\u53f7", (String)"ChannelAccountEdit_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject obj) {
        String noPermFlag = (String)this.getView().getFormShowParameter().getCustomParam("no_perm_flag");
        if (HRStringUtils.isNotEmpty((String)noPermFlag) && noPermFlag.equals("1")) {
            this.getView().showTipNotification(RecruchnPermHelper.getInstance().getChannelAccountEditTip());
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            return;
        }
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus() && this.checkEditPermission() && !this.checkIsCreator()) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject args) {
        super.afterBindData(args);
        boolean isPerN = "1".equals(this.getModel().getValue(ISPUBLIC));
        if (isPerN) {
            this.getModel().setValue(KEY_SELECEN, (Object)Boolean.TRUE);
        } else {
            this.getModel().setValue(KEY_SELECEY, (Object)Boolean.TRUE);
        }
        this.getModel().setValue("createorg", (Object)TSCRequestContext.getOrgId());
        IFormView parentView = this.getView().getParentView().getParentView();
        this.checkParentView(parentView);
        this.getModel().setDataChanged(false);
        this.checkLockAccount();
        this.checkBtnClose();
    }

    public void checkParentView(IFormView parentView) {
        if (parentView != null && "tsrbd_recruchnlnm".equals(parentView.getFormShowParameter().getFormId())) {
            this.getModel().setValue("recruchnlnm", parentView.getModel().getValue("id"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"recruchnlnm"});
        }
    }

    private void checkBtnClose() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean isView = status.equals((Object)OperationStatus.VIEW);
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{"btnclose"});
        this.setModel(isView);
    }

    public void setModel(boolean isView) {
        this.getView().setVisible(Boolean.valueOf(!isView), new String[]{"btnsave"});
        this.getView().setVisible(Boolean.valueOf(!isView), new String[]{"btncancel"});
    }

    private boolean checkEditPermission() {
        boolean isEdit = true;
        this.getView().getFormShowParameter().getCustomParam("edit");
        Long orgId = this.getModel().getDataEntity().getDynamicObject("createorg").getLong("id");
        if (!RecruchnlnmService.checkOpPermission((String)"tsrbd_channelaccount", (String)"4715a0df000000ac", (Long)orgId)) {
            isEdit = false;
            this.getView().showTipNotification(ChannelService.getEditFailChannelPermissionError());
        }
        return isEdit;
    }

    private void checkLockAccount() {
        long id = this.getModel().getDataEntity().getLong("id");
        List failResult = ChannelService.checkOpChannelAccount(Collections.singletonList(id));
        if (failResult.size() > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_SELECEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_SELECEN});
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"recruchnlnm"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChannelUtils channelUtils;
        boolean chineseStr;
        this.handleSelect(args);
        String keyWord = "password";
        String key = args.getProperty().getName();
        if (keyWord.equals(key) && (chineseStr = (channelUtils = new ChannelUtils()).isChineseStr(this.getModel().getDataEntity().getString(keyWord)))) {
            FieldTip posCoordinateTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, keyWord, ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u6709\u6c49\u5b57", (String)"ChannelAccountEdit_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
            this.getView().showFieldTip(posCoordinateTip);
        }
    }

    private void handleSelect(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        boolean isSelecty = KEY_SELECEY.equals(key);
        if (isSelecty || KEY_SELECEN.equals(key)) {
            if (!this.selectChange) {
                return;
            }
            this.selectChange = false;
            if (!isSelecty) {
                Long orgId = TSCRequestContext.getOrgId();
                this.getModel().setValue("createorg", (Object)orgId);
            }
            this.getModel().setValue(KEY_SELECEY, (Object)isSelecty);
            this.getModel().setValue(KEY_SELECEN, (Object)(!isSelecty ? 1 : 0));
            this.getView().setEnable(Boolean.valueOf(isSelecty), new String[]{"createorg"});
            this.getModel().setValue(ISPUBLIC, (Object)Character.valueOf(isSelecty ? (char)'0' : '1'));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("modify".equals(operateKey) && (operationResult = afterDoOperationEventArgs.getOperationResult()) != null && operationResult.isSuccess()) {
            this.checkIsCreator();
        }
    }

    public boolean checkIsCreator() {
        Long userId;
        boolean isCreator = true;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        long create = this.getModel().getDataEntity().getDynamicObject("creator").getLong("id");
        if (create != (userId = Long.valueOf(TSCRequestContext.getUserId()))) {
            isCreator = false;
            if (OperationStatus.EDIT.equals((Object)status)) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanelnew"});
            this.getView().showTipNotification("\u4ec5\u80fd\u4fee\u6539\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e");
        }
        return isCreator;
    }
}

